/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.File;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;

public class JCRFile
implements File {
    private static GCUBEClientLog logger = new GCUBEClientLog(JCRFile.class, new Properties[0]);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    protected String nodeId;
    private String mimeType;
    private long size;

    public JCRFile(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
        try {
            this.mimeType = node.getProperty(MIME_TYPE).getString();
        }
        catch (Exception e) {
            this.mimeType = "application/octet-stream";
        }
        this.size = node.getProperty(SIZE).getLong();
    }

    public JCRFile(Node node, String mimeType, InputStream data) throws RepositoryException, RemoteBackendException {
        String remotePath = Text.getRelativeParent((String)node.getPath(), (int)2) + UUID.randomUUID().toString();
        String url = GCUBEStorage.putStream(data, remotePath);
        logger.trace((Object)("GCUBEStorage URL : " + url));
        ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
        Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
        this.size = GCUBEStorage.getRemoteFileSize(remotePath);
        node.setProperty(SIZE, this.size);
        node.setProperty(DATA, binary);
        node.setProperty(MIME_TYPE, mimeType);
        node.setProperty(REMOTE_STORAGE_PATH, remotePath);
        this.mimeType = mimeType;
    }

    public void save(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
    }

    public JCRFile(Node node, InputStream data) throws RepositoryException, RemoteBackendException {
        this(node, MimeTypeUtil.getMimeType((InputStream)data), data);
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getName();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            String remotePath = null;
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace((Object)"Old retrieve content method");
            }
            if (remotePath != null) {
                logger.trace((Object)"Content retrieved from remote storage...");
                InputStream e = GCUBEStorage.getRemoteFile(remotePath);
                return e;
            }
            Binary data = node.getProperty(DATA).getBinary();
            try {
                logger.trace((Object)"Content moved to remote storage");
                remotePath = Text.getRelativeParent((String)node.getPath(), (int)2) + UUID.randomUUID().toString();
                String url = GCUBEStorage.putStream(data.getStream(), remotePath);
                logger.trace((Object)("New gcube storage url : " + url));
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                node.setProperty(DATA, binary);
                node.setProperty(REMOTE_STORAGE_PATH, remotePath);
                session.save();
            }
            catch (Exception e) {
                logger.error((Object)"The item doesn't contain hl:remotePath property");
            }
            InputStream inputStream = data.getStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public long getLength() throws InternalErrorException {
        return this.size;
    }
}

