/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRTabularDataLink
extends JCRWorkspaceFolderItem
implements TabularDataLink {
    private static final String NT_CONTENT = "nthl:externalResourceLinkContent";
    private static final String TABLE_ID = "";
    private static final String TABLE_TEMPLATE = "";
    private static final String PROVENANCE = "";
    private static final String RUNTIME_RESOURCE = "";
    private String tableId;
    private String template;
    private String provenance;
    private String runtimeResource;

    public JCRTabularDataLink(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.tableId = contentNode.getProperty("").getString();
        this.template = contentNode.getProperty("").getString();
        this.provenance = contentNode.getProperty("").getString();
        this.runtimeResource = contentNode.getProperty("").getString();
    }

    public JCRTabularDataLink(JCRWorkspace workspace, Node node, String name, String description, String tableId, String template, String provenance, String runtimeResource) throws RepositoryException {
        super(workspace, node, name, description);
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty("", tableId);
        contentNode.setProperty("", template);
        contentNode.setProperty("", provenance);
        contentNode.setProperty("", runtimeResource);
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getProvenance() {
        return this.provenance;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.TABULAR_DATA_LINK;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    public String getDBRuntimeResource() {
        return this.runtimeResource;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }

    public String getOperator() {
        return null;
    }
}

