/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class JCRWorkspaceSharedFolder
extends JCRAbstractWorkspaceFolder
implements WorkspaceSharedFolder {
    public static final String USERS = "hl:users";
    private String destinationFolderId;
    private List<String> users;

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
    }

    public JCRWorkspaceSharedFolder(JCRWorkspace workspace, Node node, String name, String description, String destinationFolderId, List<String> users) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description);
        super.save(node);
        this.destinationFolderId = destinationFolderId;
        this.users = users;
    }

    @Override
    public void save(Node node) throws RepositoryException {
        try {
            this.addUser(node, this.workspace.getOwner().getPortalLogin(), this.destinationFolderId);
            for (String user : this.users) {
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                GCUBEScope scopeOwner = this.workspace.getOwner().getScope();
                Home home = homeManager.getHome(user, scopeOwner);
                this.addUser(node, user, home.getWorkspace().getRoot().getId());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Node getUserNode(Node node, String user) throws RepositoryException, InternalErrorException {
        Node usersNode = node.getNode(USERS);
        String value = usersNode.getProperty(user).getString();
        String[] values = value.split(this.workspace.getPathSeparator());
        if (values.length < 2) {
            throw new InternalErrorException("Path node corrupt");
        }
        String parentId = values[0];
        String nodeName = values[1];
        Node parentNode = node.getSession().getNodeByIdentifier(parentId);
        return node.getSession().getNode(String.valueOf(parentNode.getPath()) + this.workspace.getPathSeparator() + nodeName);
    }

    private Node getUserNode(Node node) throws RepositoryException, InternalErrorException {
        return this.getUserNode(node, this.workspace.getOwner().getPortalLogin());
    }

    private String getNodeName(Node node) throws RepositoryException, InternalErrorException {
        String[] names = node.getPath().split(this.workspace.getPathSeparator());
        return names[names.length - 1];
    }

    @Override
    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            Node userNode = this.getUserNode(node);
            if (this.workspace.exists(nodeNewName, userNode.getParent().getIdentifier())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = String.valueOf(userNode.getParent().getPath()) + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.RENAMED.toString());
            node.getSession().save();
            String path = userNode.getPath();
            node.getSession().getWorkspace().move(path, newPath);
            Node usersNode = node.getNode(USERS);
            String value = String.valueOf(userNode.getParent().getIdentifier()) + this.workspace.getPathSeparator() + newName;
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier());
            Session session = destinationFolderNode.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty("jcr:lastModified", Calendar.getInstance());
            node.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            node.setProperty("hl:lastAction", WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            Node userNode = this.getUserNode(node);
            String userNodeName = this.getNodeName(userNode);
            String newPath = String.valueOf(destinationFolderNode.getPath()) + this.workspace.getPathSeparator() + userNodeName;
            String value = String.valueOf(destinationFolderNode.getIdentifier()) + this.workspace.getPathSeparator() + userNodeName;
            session.getWorkspace().clone(session.getWorkspace().getName(), node.getPath(), newPath, false);
            Node usersNode = node.getNode(USERS);
            usersNode.setProperty(this.workspace.getOwner().getPortalLogin(), value);
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node unShareNode(Node sharedNode, Node destinationNode) throws RepositoryException, InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException, ItemNotFoundException, RemoteBackendException {
        Session session = sharedNode.getSession();
        Node userNode = this.getUserNode(sharedNode);
        String folderName = this.getNodeName(userNode);
        String description = this.getDescription();
        if (destinationNode.getIdentifier().equals(userNode.getParent().getIdentifier())) {
            this.removeUserSharedFolder(sharedNode);
        }
        String unSharedFolderId = this.workspace.createFolder(folderName, description, destinationNode.getIdentifier()).getId();
        Node nodeFolder = session.getNodeByIdentifier(unSharedFolderId);
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:")) continue;
            session.getWorkspace().copy(child.getPath(), String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + child.getName());
        }
        this.workspace.copyRemoteContent(nodeFolder, destinationNode);
        session.save();
        this.checkRemoveSharedFolder(sharedNode);
        return nodeFolder;
    }

    @Override
    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Session session = nodeFolder.getSession();
        Node node = session.getNodeByIdentifier(this.identifier);
        String pathNewNode = String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
        try {
            if (session.getNode(pathNewNode) != null) {
                throw new ItemAlreadyExistException(String.valueOf(newName) + " already exist");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            Node newNode = this.unShareNode(node, nodeFolder);
            newNode.setProperty("jcr:lastModified", Calendar.getInstance());
            newNode.setProperty("jcr:lastModifiedBy", this.workspace.getOwner().getPortalLogin());
            newNode.setProperty("jcr:title", newName);
            newNode.setProperty("hl:lastAction", WorkspaceItemAction.CLONED.toString());
            newNode.getSession().save();
            return newNode;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(this.getUserNode(node));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        Node userNode = this.getUserNode(node);
        return String.valueOf(((JCRWorkspaceFolder)this.getParent(userNode)).getPath(userNode.getParent())) + this.workspace.getPathSeparator() + this.getNodeName(userNode);
    }

    private void removeUserSharedFolder(Node sharedNode) throws InternalErrorException {
        try {
            Session session = sharedNode.getSession();
            Node userNode = this.getUserNode(sharedNode);
            Node usersNode = sharedNode.getNode(USERS);
            usersNode.getProperty(this.workspace.getOwner().getPortalLogin()).remove();
            session.removeItem(userNode.getPath());
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void checkRemoveSharedFolder(Node sharedNode) throws InternalErrorException, RemoteBackendException {
        if (this.getUsers().isEmpty()) {
            try {
                try {
                    this.workspace.removeRemoteContent(sharedNode, null);
                }
                catch (Exception e) {
                    logger.warn(String.valueOf(sharedNode.getName()) + " payload not available", (Throwable)e);
                }
                sharedNode.remove();
                sharedNode.getSession().save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    @Override
    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        Session session = JCRRepository.getSession();
        try {
            try {
                Node sharedNode = session.getNodeByIdentifier(this.getId());
                this.removeUserSharedFolder(sharedNode);
                this.checkRemoveSharedFolder(sharedNode);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                Node usersNode = node.getNode(USERS);
                PropertyIterator iterator = usersNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    String name = property.getName();
                    if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                    list.add(name);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return list;
    }

    private void addUser(Node sharedNode, String user, String destinationFolderId) throws InternalErrorException {
        try {
            Session session = sharedNode.getSession();
            HomeManager homeManager = this.workspace.getHome().getHomeManager();
            WorkspaceFolder userRoot = (WorkspaceFolder)homeManager.getHome(user, null).getWorkspace().getItem(destinationFolderId);
            Node rootNode = session.getNodeByIdentifier(userRoot.getId());
            String sharedFolderName = WorkspaceUtil.getUniqueName((String)sharedNode.getProperty("jcr:title").getString(), (WorkspaceFolder)userRoot);
            String pathUser = String.valueOf(rootNode.getPath()) + this.workspace.getPathSeparator() + sharedFolderName;
            Node usersNode = sharedNode.getNode(USERS);
            try {
                if (usersNode.getProperty(user) != null) {
                    return;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug("User is not present");
            }
            session.getWorkspace().clone(session.getWorkspace().getName(), sharedNode.getPath(), pathUser, false);
            String value = String.valueOf(userRoot.getId()) + this.workspace.getPathSeparator() + sharedFolderName;
            usersNode.setProperty(user, value);
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addUser(String user) throws InsufficientPrivilegesException, InternalErrorException {
        session = JCRRepository.getSession();
        try {
            sharedNode = session.getNodeByIdentifier(this.getId());
            usersNode = sharedNode.getNode("hl:users");
            try {
                if (usersNode.getProperty(user) != null) {
                    return;
                }
                ** GOTO lbl13
            }
            catch (PathNotFoundException e) {
                try {
                    JCRWorkspaceSharedFolder.logger.debug("User " + user + " is not present");
lbl13:
                    // 2 sources

                    homeManager = this.workspace.getHome().getHomeManager();
                    scopeOwner = this.workspace.getOwner().getScope();
                    home = homeManager.getHome(user, scopeOwner);
                    this.addUser(sharedNode, user, home.getWorkspace().getRoot().getId());
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
        }
        finally {
            session.logout();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.SHARED_FOLDER;
    }

    public WorkspaceFolder unShare() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node userNode = this.getUserNode(node);
            Node unsharedNode = this.unShareNode(node, userNode.getParent());
            JCRWorkspaceFolder jCRWorkspaceFolder = new JCRWorkspaceFolder(this.workspace, unsharedNode);
            return jCRWorkspaceFolder;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder share(List<String> users) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        for (String user : users) {
            this.addUser(user);
        }
        return this;
    }

    public String getName(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node sharedNode = session.getNodeByIdentifier(this.getId());
            Node userNode = this.getUserNode(sharedNode, user);
            String string = this.getNodeName(userNode);
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

