/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryCreate;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryCreate extends JCRAccountingEntry implements AccountingEntryCreate {

	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryCreate(Node node) throws RepositoryException {
		super(node);
		// TODO Auto-generated constructor stub
	}
	
	public JCRAccountingEntryCreate(String user, Calendar date) {
		super(user,date);
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.CREATE;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s]]",parentValue, getEntryType());
	}

}
