/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryCreate;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryUpdate;

/**
 * @author Valentina Marioli valentina.marioli@isti.cnr.it
 *
 */
public class JCRAccountingEntryUpdate extends JCRAccountingEntry implements AccountingEntryUpdate {
	
	private static String ITEM_NAME 			= "hl:itemName";
	
	protected String itemName;

	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryUpdate(Node node) throws RepositoryException {
		
		super(node);
		this.itemName =  node.getProperty(ITEM_NAME).getString();

	}
	
	public JCRAccountingEntryUpdate(String user, Calendar date, String nodeName) {
		super(user,date);
		
		this.itemName = nodeName;
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.UPDATE;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s]]",parentValue, getEntryType());
	}
	
	
	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);
		
		entryNode.setProperty(ITEM_NAME, itemName);
	}
	
	@Override
	public String getItemName() {		
		return itemName;
	}

}
