/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchItem;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.jcr.home.JCRHome;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceSmartFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRAquaMapsItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRTabularDataLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkflowTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRAnnotation;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRExternalResourceLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRImageDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRMetadata;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRPDFDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRUrlDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRImageDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRPDFDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.portlets.user.homelibrary.util.Util;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspace
extends AbstractWorkspaceEventSource
implements Workspace {
    private static final String WORKSPACE_ROOT_FOLDER = "Workspace";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";
    public static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    public static final String NT_WORKSPACE_FILE = "nthl:externalFile";
    public static final String NT_WORKSPACE_IMAGE = "nthl:externalImage";
    public static final String NT_WORKSPACE_PDF_FILE = "nthl:externalPdf";
    public static final String NT_WORKSPACE_URL = "nthl:externalUrl";
    public static final String NT_WORKSPACE_REPORT = "nthl:report";
    public static final String NT_WORKSPACE_REPORT_TEMPLATE = "nthl:reportTemplate";
    public static final String NT_WORKSPACE_WORKFLOW_REPORT = "nthl:workflowReport";
    public static final String NT_WORKSPACE_WORKFLOW_TEMPLATE = "nthl:workflowTemplate";
    public static final String NT_ANNOTATION_ITEM = "nthl:gCubeAnnotation";
    public static final String NT_ANNOTATION_LINK_ITEM = "nthl:gCubeAnnotationLink";
    public static final String NT_DOCUMENT_ITEM = "nthl:gCubeDocument";
    public static final String NT_DOCUMENT_LINK_ITEM = "nthl:gCubeDocumentLink";
    public static final String NT_IMAGE_DOCUMENT_ITEM = "nthl:gCubeImageDocument";
    public static final String NT_IMAGE_DOCUMENT_LINK_ITEM = "nthl:gCubeImageDocumentLink";
    public static final String NT_PDF_DOCUMENT_ITEM = "nthl:gCubePDFDocument";
    public static final String NT_PDF_DOCUMENT_LINK_ITEM = "nthl:gCubePDFDocumentLink";
    public static final String NT_URL_DOCUMENT_ITEM = "nthl:gCubeURLDocument";
    public static final String NT_METADATA_ITEM = "nthl:gCubeMetadata";
    public static final String NT_METADATA_LINK_ITEM = "nthl:gCubeMetadataLink";
    public static final String NT_AQUAMAPS_ITEM = "nthl:aquamapsItem";
    public static final String NT_TIMESERIES_ITEM = "nthl:timeSeriesItem";
    public static final String NT_QUERY = "nthl:query";
    public static final String NT_EXTERNAL_RESOURCE_LINK_ITEM = "nthl:externalResourceLink";
    public static final String NT_TABULAR_DATA_LINK = "nthl:tabularDataLink";
    private static final String NT_BOOKMARK = "nthl:bookmark";
    private static final String NT_FILE = "nt:file";
    private static final String CONTENT = "jcr:content";
    private String scope;
    private final Home home;
    private final JCRRepository repository;
    private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;
    private JCRWorkspaceFolder root;
    private JCRWorkspaceMessageManager sendRequestManager;
    private Logger logger;

    public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {
        this.scope = null;
        this.home = home;
        this.repository = repository;
        this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);
        this.logger = LoggerFactory.getLogger(JCRWorkspace.class);
        Session session = JCRRepository.getSession();
        String pathRoot = null;
        try {
            Node userHome = repository.getUserHome(session);
            Node node = null;
            try {
                node = userHome.addNode(WORKSPACE_ROOT_FOLDER, NT_WORKSPACE_FOLDER);
                this.root = new JCRWorkspaceFolder(this, node, WORKSPACE_ROOT_FOLDER, "The root");
                this.root.save(node);
            }
            catch (ItemExistsException e) {
                node = userHome.getNode(WORKSPACE_ROOT_FOLDER);
                this.root = new JCRWorkspaceFolder(this, node);
            }
            pathRoot = node.getPath();
        }
        catch (RepositoryException e) {
            this.logger.error("Root WorkspaceFolder failed creation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        JCRRepository.setACL(home.getOwner().getPortalLogin(), pathRoot);
    }

    public JCRWorkspace(JCRHome home) {
        this.home = home;
        this.repository = null;
        this.folderBulkCreatorsManager = null;
    }

    private Node addChildNode(Session session, String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException {
        Node parent;
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error("The name  " + nodeName + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        try {
            parent = session.getNodeByIdentifier(parentId);
            if (!(parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER) || parent.getPrimaryNodeType().getName().equals("nt:folder"))) {
                throw new WrongDestinationException("Not is a folder");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Destination folder not found");
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        try {
            String name = Text.escapeIllegalJcrChars((String)nodeName);
            Node node = parent.addNode(name, nodeType);
            return node;
        }
        catch (ItemExistsException e) {
            this.logger.error("Item already exist");
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            this.logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPathSeparator() {
        return "/";
    }

    public Home getHome() {
        return this.home;
    }

    public JCRRepository getRepository() {
        return this.repository;
    }

    public User getOwner() {
        return this.home.getOwner();
    }

    public WorkspaceFolder getRoot() {
        return this.getRoot(null);
    }

    public WorkspaceFolder getRoot(GCUBEScope scope) {
        this.scope = scope == null ? null : scope.toString();
        return this.root;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace folder");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(folder.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), folder.getType(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getFolderItemType() : null, folder.getName(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.error("Error setting add accounting entry for " + folder.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external image");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_IMAGE);
            JCRExternalImage item = new JCRExternalImage(this, node, name, description, mimeType, imageData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalImage jCRExternalImage = item;
            return jCRExternalImage;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FILE);
            JCRExternalFile item = new JCRExternalFile(this, node, name, description, mimeType, fileData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalFile jCRExternalFile = item;
            return jCRExternalFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external pdf file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_PDF_FILE);
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node, name, description, mimeType, fileData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalPDFFile jCRExternalPDFFile = item;
            return jCRExternalPDFFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, String url, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external url");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_URL);
            JCRExternalUrl item = new JCRExternalUrl(this, node, name, description, url);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRExternalUrl jCRExternalUrl = item;
            return jCRExternalUrl;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, InputStream url, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String urlString;
        try {
            urlString = Util.readStreamAsString((InputStream)url);
        }
        catch (IOException e) {
            throw new InternalErrorException("Error converting url from input stream to string.");
        }
        return this.createExternalUrl(name, description, urlString, destinationFolderId);
    }

    public ReportTemplate createReportTemplate(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Created report template");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT_TEMPLATE);
            JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);
            reportTemplate.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(reportTemplate.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), reportTemplate.getType(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getFolderItemType() : null, reportTemplate.getName(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + reportTemplate.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(reportTemplate);
            JCRReportTemplate jCRReportTemplate = reportTemplate;
            return jCRReportTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Report createReport(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create report");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT);
            JCRReport item = new JCRReport(this, node, name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRReport jCRReport = item;
            return jCRReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, String query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create query");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_QUERY);
            JCRQuery item = new JCRQuery(this, node, name, description, query, queryType);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRQuery jCRQuery = item;
            return jCRQuery;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, InputStream query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        try {
            return this.createQuery(name, description, Util.readStreamAsString((InputStream)query), queryType, destinationFolderId);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder createAquaMapsItem(String name, String description, String mapName, String mapType, String author, int numberOfSpecies, String boundingBox, float psoThreshold, int numberOfGeneratedImages, InputStream metadata, Map<String, InputStream> images, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        JCRWorkspaceFolder folder;
        this.logger.trace("Create aquamaps item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            String fileName = WorkspaceUtil.getUniqueName((String)"metadata.xml", (WorkspaceFolder)folder);
            Node nodeFile = this.addChildNode(session, node.getIdentifier(), fileName, NT_WORKSPACE_FILE);
            JCRExternalFile file = new JCRExternalFile(this, nodeFile, fileName, name + " metadata", "text/xml", metadata);
            file.save(nodeFile);
            this.fireItemCreatedEvent(file);
            for (Map.Entry<String, InputStream> entry : images.entrySet()) {
                String imageName = Text.escapeIllegalJcrChars((String)entry.getKey());
                Node imageNode = this.addChildNode(session, node.getIdentifier(), imageName, NT_WORKSPACE_IMAGE);
                JCRExternalImage image = new JCRExternalImage(this, imageNode, imageName, description, "", entry.getValue());
                image.save(imageNode);
                this.fireItemCreatedEvent(image);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folder;
    }

    public Annotation createAnnotation(String name, String description, String oid, Map<String, String> data, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create annotation item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_ANNOTATION_ITEM);
            JCRAnnotation item = new JCRAnnotation(this, node, name, description, oid, data);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRAnnotation jCRAnnotation = item;
            return jCRAnnotation;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Metadata createMetadata(String name, String description, String oid, String schema, String language, String data, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create metadata item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_METADATA_ITEM);
            JCRMetadata item = new JCRMetadata(this, node, name, description, oid, schema, language, collectionName, data);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRMetadata jCRMetadata = item;
            return jCRMetadata;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Document createDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_ITEM);
            JCRDocument item = new JCRDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocument jCRDocument = item;
            return jCRDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocument createImageDocument(String name, String description, String oid, String mimeType, InputStream imageData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create image document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_ITEM);
            JCRImageDocument item = new JCRImageDocument(this, node, name, description, oid, mimeType, imageData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocument jCRImageDocument = item;
            return jCRImageDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocument createPDFDocument(String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create pdf document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_ITEM);
            JCRPDFDocument item = new JCRPDFDocument(this, node, name, description, oid, mimeType, data, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocument jCRPDFDocument = item;
            return jCRPDFDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public UrlDocument createUrlDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create url document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_URL_DOCUMENT_ITEM);
            JCRUrlDocument item = new JCRUrlDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRUrlDocument jCRUrlDocument = item;
            return jCRUrlDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public DocumentLink createDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create document link item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_LINK_ITEM);
            JCRDocumentLink item = new JCRDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocumentLink jCRDocumentLink = item;
            return jCRDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocumentLink createImageDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_LINK_ITEM);
            JCRImageDocumentLink item = new JCRImageDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocumentLink jCRImageDocumentLink = item;
            return jCRImageDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocumentLink createPDFDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_LINK_ITEM);
            JCRPDFDocumentLink item = new JCRPDFDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocumentLink jCRPDFDocumentLink = item;
            return jCRPDFDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create TimeSeries item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_TIMESERIES_ITEM);
            JCRTimeSeries item = new JCRTimeSeries(this, node, name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRTimeSeries jCRTimeSeries = item;
            return jCRTimeSeries;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowReport item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_REPORT);
            JCRWorkflowReport item = new JCRWorkflowReport(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRWorkflowReport jCRWorkflowReport = item;
            return jCRWorkflowReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowTemplate createWorkflowTemplate(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowTemplate item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_TEMPLATE);
            JCRWorkflowTemplate item = new JCRWorkflowTemplate(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRWorkflowTemplate jCRWorkflowTemplate = item;
            return jCRWorkflowTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalResourceLink createExternalResourceLink(String name, String description, String mimeType, String resourceId, String pluginName, String destinationFolderId) throws WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        this.logger.trace("Create service resource link");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_EXTERNAL_RESOURCE_LINK_ITEM);
            JCRExternalResourceLink item = new JCRExternalResourceLink(this, node, name, mimeType, description, resourceId, pluginName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRExternalResourceLink jCRExternalResourceLink = item;
            return jCRExternalResourceLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void removeRemoteContent(Node node, WorkspaceItemType workspaceItemType) throws RepositoryException, InternalErrorException, RemoteBackendException {
        Session session = node.getSession();
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            try {
                this.removeRemoteContent(session.getNodeByIdentifier(child.getId()), workspaceItemType);
            }
            catch (Exception e) {
                this.logger.warn(child.getName() + " payload not available", (Throwable)e);
            }
        }
        try {
            ((JCRWorkspaceFolderItem)item).removeRemoteContent(node, workspaceItemType);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void removeItem(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(itemId);
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, itemId);
            JCRWorkspaceItem parent = (JCRWorkspaceItem)item.getParent();
            parent.addAccountingEntry(new JCRAccountingFolderEntryRemoval(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
            if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                item.remove();
                return;
            }
            if (!node.getPrimaryNodeType().equals(NT_BOOKMARK)) {
                try {
                    this.removeRemoteContent(node, item.getType());
                }
                catch (Exception e) {
                    this.logger.warn(node.getName() + " payload not available", (Throwable)e);
                }
            }
            this.fireItemRemovedEvent(this.getWorkspaceItem(node));
            node.remove();
            session.save();
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void checkDestination(Node node, Node destinationNode) throws WrongDestinationException, InternalErrorException, InsufficientPrivilegesException {
        try {
            Session session = node.getSession();
            if (!destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) && !destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                this.logger.error("Destination is not a folder");
                throw new WrongDestinationException("Destination is not a folder");
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            JCRWorkspaceItem itemDestination = this.getWorkspaceItem(destinationNode);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)item.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath");
            QueryResult result = q.execute();
            if (itemDestination.isShared() && !item.isShared() && result.getNodes().hasNext() || itemDestination.isShared() && item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                throw new WrongDestinationException("Not allowed to move in an other destination folder already shared");
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveItem(String itemId, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.debug("Move item with id " + itemId + "to destination with id " + destinationFolderId);
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination folder id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem;
            Node nodeFolder;
            try {
                nodeFolder = session.getNodeByIdentifier(destinationFolderId);
            }
            catch (RepositoryException e) {
                this.logger.error("Destination not found");
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Item with id " + itemId + " not found");
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error retrieving item with id " + itemId);
                throw new InternalErrorException((Throwable)e);
            }
            try {
                this.checkDestination(nodeItem, nodeFolder);
                JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
                JCRWorkspaceItem parent = (JCRWorkspaceItem)item.getParent();
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(nodeFolder);
                this.logger.debug("Adding accounting entry ....");
                parent.addAccountingEntry(new JCRAccountingFolderEntryCut(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                item.addAccountingEntry(new JCRAccountingEntryPaste(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName()));
                String newRemotePath = null;
                if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                    newRemotePath = nodeFolder.getPath() + "/" + item.getName() + "-" + nodeItem.getIdentifier();
                    try {
                        GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath);
                        item.setRemotePath(newRemotePath);
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting remotePath to " + item.getPath());
                    }
                } else if (item.getType() == WorkspaceItemType.FOLDER) {
                    newRemotePath = nodeFolder.getPath();
                    this.moveDir(nodeItem, newRemotePath);
                    session.save();
                }
                item.internalMove(nodeFolder);
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item with id " + itemId + " to WorkspaceFolder with id " + destinationFolderId);
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void moveSharedFolder(Node sharedNode) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, RepositoryException {
        Validate.notNull((Object)sharedNode, (String)"Item id must be not null");
        this.logger.debug("sharedFolder: " + sharedNode.getPath());
        Session session = JCRRepository.getSession();
        try {
            try {
                JCRWorkspaceItem item = this.getWorkspaceItem(sharedNode);
                String newRemotePath = null;
                this.logger.debug("item.getType() " + item.getType());
                if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    newRemotePath = sharedNode.getPath();
                    this.logger.debug("base Path " + newRemotePath);
                    this.moveToShare(item, newRemotePath);
                    this.logger.debug("moveToShare finished");
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item with id " + sharedNode);
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void moveDir(Node node, String destinationPath) throws RepositoryException, InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            String path = destinationPath + "/" + node.getName();
            Node child = children.nextNode();
            try {
                String remotePath = child.getProperty("hl:remotePath").getValue().getString();
                this.logger.debug("remotePath " + remotePath);
                String newRemotePath = path + "/" + Text.getRelativeParent((String)child.getName(), (int)1);
                this.logger.debug("newRemotePath " + newRemotePath);
                this.logger.trace("Update remotePath: " + remotePath + " to: " + newRemotePath);
                GCUBEStorage.moveRemoteFile(remotePath, newRemotePath);
                this.logger.debug("moved from " + remotePath + " to " + newRemotePath);
                child.setProperty("hl:remotePath", newRemotePath);
                this.logger.debug("set property to node: " + child.getPath());
                session.save();
            }
            catch (Exception e) {
                this.logger.warn(node.getPath() + " has not remotePath");
            }
            if (!child.hasNodes()) continue;
            this.moveDir(child, path);
        }
    }

    private void moveToShare(WorkspaceItem item, String destinationPath) throws RepositoryException, InternalErrorException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        this.logger.debug("WorkspaceItem " + item + " - destinationPath " + destinationPath);
        Session session = JCRRepository.getSession();
        for (WorkspaceItem child : item.getChildren()) {
            String path = destinationPath + "/" + child.getName();
            this.logger.debug("path " + path);
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
                    String remotePath = child.getRemotePath();
                    this.logger.debug("remotePath " + remotePath);
                    this.logger.trace("Update remotePath: " + remotePath + " to: " + path);
                    GCUBEStorage.moveRemoteFile(remotePath, path);
                    this.logger.debug("moved from " + remotePath + " to " + path);
                    child.setRemotePath(path);
                    this.logger.debug("property to node: " + child.getRemotePath() + " has been set");
                    session.save();
                }
            }
            catch (Exception e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.moveToShare(child, path);
        }
    }

    public void renameItem(String itemId, String newName) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, ItemAlreadyExistException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException("Invalid item name");
        }
        Session session = JCRRepository.getSession();
        try {
            Node parentItem;
            Node nodeItem;
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
                parentItem = nodeItem.getParent();
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = null;
            JCRWorkspaceItem parent = null;
            try {
                item = this.getWorkspaceItem(nodeItem);
                item.addAccountingEntry(new JCRAccountingEntryRenaming(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName()));
                try {
                    parent = this.getWorkspaceItem(parentItem);
                    parent.addAccountingEntry(new JCRAccountingEntryRenaming(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName()));
                }
                catch (Exception e) {
                    this.logger.error("Impossible to set rename operation to node " + parentItem.getPath());
                }
                item.internalRename(nodeItem, newName);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
            this.fireItemRenamedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void changeDescription(String itemId, String newDescription) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = session.getNodeByIdentifier(itemId);
            this.getWorkspaceItem(nodeItem).internalDescription(nodeItem, newDescription);
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem getItem(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = null;
        try {
            session = JCRRepository.getSession();
            WorkspaceItem workspaceItem = this.getItem(session, itemId);
            return workspaceItem;
        }
        catch (InternalErrorException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public WorkspaceItem getItem(Session session, String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, RepositoryException {
        Node nodeItem = null;
        try {
            nodeItem = session.getNodeByIdentifier(itemId);
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        return this.getWorkspaceItem(nodeItem);
    }

    public Capabilities getCapabilities(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        return null;
    }

    public void removeChild(String childId, String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        Validate.notNull((Object)childId, (String)"Child Id must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node parent = session.getNodeByIdentifier(folderId);
            if (!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                throw new WrongParentTypeException("Item with id " + folderId + " isn't a folder item");
            }
            this.removeItem(childId);
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException("Folder is not present");
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void remove(String itemName, String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = null;
            try {
                nodeFolder = session.getNodeByIdentifier(folderId);
            }
            catch (ItemNotFoundException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                Node childNode = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)itemName));
                this.removeItem(childNode.getIdentifier());
            }
            catch (PathNotFoundException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem copy(String itemId, String newName, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"ItemId must be not null");
        Validate.notNull((Object)newName, (String)"NewName must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        if (!this.isValidName(newName)) {
            this.logger.error("The name contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        return this.internalCopy(itemId, newName, destinationFolderId);
    }

    public WorkspaceItem copy(String itemId, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder id must be not null");
        return this.internalCopy(itemId, null, destinationFolderId);
    }

    public void copyRemoteContent(Node node, Node nodeDestinationFolder) throws RepositoryException, InternalErrorException, RemoteBackendException {
        Session session = node.getSession();
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            this.copyRemoteContent(session.getNodeByIdentifier(child.getId()), nodeDestinationFolder);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).copyRemoteContent(node);
            if (nodeDestinationFolder != null) {
                this.logger.info("Set add accounting entry to destination folder " + nodeDestinationFolder.getPath());
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(nodeDestinationFolder);
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                session.save();
            }
        }
    }

    private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = null;
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            Node nodeDestinationFolder = null;
            try {
                if (destinationFolderId == null) {
                    destinationFolderId = nodeItem.getParent().getIdentifier();
                }
                if (!(nodeDestinationFolder = session.getNodeByIdentifier(destinationFolderId)).getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) && !nodeDestinationFolder.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                    throw new WrongDestinationException("Destination is not a folder");
                }
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)item.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath");
            QueryResult result = q.execute();
            if (!item.isShared() && result.getNodes().hasNext()) {
                throw new WrongDestinationException("Not allowed to copy a folder with some discendents item shared ");
            }
            if (newName == null) {
                newName = item.getName();
            }
            Node newNode = this.getWorkspaceItem(nodeItem).internalCopy(nodeDestinationFolder, newName);
            session.save();
            JCRWorkspaceItem newItem = this.getWorkspaceItem(newNode);
            newItem.addAccountingEntry(new JCRAccountingEntryPaste(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName()));
            this.copyRemoteContent(newNode, nodeDestinationFolder);
            session.save();
            JCRWorkspaceItem jCRWorkspaceItem = newItem;
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem cloneItem(String itemId, String cloneName) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, ItemAlreadyExistException, InsufficientPrivilegesException, InternalErrorException, WrongDestinationException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"itemId must be not null");
        if (!this.isValidName(cloneName)) {
            throw new IllegalArgumentException("cloneName is a not valid name");
        }
        return this.internalCopy(itemId, cloneName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name, String folderId) throws InternalErrorException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongItemTypeException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)folderId, (String)"Name must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            if (!this.isValidName(name)) {
                boolean e = false;
                return e;
            }
            try {
                folderNode.getNode(Text.escapeIllegalJcrChars((String)name));
            }
            catch (RepositoryException e) {
                this.logger.debug("Item not exists");
                boolean bl = false;
                session.logout();
                return bl;
            }
            this.logger.debug("Item exists");
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String itemId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            try {
                session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                boolean bl = false;
                session.logout();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String name, String folderId) throws InternalErrorException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = session.getNodeByIdentifier(folderId);
            try {
                Node node = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)name));
                JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
                return jCRWorkspaceItem;
            }
            catch (PathNotFoundException e) {
                WorkspaceItem workspaceItem;
                try {
                    workspaceItem = null;
                }
                catch (ItemNotFoundException e2) {
                    throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e2.getMessage());
                }
                catch (RepositoryException e3) {
                    throw new InternalErrorException((Throwable)e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                session.logout();
                return workspaceItem;
            }
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String path) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String[] strings = path.split("/");
            String pathCleaned = "";
            for (String string : strings) {
                pathCleaned = pathCleaned + "/" + Text.escapeIllegalJcrChars((String)string);
            }
            Node rootNode = session.getNodeByIdentifier(this.root.getId());
            Node node = session.getNode(rootNode.getPath() + pathCleaned);
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !name.contains("/");
    }

    public FolderBulkCreator getNewFolderBulkCreator(String folderId) throws WorkspaceFolderNotFoundException, WrongItemTypeException, InternalErrorException {
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                if (!folderNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    throw new WrongItemTypeException("A FolderBulkCreator can be created  only for a folder");
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);
            FolderBulkCreator folderBulkCreator = this.folderBulkCreatorsManager.getFolderBulk(folder);
            return folderBulkCreator;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public FolderBulkCreatorManager getFolderBulkCreatorManager() {
        return this.folderBulkCreatorsManager;
    }

    public WorkspaceMessageManager getWorkspaceMessageManager() {
        if (this.sendRequestManager == null) {
            this.sendRequestManager = new JCRWorkspaceMessageManager(this);
        }
        return this.sendRequestManager;
    }

    public WorkspaceFolder decomposeAquaMapsItem(String itemId, String folderName, String destinationWorkspaceId) throws WrongItemTypeException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        return null;
    }

    public JCRWorkspaceItem getWorkspaceItem(Node node) throws RepositoryException, InternalErrorException {
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
            return new JCRWorkspaceFolder(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
            return new JCRWorkspaceSharedFolder(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FILE)) {
            JCRExternalFile item = new JCRExternalFile(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_IMAGE)) {
            JCRExternalImage item = new JCRExternalImage(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_PDF_FILE)) {
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_URL)) {
            return new JCRExternalUrl(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_REPORT)) {
            return new JCRReport(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
            return new JCRReportTemplate(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
            return new JCRWorkflowReport(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
            return new JCRWorkflowTemplate(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_AQUAMAPS_ITEM)) {
            return new JCRAquaMapsItem(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_QUERY)) {
            return new JCRQuery(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_TIMESERIES_ITEM)) {
            return new JCRTimeSeries(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_DOCUMENT_ITEM)) {
            return new JCRDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_DOCUMENT_LINK_ITEM)) {
            return new JCRDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_IMAGE_DOCUMENT_ITEM)) {
            return new JCRImageDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
            return new JCRImageDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_PDF_DOCUMENT_ITEM)) {
            return new JCRPDFDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
            return new JCRPDFDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_URL_DOCUMENT_ITEM)) {
            return new JCRUrlDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_ANNOTATION_ITEM)) {
            return new JCRAnnotation(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_METADATA_ITEM)) {
            return new JCRMetadata(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER_ITEM)) {
            return new JCRWorkspaceSmartFolder(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_EXTERNAL_RESOURCE_LINK_ITEM)) {
            return new JCRExternalResourceLink(this, node);
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public FolderItemType getFolderItemType(Node node) throws RepositoryException {
        String nodeType = node.getPrimaryNodeType().getName();
        if (nodeType.equals(NT_WORKSPACE_FILE)) {
            return FolderItemType.EXTERNAL_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_IMAGE)) {
            return FolderItemType.EXTERNAL_IMAGE;
        }
        if (nodeType.equals(NT_WORKSPACE_PDF_FILE)) {
            return FolderItemType.EXTERNAL_PDF_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_URL)) {
            return FolderItemType.EXTERNAL_URL;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT)) {
            return FolderItemType.REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
            return FolderItemType.REPORT_TEMPLATE;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
            return FolderItemType.WORKFLOW_REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
            return FolderItemType.WORKFLOW_TEMPLATE;
        }
        if (nodeType.equals(NT_AQUAMAPS_ITEM)) {
            return FolderItemType.AQUAMAPS_ITEM;
        }
        if (nodeType.equals(NT_QUERY)) {
            return FolderItemType.QUERY;
        }
        if (nodeType.equals(NT_TIMESERIES_ITEM)) {
            return FolderItemType.TIME_SERIES;
        }
        if (nodeType.equals(NT_DOCUMENT_ITEM)) {
            return FolderItemType.DOCUMENT;
        }
        if (nodeType.equals(NT_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_ITEM)) {
            return FolderItemType.PDF_DOCUMENT;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.PDF_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_URL_DOCUMENT_ITEM)) {
            return FolderItemType.URL_DOCUMENT;
        }
        if (nodeType.equals(NT_ANNOTATION_ITEM)) {
            return FolderItemType.ANNOTATION;
        }
        if (nodeType.equals(NT_METADATA_ITEM)) {
            return FolderItemType.METADATA_LINK;
        }
        if (nodeType.equals(NT_EXTERNAL_RESOURCE_LINK_ITEM)) {
            return FolderItemType.EXTERNAL_RESOURCE_LINK;
        }
        return null;
    }

    public JCRAbstractWorkspaceFolder getParent(Node node) throws RepositoryException, InternalErrorException {
        Node parent = node.getParent();
        if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
            return new JCRWorkspaceFolder(this, parent);
        }
        if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
            return new JCRWorkspaceSharedFolder(this, parent);
        }
        return null;
    }

    public JCRFile getGCUBEDocumentContent(Session session, String oid, ContentType contentType) throws RepositoryException {
        Node node = JCRRepository.getGCubeRoot(session).getNode(Text.escapeIllegalJcrChars((String)oid));
        switch (contentType) {
            case GENERAL: {
                return new JCRFile(node.getNode(CONTENT));
            }
            case IMAGE: {
                return new JCRImage(node.getNode(CONTENT));
            }
            case PDF: {
                return new JCRPDFFile(node.getNode(CONTENT));
            }
        }
        return null;
    }

    public JCRFile setGCUBEDocumentContent(Session session, String oid, InputStream data, String mimeType, ContentType contentType) throws IOException, ItemExistsException, RepositoryException, RemoteBackendException {
        Node parent = JCRRepository.getGCubeRoot(session);
        Node nodeFile = parent.addNode(Text.escapeIllegalJcrChars((String)oid), NT_FILE);
        JCRFile file = null;
        switch (contentType) {
            case GENERAL: {
                file = new JCRFile(nodeFile.addNode(CONTENT, ContentType.GENERAL.toString()), mimeType, data);
                break;
            }
            case IMAGE: {
                file = new JCRImage(nodeFile.addNode(CONTENT, ContentType.IMAGE.toString()), data);
                break;
            }
            case PDF: {
                file = new JCRPDFFile(nodeFile.addNode(CONTENT, ContentType.PDF.toString()), mimeType, data);
                break;
            }
        }
        return file;
    }

    private String isValidSearchResult(Node node) {
        String portalLogin = this.getHome().getOwner().getPortalLogin();
        String sharePath = "/Share";
        String userPath = "/Home/" + portalLogin;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty("jcr:title").getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                Node usersNode = sharedNode.getNode("hl:users");
                PropertyIterator iterator = usersNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    String name = property.getName();
                    if (!name.equals(portalLogin)) continue;
                    if (node.getPath().equals(sharedNode.getPath())) {
                        String[] values = property.getValue().getString().split("/");
                        return values[1];
                    }
                    return node.getName();
                }
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public List<SearchItem> searchByName(String name) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String userPath = "/Home/" + this.getHome().getOwner().getPortalLogin();
            String path = userPath + "/Workspace";
            String sql2 = "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" + " AND (LOCALNAME(node) LIKE '%" + name + "%')";
            Query q = queryManager.createQuery(sql2, "JCR-SQL2");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null || !itemName.contains(name)) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node, itemName));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node), itemName));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
        LinkedList<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
        listItems.addAll(item.getChildren());
        for (WorkspaceItem child : item.getChildren()) {
            listItems.addAll(this.getWorkspaceTree(child));
        }
        return listItems;
    }

    public WorkspaceSmartFolder createSmartFolder(String name, String description, String query) throws ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.repository.getRootSmartFolders(session).addNode(name, NT_WORKSPACE_FOLDER_ITEM);
            JCRWorkspaceSmartFolder folder = new JCRWorkspaceSmartFolder(this, node, name, description, query);
            folder.save(node);
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = folder;
            return jCRWorkspaceSmartFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<WorkspaceSmartFolder> folders = new LinkedList<WorkspaceSmartFolder>();
        try {
            NodeIterator iterator = this.repository.getRootSmartFolders(session).getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                folders.add(new JCRWorkspaceSmartFolder(this, node));
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folders;
    }

    public WorkspaceSmartFolder getSmartFolder(String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = new JCRWorkspaceSmartFolder(this, session.getNodeByIdentifier(folderId));
            return jCRWorkspaceSmartFolder;
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<SearchItem> getFolderItems(FolderItemType ... types) throws InternalErrorException {
        LinkedList<SearchItem> list = new LinkedList<SearchItem>();
        for (FolderItemType folderItemType : types) {
            list.addAll(this.getFolderItems(folderItemType));
        }
        return list;
    }

    public List<SearchItem> getFolderItems(FolderItemType type) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@hl:workspaceItemType = '" + type.toString() + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node, itemName));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node), itemName));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchFolderItem> searchByMimeType(String mimeType) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchFolderItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:mimeType = '" + mimeType + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchFolderItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    list.add(new JCRSearchFolderItem(node.getParent(), this.getFolderItemType(node.getParent()), itemName));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (RepositoryException e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    private String getJCRWorkspaceItemType(FolderItemType type) {
        switch (type) {
            case ANNOTATION: {
                return NT_ANNOTATION_ITEM;
            }
            case ANNOTATION_LINK: {
                return NT_ANNOTATION_LINK_ITEM;
            }
            case AQUAMAPS_ITEM: {
                return NT_AQUAMAPS_ITEM;
            }
            case DOCUMENT: {
                return NT_DOCUMENT_ITEM;
            }
            case DOCUMENT_LINK: {
                return NT_DOCUMENT_LINK_ITEM;
            }
            case EXTERNAL_FILE: {
                return NT_WORKSPACE_FILE;
            }
            case EXTERNAL_IMAGE: {
                return NT_WORKSPACE_IMAGE;
            }
            case EXTERNAL_PDF_FILE: {
                return NT_WORKSPACE_PDF_FILE;
            }
            case EXTERNAL_URL: {
                return NT_WORKSPACE_URL;
            }
            case IMAGE_DOCUMENT: {
                return NT_IMAGE_DOCUMENT_ITEM;
            }
            case IMAGE_DOCUMENT_LINK: {
                return NT_IMAGE_DOCUMENT_LINK_ITEM;
            }
            case METADATA: {
                return NT_METADATA_ITEM;
            }
            case METADATA_LINK: {
                return NT_METADATA_LINK_ITEM;
            }
            case PDF_DOCUMENT: {
                return NT_PDF_DOCUMENT_ITEM;
            }
            case PDF_DOCUMENT_LINK: {
                return NT_PDF_DOCUMENT_LINK_ITEM;
            }
            case QUERY: {
                return NT_QUERY;
            }
            case REPORT: {
                return NT_WORKSPACE_REPORT;
            }
            case REPORT_TEMPLATE: {
                return NT_WORKSPACE_REPORT_TEMPLATE;
            }
            case TIME_SERIES: {
                return NT_TIMESERIES_ITEM;
            }
            case URL_DOCUMENT: {
                return NT_URL_DOCUMENT_ITEM;
            }
            case WORKFLOW_REPORT: {
                return NT_WORKSPACE_WORKFLOW_REPORT;
            }
            case WORKFLOW_TEMPLATE: {
                return NT_WORKSPACE_WORKFLOW_TEMPLATE;
            }
        }
        return null;
    }

    public GCUBEScope getScope() {
        if (this.scope == null) {
            return null;
        }
        return GCUBEScope.getScope((String)this.scope);
    }

    public String getUrlWebDav() throws InternalErrorException {
        return this.repository.getWebDavUrl(this.home.getOwner().getPortalLogin()) + this.getPathSeparator() + WORKSPACE_ROOT_FOLDER;
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, List<String> users, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        Session session = JCRRepository.getSession();
        try {
            if (this.exists(name, destinationFolderId)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, destinationFolderId);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            Node sharedFolder = JCRRepository.getSharedRoot(session);
            Node node = sharedFolder.addNode(UUID.randomUUID().toString(), NT_WORKSPACE_SHARED_FOLDER);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, name, description, destinationFolderId, users);
            folder.save(node);
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = folder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder shareFolder(List<String> users, String folderId) throws InternalErrorException, InsufficientPrivilegesException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WorkspaceFolderNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeItemToShare = session.getNodeByIdentifier(folderId);
            JCRWorkspaceItem itemToShare = (JCRWorkspaceItem)this.getItem(session, folderId);
            if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {
                WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)itemToShare;
                sharedFolder.share(users);
                WorkspaceSharedFolder workspaceSharedFolder = sharedFolder;
                return workspaceSharedFolder;
            }
            if (itemToShare.getType() != WorkspaceItemType.FOLDER) {
                throw new WorkspaceFolderNotFoundException("The item to share is not a folder");
            }
            JCRAbstractWorkspaceFolder parentItem = itemToShare.getParent(nodeItemToShare);
            if (parentItem == null) {
                throw new WrongDestinationException("The root can't be shared");
            }
            String parentId = parentItem.getId();
            JCRWorkspaceItem destinationFolder = (JCRWorkspaceItem)this.getItem(session, parentId);
            if (destinationFolder.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)itemToShare.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath");
            QueryResult result = q.execute();
            if (result.getNodes().hasNext()) {
                throw new WrongDestinationException("Folder contains descendants already shared");
            }
            String sharedFolderName = itemToShare.getName();
            String sharedFolderDescription = itemToShare.getDescription();
            Node sharedRootFolder = JCRRepository.getSharedRoot(session);
            Node sharedNode = sharedRootFolder.addNode(UUID.randomUUID().toString(), NT_WORKSPACE_SHARED_FOLDER);
            JCRWorkspaceSharedFolder sharedFolder = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users);
            Node folderNode = session.getNodeByIdentifier(folderId);
            NodeIterator iterator = folderNode.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (node.getName().startsWith("jcr:") || node.getName().startsWith("hl:")) continue;
                session.getWorkspace().copy(node.getPath(), sharedNode.getPath() + this.getPathSeparator() + node.getName());
            }
            folderNode.remove();
            session.save();
            sharedFolder.save(sharedNode);
            try {
                this.moveSharedFolder(sharedNode);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
            sharedFolder.setShareHistory(users, this.getOwner().getPortalLogin());
            this.fireItemCreatedEvent(sharedFolder);
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = sharedFolder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public TabularDataLink createTabularDataLink(String name, String description, String tableId, String template, TabularDataLink.Provenance provenance, String operator, String runtimeResourceName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create tabular data link");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_TABULAR_DATA_LINK);
            JCRTabularDataLink item = new JCRTabularDataLink(this, node, name, description, tableId, template, provenance, operator, runtimeResourceName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRTabularDataLink jCRTabularDataLink = item;
            return jCRTabularDataLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<Object> getBookmarks(String bookmarkFolderId) throws InternalErrorException {
        return null;
    }

    public void addBookmark(String itemId, String destinationFolderId) throws ItemAlreadyExistException, InternalErrorException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WorkspaceFolderNotFoundException {
    }

    public void setHardLink(Node node, String hardLinkRemotePath) throws RepositoryException, InternalErrorException {
        this.logger.info("set hard link: " + hardLinkRemotePath + " to node " + node.getPath());
        Session session = node.getSession();
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            this.setHardLink(session.getNodeByIdentifier(child.getId()), hardLinkRemotePath);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).setHardLink(node, hardLinkRemotePath);
        }
        session.save();
    }

    public void orderResultBy(String mimeType, long limit, long offset) throws InternalErrorException {
    }

    public void updateItem(String itemId, InputStream fileData) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(itemId);
            this.logger.trace("Update file " + node.getPath());
            JCRWorkspaceItem newItem = this.getWorkspaceItem(node);
            newItem.addAccountingEntry(new JCRAccountingEntryUpdate(this.getOwner().getPortalLogin(), Calendar.getInstance(), node.getName()));
            Node parent = node.getParent();
            JCRWorkspaceItem parentItem = this.getWorkspaceItem(parent);
            parentItem.addAccountingEntry(new JCRAccountingEntryUpdate(this.getOwner().getPortalLogin(), Calendar.getInstance(), node.getName()));
            this.overwriteContent(node, fileData);
            this.updateProperties(node, fileData);
            this.fireItemUpdatedEvent(this.getItem(itemId));
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void updateProperties(Node node, InputStream fileData) throws RepositoryException, InternalErrorException {
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FILE)) {
            JCRExternalFile item = new JCRExternalFile(this, node);
            item.updateInfo();
        } else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_IMAGE)) {
            JCRExternalImage item = new JCRExternalImage(this, node);
            item.updateInfo();
        } else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_PDF_FILE)) {
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node);
            item.updateInfo();
        }
    }

    public void overwriteContent(Node node, InputStream is) throws RepositoryException, RemoteBackendException {
        try {
            Node contentNode = node.getNode(CONTENT);
            if (contentNode.hasProperty("hl:remotePath")) {
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                String url = GCUBEStorage.putStream(is, remotePath);
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = contentNode.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                contentNode.setProperty("jcr:data", binary);
            }
        }
        catch (PathNotFoundException e) {
            this.logger.error("Content node jcr:content not found", (Throwable)e);
        }
    }
}

