/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryCreate;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingEntryCreate
extends JCRAccountingEntry
implements AccountingEntryCreate {
    private static String ITEM_NAME = "hl:itemName";
    protected String itemName;

    public JCRAccountingEntryCreate(Node node) throws RepositoryException {
        super(node);
        this.itemName = node.getProperty(ITEM_NAME).getString();
    }

    public JCRAccountingEntryCreate(String user, Calendar date, String itemName) {
        super(user, date);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.CREATE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    @Override
    public void save(Node entryNode) throws RepositoryException {
        super.save(entryNode);
        entryNode.setProperty(ITEM_NAME, this.itemName);
    }

    public String getItemName() {
        return this.itemName;
    }
}

