/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.home;

import java.io.File;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.ApplicationsArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.data.JCRApplicationsArea;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHome
implements Home {
    private final HomeManager homeManager;
    private final JCRUser owner;
    private final File persistenceFolder;
    private final JCRRepository repository;
    private final JCRWorkspace workspace;
    private final JCRApplicationsArea applicationArea;
    private Logger logger;

    public JCRHome(HomeManager homeManager, JCRUser user, File persistenceFolder) throws Exception {
        this.setupLogger();
        this.owner = user;
        this.persistenceFolder = persistenceFolder;
        this.homeManager = homeManager;
        this.repository = new JCRRepository(user);
        this.workspace = new JCRWorkspace(this, this.repository);
        this.applicationArea = new JCRApplicationsArea(this.workspace);
    }

    private void setupLogger() {
        this.logger = LoggerFactory.getLogger(JCRHome.class);
    }

    public void setScope(GCUBEScope scope) throws InternalErrorException {
        this.owner.setScope(scope);
        Session session = JCRRepository.getSession();
        try {
            this.repository.setScope(session, scope.toString());
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public User getOwner() {
        return this.owner;
    }

    public Workspace getWorkspace() throws WorkspaceFolderNotFoundException, InternalErrorException {
        return this.workspace;
    }

    public ApplicationsArea getDataArea() throws InternalErrorException {
        return this.applicationArea;
    }

    public List<String> listScopes() throws InternalErrorException {
        try {
            return this.repository.listScopes();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

