/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.sharing;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.jcr.sharing.JCRWorkspaceMessage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessageManager
implements WorkspaceMessageManager {
    private JCRWorkspace workspace;
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessageManager.class);
    protected static final String CONTENT = "jcr:content";
    protected static final String ATTACHMENTS = "hl:attachments";

    public JCRWorkspaceMessageManager(JCRWorkspace workspace) {
        this.workspace = workspace;
    }

    public void sendMessageToPortalLogins(String subject, String body, List<String> attachmentIds, List<String> addresses) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String messageId = UUID.randomUUID().toString();
            Node nodeHiddenFolder = this.workspace.getRepository().getHiddenFolder(session);
            Node nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
            Node nodeSentMessage = nodeOutBox.addNode(messageId);
            JCRWorkspaceMessage itemInSentFolder = new JCRWorkspaceMessage(this.workspace, nodeSentMessage, JCRWorkspaceMessage.WorkspaceMessageType.SENT, messageId, subject, body, this.workspace.getOwner(), attachmentIds, addresses, nodeHiddenFolder);
            List<String> copyAttachmentsIds = itemInSentFolder.getCopyAttachmentsIds();
            for (String user : addresses) {
                logger.debug("Send message to user " + user);
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                homeManager.getHome(user, this.workspace.getOwner().getScope());
                Node node = this.workspace.getRepository().getInBoxFolder(session, user);
                Node itemNode = node.addNode(messageId);
                JCRWorkspaceMessage itemToSend = new JCRWorkspaceMessage(this.workspace, itemNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED, messageId, subject, body, this.workspace.getOwner(), copyAttachmentsIds, addresses, nodeHiddenFolder);
                session.save();
            }
        }
        catch (HomeNotFoundException e) {
            logger.error("User home not found", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Internal error exception", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void sendMessageToUsers(String subject, String body, List<String> attachmentIds, List<User> addresses) throws InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        for (User user : addresses) {
            list.add(user.getPortalLogin());
        }
        this.sendMessageToPortalLogins(subject, body, attachmentIds, list);
    }

    public WorkspaceMessage getSentMessage(String id) throws InternalErrorException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceMessage message;
            Node messageNode = this.workspace.getRepository().getOutBoxFolder(session).getNode(id);
            JCRWorkspaceMessage jCRWorkspaceMessage = message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return jCRWorkspaceMessage;
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceMessage getReceivedMessage(String id) throws InternalErrorException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceMessage message;
            Node messageNode = this.workspace.getRepository().getOwnInBoxFolder(session).getNode(id);
            JCRWorkspaceMessage jCRWorkspaceMessage = message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
            return jCRWorkspaceMessage;
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReceivedMessage(String id) {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node messageNode = this.workspace.getRepository().getOwnInBoxFolder(session).getNode(id);
            GCUBEStorage.removeRemoteFolder(messageNode.getPath());
            messageNode.remove();
            session.save();
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSentMessage(String id) {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node messageNode = this.workspace.getRepository().getOutBoxFolder(session).getNode(id);
            GCUBEStorage.removeRemoteFolder(messageNode.getPath());
            messageNode.remove();
            session.save();
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkspaceMessage> getReceivedMessages() {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node nodeInBox = this.workspace.getRepository().getOwnInBoxFolder(session);
            NodeIterator iterator = nodeInBox.getNodes();
            while (iterator.hasNext()) {
                Node messageNode = iterator.nextNode();
                list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED));
            }
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkspaceMessage> getSentMessages() {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
            NodeIterator iterator = nodeOutBox.getNodes();
            while (iterator.hasNext()) {
                Node messageNode = iterator.nextNode();
                list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT));
            }
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return list;
    }

    public int getMessagesNotOpened() {
        int count = 0;
        for (WorkspaceMessage message : this.getReceivedMessages()) {
            if (((JCRWorkspaceMessage)message).isOpened()) continue;
            ++count;
        }
        return count;
    }

    public List<WorkspaceMessage> searchInMessages(String word) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            List<WorkspaceMessage> list;
            Node nodeInBox = this.workspace.getRepository().getOwnInBoxFolder(session);
            NodeIterator iterator = this.getNodeSearched(session, nodeInBox, word);
            List<WorkspaceMessage> list2 = list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
            return list2;
        }
        catch (RepositoryException e) {
            logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<WorkspaceMessage> searchOutMessages(String word) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            List<WorkspaceMessage> list;
            Node nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
            NodeIterator iterator = this.getNodeSearched(session, nodeOutBox, word);
            List<WorkspaceMessage> list2 = list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return list2;
        }
        catch (RepositoryException e) {
            logger.error("Error", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private List<WorkspaceMessage> getMessagesSearched(NodeIterator iterator, JCRWorkspaceMessage.WorkspaceMessageType type) {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        while (iterator != null && iterator.hasNext()) {
            Node node = iterator.nextNode();
            try {
                list.add(new JCRWorkspaceMessage(this.workspace, node, type));
            }
            catch (RepositoryException e) {
                try {
                    logger.error("Item " + node.getName() + "unknow");
                }
                catch (RepositoryException e1) {
                    logger.error("Error ", (Throwable)e1);
                }
            }
        }
        return list;
    }

    private NodeIterator getNodeSearched(Session session, Node searchRoot, String word) throws InternalErrorException {
        NodeIterator iterator;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root" + searchRoot.getPath() + "//element()[jcr:contains(@hl:subject,'*" + word + "*') or " + "jcr:contains(@hl:body,'*" + word + "*') ] ", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return iterator;
    }
}

