/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.File;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRAquaMapsItem
extends JCRWorkspaceFolderItem
implements AquaMapsItem {
    private static final String NT_CONTENT = "nthl:aquamapsItemContent";
    private static final String MAP_NAME = "hl:mapName";
    private static final String MAP_TYPE = "hl:mapType";
    private static final String AUTHOR = "hl:author";
    private static final String NUMBER_OF_SPECIES = "hl:numberOfSpecies";
    private static final String BOUNDING_BOX = "hl:boundingBox";
    private static final String PSO_THRESHOLD = "hl:PSOThreshold";
    private static final String NUMBER_OF_IMAGES = "hl:numberOfImages";
    private static final String IMAGES = "hl:images";
    private final JCRFile file;
    private final List<Image> listImages;
    private final String mapName;
    private final String mapType;
    private final String author;
    private final int numberOfSpecies;
    private final String boundingBox;
    private final float psoThreshold;
    private final int numberOfGeneratedImages;

    public JCRAquaMapsItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.mapName = contentNode.getProperty(MAP_NAME).getString();
        this.mapType = contentNode.getProperty(MAP_TYPE).getString();
        this.author = contentNode.getProperty(AUTHOR).getString();
        this.numberOfSpecies = (int)contentNode.getProperty(NUMBER_OF_SPECIES).getLong();
        this.boundingBox = contentNode.getProperty(BOUNDING_BOX).getString();
        this.psoThreshold = (float)contentNode.getProperty(PSO_THRESHOLD).getDouble();
        this.numberOfGeneratedImages = (int)contentNode.getProperty(NUMBER_OF_IMAGES).getLong();
        this.file = new JCRFile(contentNode);
        this.listImages = new ArrayList<Image>();
        Node nodeImages = contentNode.getNode(IMAGES);
        NodeIterator iterator = nodeImages.getNodes();
        while (iterator.hasNext()) {
            Node nodeImage = iterator.nextNode();
            JCRImage jcrImage = new JCRImage(nodeImage);
            this.listImages.add(jcrImage);
        }
    }

    public JCRAquaMapsItem(JCRWorkspace workspace, Node node, String name, String description, String mapName, String mapType, String author, int numberOfSpecies, String boundingBox, float psoThreshold, int numberOfGeneratedImages, InputStream metadata, Map<String, InputStream> images) throws Exception {
        super(workspace, node, name, description);
        Validate.notNull((Object)mapName, (String)"MapName must be not null");
        Validate.notNull((Object)mapType, (String)"MapType must be not null");
        Validate.notNull((Object)author, (String)"Author must be not null");
        Validate.notNull((Object)boundingBox, (String)"Bounding box must be not null");
        Validate.notNull((Object)metadata, (String)"Metadata must be not null");
        Validate.notNull(images, (String)"Images must be not null");
        this.mapName = mapName;
        this.mapType = mapType;
        this.author = author;
        this.numberOfSpecies = numberOfSpecies;
        this.boundingBox = boundingBox;
        this.psoThreshold = psoThreshold;
        this.numberOfGeneratedImages = numberOfGeneratedImages;
        node.setProperty("hl:workspaceItemType", FolderItemType.AQUAMAPS_ITEM.toString());
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty(MAP_NAME, mapName);
        contentNode.setProperty(MAP_TYPE, mapType);
        contentNode.setProperty(AUTHOR, author);
        contentNode.setProperty(NUMBER_OF_SPECIES, (long)numberOfSpecies);
        contentNode.setProperty(BOUNDING_BOX, boundingBox);
        contentNode.setProperty(PSO_THRESHOLD, (double)psoThreshold);
        contentNode.setProperty(NUMBER_OF_IMAGES, (long)numberOfGeneratedImages);
        this.file = new JCRFile(contentNode, new BufferedInputStream(metadata));
        this.listImages = new ArrayList<Image>();
        Node nodeImages = contentNode.getNode(IMAGES);
        for (Map.Entry<String, InputStream> image : images.entrySet()) {
            String nodeName = Text.escapeIllegalJcrChars((String)image.getKey());
            Node nodeImage = nodeImages.addNode(nodeName, ContentType.IMAGE.toString());
            JCRImage jcrImage = new JCRImage(nodeImage, image.getValue());
            this.listImages.add(jcrImage);
        }
        contentNode.getSession().save();
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.file.getLength();
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getMapType() {
        return this.mapType;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getNumberOfSpecies() {
        return this.numberOfSpecies;
    }

    public String getBoundingBox() {
        return this.boundingBox;
    }

    public float getPsoThreshold() {
        return this.psoThreshold;
    }

    public int getNumberOfGeneratedImages() {
        return this.numberOfGeneratedImages;
    }

    public File getMetadata() throws InternalErrorException {
        return this.file;
    }

    public List<Image> getImages() {
        return this.listImages;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.AQUAMAPS_ITEM;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.file.save(node);
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

