/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;

public class ZipModelWriter {
    protected Logger logger = Logger.getLogger(ZipModelWriter.class);

    public File writeItem(ZipItem item) throws IOException {
        File zipFile = File.createTempFile("zippping", "zip");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.addZipItem(out, item);
        out.close();
        return zipFile;
    }

    protected void addZipItem(ZipOutputStream zos, ZipItem item) throws IOException {
        switch (item.getType()) {
            case FILE: {
                this.addZipFile(zos, (ZipFile)item);
                break;
            }
            case FOLDER: {
                this.addZipFolder(zos, (ZipFolder)item);
            }
        }
    }

    protected void addZipFolder(ZipOutputStream zos, ZipFolder folder) throws IOException {
        for (ZipItem item : folder.getChildren()) {
            this.addZipItem(zos, item);
        }
    }

    protected void addZipFile(ZipOutputStream zos, ZipFile file) throws IOException {
        this.logger.trace((Object)("adding ZipFile path: " + file.getPath()));
        ZipEntry zipEntry = new ZipEntry(file.getPath());
        zipEntry.setComment(file.getComment());
        zipEntry.setExtra(file.getExtra());
        zos.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)file.getContentStream(), (OutputStream)zos);
        zos.closeEntry();
    }
}

