/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataAreaItem;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataFile;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataFolder;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;

public class HomeFolderVisitor {
    protected static final String tab = "  ";
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyy hh:mm:ss");
    protected String indentation = "";
    protected PrintStream output;

    public HomeFolderVisitor() {
        this.output = System.out;
    }

    public HomeFolderVisitor(PrintStream output) {
        this.output = output;
    }

    protected void indent() {
        this.indentation = String.valueOf(this.indentation) + tab;
    }

    protected void outdent() {
        this.indentation = this.indentation.substring(tab.length());
    }

    public void visit(DataFolder folder) throws InternalErrorException {
        this.visitFolder(folder);
    }

    protected void visit(DataAreaItem item) throws InternalErrorException {
        if (item.isFolder()) {
            this.visitFolder((DataFolder)item);
        } else {
            this.visitFile((DataFile)item);
        }
    }

    protected void visitFolder(DataFolder folder) throws InternalErrorException {
        this.println("/" + folder.getName() + "/");
        this.indent();
        for (DataAreaItem item : folder.listFiles()) {
            this.visit(item);
        }
        this.outdent();
    }

    protected void visitFile(DataFile file) {
        this.println(String.valueOf(file.getName()) + " " + (file.getCreationTime() != null ? sdf.format(file.getCreationTime()) : ""));
    }

    protected void println(String line) {
        this.output.println(String.valueOf(this.indentation) + line);
    }
}

