/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace;

import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;

public class DefaultWorkspaceFactory
implements WorkspaceFactory {
    protected static final String TESTUNIT_PERSISTENCE_ROOT = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "home_library_test_unit";
    protected Workspace lastWorkspace;

    @Override
    public void cleanWorkspace() throws InternalErrorException {
        if (this.lastWorkspace != null) {
            this.lastWorkspace.getHome().getHomeManager().getHomeManagerFactory().shutdown();
        }
        File testDir = new File(TESTUNIT_PERSISTENCE_ROOT);
        try {
            if (testDir.exists()) {
                FileUtils.cleanDirectory((File)testDir);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public Workspace getWorkspace() throws InternalErrorException {
        try {
            File testDir = new File(TESTUNIT_PERSISTENCE_ROOT);
            if (testDir.exists()) {
                FileUtils.cleanDirectory((File)testDir);
            }
            testDir.mkdir();
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory((String)testDir.getAbsolutePath());
            factory.initialize(TESTUNIT_PERSISTENCE_ROOT);
            HomeManager manager = factory.getHomeManager();
            User testUser = manager.createUser("user.test");
            Home home = manager.getHome(testUser, GCUBEScope.getScope((String)"/testRoot/test"));
            this.lastWorkspace = home.getWorkspace();
            return this.lastWorkspace;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public Map<String, Workspace> getTestWorkspaces() throws InternalErrorException {
        return null;
    }
}

