/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class WorkspacePersistenceTest {
    protected Workspace workspace;

    @Before
    public abstract void setupWorkspace() throws InternalErrorException;

    @After
    public abstract void cleanWorkspace() throws InternalErrorException;

    public abstract void reloadWokspaceArea() throws InternalErrorException;

    @Test
    public final void testFolderPersistence() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestFolder";
        String expectedDescription = "TestDescription";
        WorkspaceFolder folder = this.workspace.createFolder(expectedName, expectedDescription, root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem itemB = this.workspace.getItem(folder.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)folder, itemB);
    }

    @Test
    public final void testMoveItemWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolder", "This is a test folder");
        WorkspaceFolder item = testFolder.createFolder("TestItem", "TestItem");
        this.testMoveItem((WorkspaceItem)item, root);
    }

    @Test
    public final void testMoveItemFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder testFolder = root.createFolder("TestFolder", "This is a test folder");
        WorkspaceFolder destinationFolder = root.createFolder("TestDestinationFolder", "The destination Folder");
        TestDataFactory.getInstance().fillPDFDocuments(testFolder, 1);
        WorkspaceItem item = (WorkspaceItem)testFolder.getChildren().get(0);
        this.testMoveItem(item, destinationFolder);
    }

    protected final void testMoveItem(WorkspaceItem item, WorkspaceFolder destination) throws InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException, WrongDestinationException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        WorkspaceFolder parent = item.getParent();
        this.workspace.moveItem(item.getId(), destination.getId());
        this.reloadWokspaceArea();
        WorkspaceItem movedItem = this.workspace.getItem(item.getId());
        Assert.assertNotNull((String)"The moved item parent is null", (Object)movedItem.getParent());
        Assert.assertEquals((String)"Children founds on old parent", (long)0L, (long)parent.getChildren().size());
        UnitTestUtil.testRelationship(movedItem, (WorkspaceItem)destination);
    }

    @Test
    public final void testRenameItemFolder() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("FSWorkspace", "A Test Workspace");
        String expectedName = "NewTestWorkspace";
        this.workspace.renameItem(folder.getId(), expectedName);
        this.reloadWokspaceArea();
        WorkspaceItem renamedItem = this.workspace.getItem(folder.getId());
        Assert.assertEquals((String)"Item not renamed", (Object)expectedName, (Object)renamedItem.getName());
    }

    @Test
    public final void testCloneItemWorkspace() throws InternalErrorException, WorkspaceFolderAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("FSWorkspace", "A test Workspace");
        String expectedName = "TestWorkspaceClone";
        WorkspaceItem clone = this.workspace.cloneItem(folder.getId(), expectedName);
        this.reloadWokspaceArea();
        WorkspaceItem clonedItem = this.workspace.getItem(clone.getId());
        root = this.workspace.getRoot();
        WorkspaceItem workspaceClone = this.workspace.getItem(folder.getId());
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)clonedItem.getName());
        UnitTestUtil.testCopy(workspaceClone, clonedItem, false);
        UnitTestUtil.testRelationship(clonedItem, (WorkspaceItem)root);
    }

    @Test
    public final void testRemoveItemWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestWorkspace", "A test workspace");
        this.workspace.removeItem(folder.getId());
        this.reloadWokspaceArea();
        try {
            this.workspace.getItem(folder.getId());
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        Assert.fail((String)"Item not removed");
        Assert.assertEquals((String)"Wrong number of children", (long)0L, (long)root.getChildren().size());
    }

    @Test
    public final void testGetItemWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        this.reloadWokspaceArea();
        WorkspaceItem foundItem = this.workspace.getItem(folder.getId());
        Assert.assertNotNull((String)"Found item null", (Object)foundItem);
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)folder, foundItem);
    }

    @Test
    public final void testRemoveChildWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongParentTypeException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        this.workspace.removeChild(folder.getId(), root.getId());
        this.reloadWokspaceArea();
        root = this.workspace.getRoot();
        Assert.assertEquals((String)"Children list is not empty", (long)0L, (long)root.getChildren().size());
        try {
            this.workspace.getItem(folder.getId());
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        Assert.fail((String)"Child not removed");
    }

    @Test
    public final void testCopyStringStringStringWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        String expectedName = "TestFolderCopy";
        WorkspaceItem copy = this.workspace.copy(folder.getId(), expectedName, root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem workspaceOriginal = this.workspace.getItem(folder.getId());
        Assert.assertNotNull((String)"Copy null", (Object)copyItem);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copy.getName());
        UnitTestUtil.testCopy(workspaceOriginal, copyItem, false);
        UnitTestUtil.testRelationship(copyItem, (WorkspaceItem)root);
    }

    @Test
    public final void testCopyStringStringStringFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        TestDataFactory.getInstance().fillPDFDocuments(root, 1);
        WorkspaceItem item = (WorkspaceItem)root.getChildren().get(0);
        String expectedName = "TestFolderItemClone";
        WorkspaceItem copy = this.workspace.copy(item.getId(), expectedName, root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem itemOriginal = this.workspace.getItem(item.getId());
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copyItem.getName());
        WorkspaceItem findCopy = this.workspace.getItem(copyItem.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findCopy);
        UnitTestUtil.testCopy(itemOriginal, copyItem, false);
        UnitTestUtil.testRelationship(copyItem, (WorkspaceItem)root);
    }

    @Test
    public final void testCopyStringStringStringWorkspaceTree() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, IOException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder folder = UnitTestUtil.getFolderTree(root, "TestFolderTree4");
        String expectedName = "TestFolderCopy";
        WorkspaceItem copy = this.workspace.copy(folder.getId(), expectedName, root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem workspaceOriginal = this.workspace.getItem(folder.getId());
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)copyItem.getName());
        WorkspaceItem findClone = this.workspace.getItem(copyItem.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findClone);
        UnitTestUtil.testCopy(workspaceOriginal, copyItem, false);
        UnitTestUtil.testTreeRelationship(copyItem, (WorkspaceItem)root);
    }

    @Test
    public final void testCopyStringStringWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder workspaceFolder = root.createFolder("TestWorkspaceFolder", "A test Workspace folder");
        WorkspaceFolder folder = root.createFolder("TestFolder", "A test Folder");
        WorkspaceItem copy = this.workspace.copy(folder.getId(), workspaceFolder.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem workspaceFolderReloaded = this.workspace.getItem(workspaceFolder.getId());
        WorkspaceItem workspaceOriginal = this.workspace.getItem(folder.getId());
        Assert.assertNotNull((String)"Copy null", (Object)copyItem);
        Assert.assertEquals((String)"Wrong name", (Object)workspaceOriginal.getName(), (Object)copy.getName());
        UnitTestUtil.testCopy(workspaceOriginal, copyItem, true);
        UnitTestUtil.testRelationship(copyItem, workspaceFolderReloaded);
    }

    @Test
    public final void testCopyStringStringFolderItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder testDestination = root.createFolder("TestFolder", "My Test Folder");
        WorkspaceItem item = (WorkspaceItem)TestDataFactory.getInstance().fillPDFDocuments(root, 1).get(0);
        WorkspaceItem copy = this.workspace.copy(item.getId(), testDestination.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem folderReloaded = this.workspace.getItem(testDestination.getId());
        WorkspaceItem itemOriginal = this.workspace.getItem(item.getId());
        Assert.assertEquals((String)"Wrong name", (Object)itemOriginal.getName(), (Object)copyItem.getName());
        WorkspaceItem findCopy = this.workspace.getItem(copyItem.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findCopy);
        UnitTestUtil.testCopy(itemOriginal, copyItem, true);
        UnitTestUtil.testRelationship(copyItem, folderReloaded);
    }

    @Test
    public final void testCopyStringStringWorkspaceTree() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongDestinationException, IOException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        WorkspaceFolder workspaceFolder = root.createFolder("TestWorkspaceFolder", "A test Workspace folder");
        WorkspaceFolder folder = UnitTestUtil.getFolderTree(root, "TestFolderTree5");
        WorkspaceItem copy = this.workspace.copy(folder.getId(), workspaceFolder.getId());
        this.reloadWokspaceArea();
        WorkspaceItem copyItem = this.workspace.getItem(copy.getId());
        root = this.workspace.getRoot();
        WorkspaceItem workspaceFolderReloaded = this.workspace.getItem(workspaceFolder.getId());
        WorkspaceItem workspaceOriginal = this.workspace.getItem(folder.getId());
        Assert.assertEquals((String)"Wrong name", (Object)workspaceOriginal.getName(), (Object)copyItem.getName());
        WorkspaceItem findClone = this.workspace.getItem(copyItem.getId());
        Assert.assertNotNull((String)"Find copy null", (Object)findClone);
        UnitTestUtil.testCopy(workspaceOriginal, copyItem, true);
        UnitTestUtil.testTreeRelationship(copyItem, workspaceFolderReloaded);
    }

    @Test
    public final void testCreateExternalFile() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestExternalFile";
        String expectedDescription = "Test external file description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomFile();
        ExternalFile externalFile = this.workspace.createExternalFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        ExternalFile externalFileReloaded = (ExternalFile)this.workspace.getItem(externalFile.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)externalFile, (WorkspaceItem)externalFileReloaded);
        UnitTestUtil.testItemCreation((WorkspaceItem)externalFile, folderReloaded, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalFileReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalFileReloaded.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalFileReloaded.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testCreateImageDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.workspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        this.reloadWokspaceArea();
        root = this.workspace.getRoot();
        ImageDocument imageDocumentReloaded = (ImageDocument)this.workspace.getItem(imageDocument.getId());
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)imageDocument, (WorkspaceItem)imageDocumentReloaded);
        UnitTestUtil.testDocumentCreation((Document)imageDocumentReloaded, folderReloaded, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = imageDocumentReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.IMAGE_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)imageDocumentReloaded.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)imageDocumentReloaded.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testCreateDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        Document document = this.workspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        this.reloadWokspaceArea();
        root = this.workspace.getRoot();
        Document documentReloaded = (Document)this.workspace.getItem(document.getId());
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        UnitTestUtil.testDocumentCreation(documentReloaded, folderReloaded, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = documentReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)documentReloaded.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)documentReloaded.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testCreateExternalPDFFile() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestExternalPDFFile";
        String expectedDescription = "Test external PDFFile description";
        String expectedMimeType = "testMimeType";
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        ExternalPDFFile externalPDFFile = this.workspace.createExternalPDFFile(expectedName, expectedDescription, expectedMimeType, (InputStream)new FileInputStream(fileData), root.getId());
        this.reloadWokspaceArea();
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        ExternalPDFFile externalPDFFileReloaded = (ExternalPDFFile)this.workspace.getItem(externalPDFFile.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)externalPDFFile, (WorkspaceItem)externalPDFFileReloaded);
        UnitTestUtil.testItemCreation((WorkspaceItem)externalPDFFileReloaded, folderReloaded, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        FolderItemType folderItemType = externalPDFFileReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.EXTERNAL_PDF_FILE, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)externalPDFFileReloaded.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)externalPDFFileReloaded.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testCreatePDFDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        PDFDocument pdfDocument = this.workspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        this.reloadWokspaceArea();
        root = this.workspace.getRoot();
        PDFDocument pdfDocumentReloaded = (PDFDocument)this.workspace.getItem(pdfDocument.getId());
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)pdfDocument, (WorkspaceItem)pdfDocumentReloaded);
        UnitTestUtil.testDocumentCreation((Document)pdfDocumentReloaded, folderReloaded, expectedName, expectedDescription, expectedMimeType, WorkspaceItemType.FOLDER_ITEM, expectedOid, expectedCollectionName, expectedMetadata, expectedAnnotation);
        FolderItemType folderItemType = pdfDocumentReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.PDF_DOCUMENT, (Object)folderItemType);
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)pdfDocumentReloaded.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)pdfDocumentReloaded.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testCreateMetadata() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = UnitTestUtil.getID();
        String expectedSchema = "dc";
        String expectedLanguage = "en";
        String expectedMetadata = "<test></test>";
        String expectedCollectionName = "Test collection name";
        Metadata metadata = this.workspace.createMetadata(expectedName, expectedDescription, expectedOid, expectedSchema, expectedLanguage, expectedMetadata, expectedCollectionName, root.getId());
        this.reloadWokspaceArea();
        root = this.workspace.getRoot();
        Metadata metadataReloaded = (Metadata)this.workspace.getItem(metadata.getId());
        WorkspaceItem folderReloaded = this.workspace.getItem(root.getId());
        UnitTestUtil.testWorkspaceItemEquality((WorkspaceItem)metadata, (WorkspaceItem)metadataReloaded);
        UnitTestUtil.testItemCreation((WorkspaceItem)metadataReloaded, folderReloaded, expectedName, expectedDescription, WorkspaceItemType.FOLDER_ITEM);
        Assert.assertEquals((String)"Different oid", (Object)expectedOid, (Object)metadataReloaded.getURI());
        Assert.assertEquals((String)"Different schema", (Object)expectedSchema, (Object)metadataReloaded.getSchema());
        Assert.assertEquals((String)"Different metadata", (Object)expectedMetadata, (Object)metadataReloaded.getData());
        Assert.assertEquals((String)"Different collection name", (Object)expectedCollectionName, (Object)metadataReloaded.getCollectionName());
        FolderItemType folderItemType = metadataReloaded.getFolderItemType();
        Assert.assertEquals((String)"Wrong folder item type", (Object)FolderItemType.METADATA, (Object)folderItemType);
        long expectedLength = expectedMetadata.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)metadataReloaded.getLength());
    }

    @Test
    public final void testRemoveItemSameOidImageDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestImageDocument";
        String expectedDescription = "Test document image description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        ImageDocument imageDocument = this.workspace.createImageDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        String expectedName2 = "TestImageDocument2";
        ImageDocument imageDocument2 = this.workspace.createImageDocument(expectedName2, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        imageDocument.remove();
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)imageDocument2.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)imageDocument2.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testRemoveItemSameOidPDFDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestPDFDocument";
        String expectedDescription = "Test document PDF description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomPDFFile();
        PDFDocument pdfDocument = this.workspace.createPDFDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        String expectedName2 = "TestPDFDocument2";
        PDFDocument pdfDocument2 = this.workspace.createPDFDocument(expectedName2, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        pdfDocument.remove();
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)pdfDocument2.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)pdfDocument2.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }

    @Test
    public final void testRemoveItemSameOidDocument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.workspace.getRoot();
        String expectedName = "TestDocument";
        String expectedDescription = "Test document description";
        String expectedOid = "Test oid";
        String expectedMimeType = "testMimeType";
        String expectedCollectionName = "Test collection name";
        LinkedHashMap<String, String> expectedMetadata = new LinkedHashMap<String, String>();
        expectedMetadata.put("TestMetadataSchemaName", "Test metadata");
        LinkedHashMap<String, String> expectedAnnotation = new LinkedHashMap<String, String>();
        expectedAnnotation.put("TestAnnotation", "Test annotation");
        File fileData = TestDataFactory.getInstance().getTMPRandomImageFile();
        Document document = this.workspace.createDocument(expectedName, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        String expectedName2 = "TestDocument2";
        Document document2 = this.workspace.createDocument(expectedName2, expectedDescription, expectedOid, expectedMimeType, (InputStream)new FileInputStream(fileData), expectedMetadata, expectedAnnotation, expectedCollectionName, root.getId());
        document.remove();
        long expectedLength = fileData.length();
        Assert.assertEquals((String)"Differents length", (long)expectedLength, (long)document2.getLength());
        boolean dataEquals = IOUtils.contentEquals((InputStream)new FileInputStream(fileData), (InputStream)document2.getData());
        Assert.assertTrue((String)"Different content", (boolean)dataEquals);
    }
}

