/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip.zipmodel;

import java.io.File;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItemType;

public abstract class AbstractZipItem
implements ZipItem {
    protected ZipFolder parent;
    protected String name;
    protected ZipItemType type;
    protected String comment;
    protected byte[] extra;

    public AbstractZipItem(ZipFolder parent, String name, ZipItemType type, String comment, byte[] extra) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.extra = extra;
    }

    public AbstractZipItem(String name, ZipItemType type, String comment) {
        this(null, name, type, comment, new byte[0]);
    }

    @Override
    public ZipFolder getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ZipFolder parent) {
        this.parent = parent;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public byte[] getExtra() {
        return this.extra;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ZipItemType getType() {
        return this.type;
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return String.valueOf(File.separatorChar) + this.name;
        }
        return String.valueOf(this.parent.getPath()) + File.separatorChar + this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        sb.append(" ");
        sb.append(this.name);
        sb.append(" ");
        sb.append(this.comment);
        sb.append(" ");
        sb.append(this.extra);
        return sb.toString();
    }
}

