/**
 * 
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class WorkspaceUtil {

	/**
	 * Retrieve an unique name for the specified folder.
	 * @param initialName the initial name.
	 * @param folder the item folder.
	 * @return the unique name.
	 * @throws InternalErrorException if an error occurs.
	 */
	public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException
	{
		List<? extends WorkspaceItem> children = folder.getChildren();
		
		List<String> names = new LinkedList<String>();
		for (WorkspaceItem item:children) {
			names.add(item.getName());
		}
		
		String name = initialName;
		int i = 0;

		while(names.contains(name)){
			
			name = initialName+"("+i+")";
			i++;
		}

		return name;
	}
	
	/**
	 * Clean the given name from invalid chars.
	 * @param name the name to clean.
	 * @return the cleaned name.
	 * @throws InternalErrorException if an error occurs.
	 */
	public static String cleanName(String name) throws InternalErrorException
	{
		return name.replace('/', '_');
	}

	/**
	 * Create a external file in the specified folder.
	 * @param destinationFolder the destination folder.
	 * @param name the external file name.
	 * @param description the external file description.
	 * @param mimeType the external file mimetype.
	 * @param is the external file data.
	 * @return the created external file. 
	 * @throws InsufficientPrivilegesException if an error occurs.
	 * @throws InternalErrorException if an error occurs.
	 * @throws ItemAlreadyExistException if an error occurs.
	 */
	public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException
	{
		if (mimeType!=null){
			if (mimeType.startsWith("image")){
				return destinationFolder.createExternalImageItem(name, description, mimeType, is);
			}else if (mimeType.equals("application/pdf")){
				return destinationFolder.createExternalPDFFileItem(name, description, mimeType, is);
			}else if (mimeType.equals("text/uri-list")){
				return destinationFolder.createExternalUrlItem(name, description, is);
			}
			return destinationFolder.createExternalFileItem(name, description, mimeType, is);
		}
		return destinationFolder.createExternalFileItem(name, description, MimeTypeUtil.BINARY_MIMETYPE, is);

	}

}
