/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.AbstractZipItem;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItem;
import org.gcube.portlets.user.homelibrary.util.zip.zipmodel.ZipItemType;

public class ZipFileModelExtractor {
    protected Logger logger = Logger.getLogger((String)HomeLibrary.class.getPackage().getName());
    protected Map<String, ZipItem> pathItemMap;
    protected ZipInputStream zis;

    public ZipFileModelExtractor(InputStream is) {
        this.zis = new ZipInputStream(is);
        this.pathItemMap = new LinkedHashMap<String, ZipItem>();
    }

    public List<ZipItem> getModel() throws IOException {
        ZipEntry entry;
        while ((entry = this.zis.getNextEntry()) != null) {
            AbstractZipItem item;
            String zipName = entry.getName();
            this.logger.trace((Object)("ZipName: " + zipName));
            String comment = entry.getComment();
            this.logger.trace((Object)("Comment: " + comment));
            byte[] extra = entry.getExtra();
            this.logger.trace((Object)("Extra: " + extra));
            boolean isDirectory = entry.isDirectory();
            this.logger.trace((Object)("isDirectory: " + isDirectory));
            File f = new File(zipName);
            String name = f.getName();
            this.logger.trace((Object)("Name: " + name));
            String path = f.getPath();
            this.logger.trace((Object)("Path: " + path));
            if (isDirectory) {
                item = new ZipFolder(null, name, comment, extra);
            } else {
                File contentFile = File.createTempFile("uploadZip", "tmp");
                FileOutputStream fos = new FileOutputStream(contentFile);
                byte[] buffer = new byte[1024];
                int reads = 0;
                while ((reads = this.zis.read(buffer)) >= 0) {
                    fos.write(buffer, 0, reads);
                }
                fos.close();
                item = new ZipFile(null, contentFile, name, comment, extra);
            }
            this.pathItemMap.put(path, item);
            this.logger.trace((Object)("Inserted " + path + " -> " + item + "\n"));
        }
        return this.assignParents();
    }

    protected List<ZipItem> assignParents() {
        LinkedList<ZipItem> rootsElements = new LinkedList<ZipItem>();
        for (String string : new LinkedList<String>(this.pathItemMap.keySet())) {
            File f = new File(string);
            this.createPath(f.getParent());
        }
        for (Map.Entry entry : this.pathItemMap.entrySet()) {
            ZipItem item = (ZipItem)entry.getValue();
            this.logger.trace((Object)("Elaborating " + item.getName()));
            File f = new File((String)entry.getKey());
            String parentPath = f.getParent();
            this.logger.trace((Object)("ParentPath: " + parentPath));
            if (parentPath != null) {
                if (this.pathItemMap.containsKey(parentPath)) {
                    ZipItem parent = this.pathItemMap.get(parentPath);
                    if (parent.getType() == ZipItemType.FOLDER) {
                        ZipFolder folderParent = (ZipFolder)parent;
                        item.setParent(folderParent);
                        folderParent.addChild(item);
                        this.logger.trace((Object)("Added " + item.getName() + " to " + folderParent.getName()));
                    }
                } else {
                    this.logger.error((Object)"Parent not in map!!!");
                }
            } else {
                rootsElements.add(item);
            }
            this.logger.trace((Object)"\n");
        }
        return rootsElements;
    }

    protected ZipFolder createPath(String path) {
        if (path == null) {
            return null;
        }
        if (this.pathItemMap.containsKey(path)) {
            ZipItem parent = this.pathItemMap.get(path);
            if (parent.getType() == ZipItemType.FOLDER) {
                return (ZipFolder)parent;
            }
            this.logger.error((Object)"The parent is not a folder!!!");
        }
        File f = new File(path);
        String parentPath = f.getParent();
        ZipFolder parent = this.createPath(parentPath);
        String name = f.getName().equals("") ? "ZipFolder" : f.getName();
        ZipFolder folder = new ZipFolder(parent, name, null, null);
        this.pathItemMap.put(path, folder);
        return folder;
    }
}

