/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.data;

import java.util.List;

import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationDataArea;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataFolder;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;


/**
 * Manage home application data.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public interface DataArea {
	
	/**
	 * Return the user home root folder.
	 * @return the application data root.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	DataFolder getDataFolderRoot() throws InternalErrorException;
	
	/**
	 * Return a folder relative to the root folder.
	 * @param relPath the relative path of the folder.
	 * @return the folder with the specified relative path.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	DataFolder getRelativeFolder(String relPath) throws InternalErrorException;
	
	/**
	 * Return the application data area for the specified application.
	 * @param applicationName the application name.
	 * @return the application data area.
	 * @throws InternalErrorException if an error occurs.
	 */
	ApplicationDataArea getApplicationDataArea(String applicationName) throws InternalErrorException;
	
	/**
	 * Return the application data area for the specified application.
	 * @param applicationClass the application class.
	 * @return the application data area.
	 * @throws InternalErrorException if an error occurs.
	 */
	ApplicationDataArea getApplicationDataArea(Class<?> applicationClass) throws InternalErrorException;
	
	/**
	 * Retrieve the list of all application data areas.
	 * @return the application name list.
	 * @throws InternalErrorException if an error occurs.
	 */
	List<String> listApplicationNames() throws InternalErrorException;
	
}
