/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class IndentedVisitor {
    protected static final String DEFAULT_INDENTATION_STRING = "\t";
    protected SimpleDateFormat sdf;
    protected String indentationLevel = "";
    protected String indentationChar;
    protected PrintStream os;
    protected Logger logger;

    public IndentedVisitor() {
        this("", DEFAULT_INDENTATION_STRING, System.out, null);
    }

    public IndentedVisitor(Logger logger) {
        this("", DEFAULT_INDENTATION_STRING, null, logger);
    }

    public IndentedVisitor(String indentationLevel, String indentationChar, PrintStream os, Logger logger) {
        this.indentationLevel = indentationLevel;
        this.indentationChar = indentationChar;
        this.os = os;
        this.logger = logger;
        this.sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
    }

    public void reset() {
        this.indentationLevel = "";
    }

    protected void println() {
        this.println("");
    }

    protected void println(String s) {
        if (this.os != null) {
            this.os.println(String.valueOf(this.indentationLevel) + s);
        }
        if (this.logger != null) {
            this.logger.trace((Object)(String.valueOf(this.indentationLevel) + s));
        }
    }

    protected void indent() {
        this.indentationLevel = String.valueOf(this.indentationLevel) + this.indentationChar;
    }

    protected void outdent() {
        this.indentationLevel = this.indentationLevel.substring(this.indentationChar.length());
    }
}

