/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.data.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import org.gcube.portlets.user.homelibrary.home.data.exceptions.FileAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.data.exceptions.FolderAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.data.exceptions.FolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;


/**
 * A home data folder.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public interface DataFolder extends DataAreaItem {
	
	/**
	 * Create a new folder with the given name.
	 * @param folderName the new folder name.
	 * @return the new folder.
	 * @throws InternalErrorException if an internal error occurs.
	 * @throws FolderAlreadyExistException when a folder with same name already exist.
	 */
	DataFolder createFolder(String folderName) throws InternalErrorException, FolderAlreadyExistException;
	
	/**
	 * List all the items into the folder.
	 * @return the items in the folder.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	List<DataAreaItem> listFiles() throws InternalErrorException;
	
	/**
	 * List all names of the folders inside this folder.
	 * @return the names of folders in the folder.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	List<String> listFolderNames() throws InternalErrorException;
	
	/**
	 * Return a folder with a path relative to this folder.
	 * @param relPath the relative path.
	 * @return the folder.
	 * @throws InternalErrorException if an internal error occurs.
	 * @throws FolderNotFoundException if the folder has not been found.
	 */
	DataFolder getDataFolder(String relPath) throws InternalErrorException, FolderNotFoundException;
	
	/**
	 * Import a file, present in the file system, in this folder.
	 * @param file the file to import.
	 * @throws FileNotFoundException if the file has not found.
	 * @throws InternalErrorException if an internal error occurs.
	 * @throws FileAlreadyExistException if a file with specified name already exist.
	 */
	void importFile(File file) throws FileNotFoundException, InternalErrorException, FileAlreadyExistException;
	
	/**
	 * Import a folder, present in the file system, in this folder.
	 * @param folder the folder to import.
	 * @throws FileNotFoundException if the folder has not found.
	 * @throws InternalErrorException if an internal error occurs.
	 */
	void importFolder(File folder) throws FileNotFoundException, InternalErrorException;
	

	/**
	 * Export this folder and his content in a destination folder in the file system. 
	 * @param destFolder the destination folder.
	 * @throws InternalErrorException if an internal error occurs.
	 * @throws IOException if an error occurs during export operation.
	 */
	void exportFolder(File destFolder) throws InternalErrorException, IOException;

}
