/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;

public class WorkspaceUtil {
    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        List<WorkspaceItem> children = folder.getChildren();
        LinkedList<String> names = new LinkedList<String>();
        for (WorkspaceItem item : children) {
            names.add(item.getName());
        }
        String name = initialName;
        int i = 0;
        while (names.contains(name)) {
            name = String.valueOf(initialName) + "(" + i + ")";
            ++i;
        }
        return name;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        if (mimeType != null) {
            if (mimeType.startsWith("image")) {
                return destinationFolder.createExternalImageItem(name, description, mimeType, is);
            }
            if (mimeType.equals("application/pdf")) {
                return destinationFolder.createExternalPDFFileItem(name, description, mimeType, is);
            }
            if (mimeType.equals("text/uri-list")) {
                return destinationFolder.createExternalUrlItem(name, description, is);
            }
            return destinationFolder.createExternalFileItem(name, description, mimeType, is);
        }
        return destinationFolder.createExternalFileItem(name, description, "application/octet-stream", is);
    }
}

