/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.home.workspace.events;

import java.util.LinkedList;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceEvent;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceEventImpl;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceEventSource;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceEventType;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceListener;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceSentEventImpl;

public abstract class AbstractWorkspaceEventSource
implements WorkspaceEventSource {
    protected List<WorkspaceListener> listeners = new LinkedList<WorkspaceListener>();

    @Override
    public void addWorkspaceListener(WorkspaceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeWorkspaceListener(WorkspaceListener listener) {
        this.listeners.remove(listener);
    }

    public void fireItemCreatedEvent(WorkspaceItem item) {
        this.fireWorkspaceEvent(new WorkspaceEventImpl(WorkspaceEventType.ITEM_CREATED, item));
    }

    public void fireItemRemovedEvent(WorkspaceItem item) {
        this.fireWorkspaceEvent(new WorkspaceEventImpl(WorkspaceEventType.ITEM_REMOVED, item));
    }

    public void fireItemImportedEvent(WorkspaceItem item) {
        this.fireWorkspaceEvent(new WorkspaceEventImpl(WorkspaceEventType.ITEM_IMPORTED, item));
    }

    public void fireItemRenamedEvent(WorkspaceItem item) {
        this.fireWorkspaceEvent(new WorkspaceEventImpl(WorkspaceEventType.ITEM_RENAMED, item));
    }

    public void fireItemSentEvent(WorkspaceItem item, List<User> addressees) {
        this.fireWorkspaceEvent(new WorkspaceSentEventImpl(item, addressees));
    }

    protected void fireWorkspaceEvent(WorkspaceEvent event) {
        for (WorkspaceListener listener : this.listeners) {
            listener.workspaceEvent(event);
        }
    }
}

