/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;

public class WorkspaceUtil {
    public static String getUniqueName(String initialName, WorkspaceFolder folder) throws InternalErrorException {
        List<WorkspaceItem> children = folder.getChildren();
        LinkedList<String> names = new LinkedList<String>();
        for (WorkspaceItem item : children) {
            names.add(item.getName());
        }
        String name = initialName;
        int i = 0;
        while (names.contains(name)) {
            name = initialName + "(" + i + ")";
            ++i;
        }
        return name;
    }

    public static String cleanName(String name) throws InternalErrorException {
        return name.replace('/', '_');
    }

    public static FolderItem createExternalFile(WorkspaceFolder destinationFolder, String name, String description, String mimeType, InputStream is) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException {
        String mimeTypeChecked = mimeType;
        String extension = null;
        String[] values = name.split("\\.");
        if (values.length > 1) {
            extension = values[values.length - 1];
        }
        List<String> zipMimeTypes = Arrays.asList(MimeTypeUtil.ZIP_MIMETYPES);
        if ((mimeTypeChecked.equals("application/octet-stream") || zipMimeTypes.contains(mimeTypeChecked) || mimeTypeChecked.startsWith("application")) && extension != null) {
            mimeTypeChecked = MimeTypeUtil.getMimeType(extension);
        }
        if (mimeTypeChecked != null) {
            if (mimeTypeChecked.startsWith("image")) {
                return destinationFolder.createExternalImageItem(name, description, mimeTypeChecked, is);
            }
            if (mimeTypeChecked.equals("application/pdf")) {
                return destinationFolder.createExternalPDFFileItem(name, description, mimeTypeChecked, is);
            }
            if (mimeTypeChecked.equals("text/uri-list")) {
                return destinationFolder.createExternalUrlItem(name, description, is);
            }
            return destinationFolder.createExternalFileItem(name, description, mimeTypeChecked, is);
        }
        return destinationFolder.createExternalFileItem(name, description, mimeType, is);
    }
}

