/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.util.LinkedList;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.testdata.AbstractDataManager;
import org.gcube.portlets.user.homelibrary.testdata.data.WorkflowTemplateData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class WorkflowTemplateDataManager
extends AbstractDataManager<WorkflowTemplateData, WorkflowTemplate> {
    public WorkflowTemplateDataManager() {
        super("workflowtemplates.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("workflowtemplate", WorkflowTemplateData.class);
        this.xstream.alias("workflowtemplates", LinkedList.class);
    }

    @Override
    protected WorkflowTemplate fillData(WorkspaceFolder destinationFolder, WorkflowTemplateData testData) throws InternalErrorException {
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createWorkflowTemplate(name, testData.getDescription(), testData.getWorkflowId(), testData.getWorkflowStatus(), testData.getWorkflowData());
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the workflow template", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the workflow template", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

