/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.invitefriends.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.invites.InvitesManager;
import org.gcube.portlets.user.invitefriends.client.InviteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InviteServiceImpl
extends RemoteServiceServlet
implements InviteService {
    private static final Logger _log = LoggerFactory.getLogger(InviteServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user");
            user = "test.user";
        } else {
            _log.info("LIFERAY PORTAL DETECTED user=" + user);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public InviteOperationResult sendInvite(String name, String lastName, String email) throws IllegalArgumentException {
        ASLSession aslSession = this.getASLSession();
        String portalUrl = null;
        String vreDescription = null;
        long organizationId = this.getASLSession().getGroupId();
        try {
            portalUrl = PortalUtil.getPortalURL((String)OrganizationsUtil.getCompany().getVirtualHost(), (int)PortalUtil.getPortalPort(), (boolean)true);
            vreDescription = OrganizationLocalServiceUtil.getOrganization((long)organizationId).getComments();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            _log.warn("While trying to send email for invitation to " + email);
            return null;
        }
        String portalSenderEmail = PortalContext.getConfiguration().getSenderEmail();
        return InvitesManager.getInstance().sendInvite(aslSession, portalSenderEmail, portalUrl, name, lastName, email, vreDescription);
    }
}

