package org.gcube.portlets.user.joinvre.client.ui;

import static com.google.gwt.query.client.GQuery.$;
import static com.google.gwt.query.client.css.CSS.WIDTH;
import static com.google.gwt.query.client.GQuery.window; 
import java.util.List;

import org.gcube.portlets.user.gcubewidgets.client.elements.Div;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class DisplayVRE extends Composite {

	interface DisplayVREUiBinder extends UiBinder<Widget, DisplayVRE> {}

	private static DisplayVREUiBinder uiBinder = GWT.create(DisplayVREUiBinder.class);

	private final JoinServiceAsync joinService = GWT.create(JoinService.class);

	public static final String vreDefaultImage = GWT.getModuleBaseURL() + "../images/vre-default.png";
	public static final String loadingImage = GWT.getModuleBaseURL() + "../images/vre-image-loader.gif";

	public static LoadingPopUp loadingPopUp = new LoadingPopUp(false, true, loadingImage);

	public static final String REQUEST_ACCESS = "Request Access";
	public static final String FREE_ACCESS = "Free Access";



	@UiField HTMLPanel mainPanel;
	@UiField Image vreImage;
	@UiField Label vreName;
	@UiField HTMLPanel vreCategories;
	@UiField Div vreDesc;
	@UiField Button joinButton;
	@UiField Button closeButton;

	public DisplayVRE(final VRE vre) {
		Widget widget = uiBinder.createAndBindUi(this);
		vreImage.setUrl(loadingImage);
		closeButton.setText("Collapse");
		vreDesc.setHTML(vre.getDescription());

		if(vre.getImageURL().compareTo("")!=0){
			vreImage.setUrl(vre.getImageURL());
		}else{
			vreImage.setUrl(vreDefaultImage);
		}

		final String name = vre.getName();
		ClickHandler descriptionHandler = new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				if ($(mainPanel).css(WIDTH).compareTo("160px") == 0) 
					show();
				else
					collapse();
				
			}
		};
		closeButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				collapse();
			}
		});

		vreImage.setTitle("Click to see details");
		vreImage.addClickHandler(descriptionHandler);

		vreName.setTitle(name);
		vreName.setText(name);
		vreName.addClickHandler(descriptionHandler);

		List<VRECategory> categories = vre.getCategories();
		for(int i=0; i<categories.size(); i++){
			vreCategories.add(new Label(categories.get(i).getName()));
			if(i!=categories.size()-1){
				vreCategories.add(new Label(","));
			}
		}

		if(vre.isUponRequest()){
			joinButton.setText(REQUEST_ACCESS);
		}else{
			joinButton.setText(FREE_ACCESS);
			joinButton.setStyleName("freeAccessButton", true);
		}
		joinButton.setStyleName("joinButton", true);
		joinButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				loadingPopUp.show();
				joinService.joinVRE(vre.getId(), new AsyncCallback<Boolean>() {

					@Override
					public void onFailure(Throwable caught) {
						loadingPopUp.hide();
						String error = "Error";
						String errorDescription = "Error while trying to join to" 
								+ name + " VRE. Please Try again later. "
								+ "If the problem persist contact system administrator";
						final InfoDialog infoDialog = new InfoDialog(error, errorDescription);
						infoDialog.show();
					}

					@Override
					public void onSuccess(Boolean result) {
						loadingPopUp.hide();
						Window.open("/group/data-e-infrastructure-gateway/join-new?orgid="+vre.getId(), "_self", "");
					}

				});
			}
		});


		initWidget(widget);
	}
	
	private void show() {
		$(mainPanel).animate("width:'927px'", 120, new Function(){
			public void f(Element e){
				$(vreDesc).fadeIn();
				$(closeButton).fadeIn();
				$(window).scrollTo(0, mainPanel.getAbsoluteTop()-310); 
			}
		});
		vreImage.setTitle("Click to collapse");
	}
	private void collapse() {
		$(closeButton).fadeOut();
		$(vreDesc).fadeOut(new Function(){
			public void f(Element e){
				$(mainPanel).animate("width:'160px'", 150);
			}
		});
		vreImage.setTitle("Click to see details");
	}

	public void showError(String message) {
		Window.alert("Failure: " + message);
		vreImage.setSize("100px", "100px");
		vreImage.setUrl(vreDefaultImage);				
	}



}
