package org.gcube.portlets.user.joinvre.server;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.gcube.common.portal.GCubePortalConstants;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.EmailNotification;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 * 
 */
public class LoginServiceUtil {
	/**
	 * 
	 */
	public static final String ROOT_ORG = "rootorganization";
	
	public static final String MANAGE_USERS_REQUESTS_FRIENDLY_URL = "/manage-user-and-requests";
	/**
	 * 
	 */
	public static final String PUBLIC_LAYOUT_NAME = "Data e-Infrastructure gateway";
	/**
	 * 
	 */
	public static final String GUEST_COMMUNITY_NAME = "Guest";

	private static Logger _log = LoggerFactory.getLogger(LoginServiceUtil.class);	
	
	protected static ArrayList<String> getAdministratorsEmails(String scope) {
		LiferayUserManager userManager = new LiferayUserManager();
		LiferayGroupManager groupManager = new LiferayGroupManager();
		long groupId = -1;
		try {
			List<GCubeGroup> allGroups = groupManager.listGroups();
			_log.debug("Number of groups retrieved: " + allGroups.size());
			for (int i = 0; i < allGroups.size(); i++) {
				long grId = allGroups.get(i).getGroupId();
				String groupScope = groupManager.getInfrastructureScope(grId);
				System.out.println("Comparing: " + groupScope + " " + scope);
				if (groupScope.equals(scope)) {
					groupId = allGroups.get(i).getGroupId();
					break;
				}
			}
		} catch (UserManagementSystemException e) {
			e.printStackTrace();
		} catch (GroupRetrievalFault e) {
			e.printStackTrace();
		}
		Map<GCubeUser, List<GCubeRole>> usersAndRoles = null;
		try {
			usersAndRoles = userManager.listUsersAndRolesByGroup(groupId);
		} catch (Exception e) {
			e.printStackTrace();
		} 
		Set<GCubeUser> users = usersAndRoles.keySet();
		ArrayList<String> adminEmailsList = new ArrayList<String>();
		for (GCubeUser usr:users) {
			List<GCubeRole> roles = usersAndRoles.get(usr);
			for (int i = 0; i < roles.size(); i++) {
				if (roles.get(i).getRoleName().equals("VO-Admin") || roles.get(i).getRoleName().equals("VRE-Manager")) {
					adminEmailsList.add(usr.getEmail());
					_log.debug("Admin: " + usr.getFullname());
					break;
				}
			}
		}
		return adminEmailsList;
	}

	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void addMembershipRequest(String username, String scope, String optionalMessage, HttpServletRequest request) throws Exception{
		
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		_log.info("gatewayName = " + gatewayName + " Message=" + optionalMessage);
	
		
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);

		UserManager um = new LiferayUserManager();
		
		GCubeUser currUser = um.getUserByUsername(username);
		String fullName = currUser.getFullname();

		String selectedVRE = scope.substring(scope.lastIndexOf("/")+1, scope.length());		
		_log.info("Requested MEMBERSHIP for: " + selectedVRE + " scope: " +	scope);
		GroupManager gm = new LiferayGroupManager();
		long gatewayGroupId = gm.getGroupId(gatewayName);
		long vreGroupId = gm.getGroupIdFromInfrastructureScope(scope);
		um.requestMembership(currUser.getUserId(),vreGroupId, optionalMessage);

		String manageRequestURL = portalbasicurl + GCubePortalConstants.PREFIX_GROUP_URL + "/"+ selectedVRE.toLowerCase() + MANAGE_USERS_REQUESTS_FRIENDLY_URL;
		
		long vreLogoId = gm.getGroup(vreGroupId).getLogoId();
		String vreLogoURL = portalbasicurl + gm.getGroupLogoURL(vreLogoId);
		
		long gatewayLogoId = gm.getGroup(gatewayGroupId).getLogoId();
		String gatewayLogoURL = portalbasicurl + gm.getGroupLogoURL(gatewayLogoId);
		
		StringBuffer body = new StringBuffer();
		
		String encodedTemplate = "PCEtLSBJbmxpbmVyIEJ1aWxkIFZlcnNpb24gNDM4MGI3NzQxYmI3NTlkNmNiOTk3NTQ1ZjNhZGQyMWFkNDhmMDEwYiAtLT4NCjwhRE9DVFlQRSBodG1sIFBVQkxJQyAiLS8vVzNDLy9EVEQgWEhUTUwgMS4wIFN0cmljdC8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9UUi94aHRtbDEvRFREL3hodG1sMS1zdHJpY3QuZHRkIj4NCjxodG1sIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hodG1sIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94aHRtbCIgc3R5bGU9Im1pbi1oZWlnaHQ6IDEwMCU7IGJhY2tncm91bmQtY29sb3I6ICNmM2YzZjMgIWltcG9ydGFudDsiPg0KICA8aGVhZD4NCiAgICA8bWV0YSBodHRwLWVxdWl2PSJDb250ZW50LVR5cGUiIGNvbnRlbnQ9InRleHQvaHRtbDsgY2hhcnNldD11dGYtOCIgLz4NCiAgICA8bWV0YSBuYW1lPSJ2aWV3cG9ydCIgY29udGVudD0id2lkdGg9ZGV2aWNlLXdpZHRoIiAvPg0KICAgIDx0aXRsZT5UaXRsZTwvdGl0bGU+DQogIDwvaGVhZD4NCiAgPGJvZHkgc3R5bGU9IndpZHRoOiAxMDAlICFpbXBvcnRhbnQ7IG1pbi13aWR0aDogMTAwJTsgLXdlYmtpdC10ZXh0LXNpemUtYWRqdXN0OiAxMDAlOyAtbXMtdGV4dC1zaXplLWFkanVzdDogMTAwJTsgLW1vei1ib3gtc2l6aW5nOiBib3JkZXItYm94OyAtd2Via2l0LWJveC1zaXppbmc6IGJvcmRlci1ib3g7IGJveC1zaXppbmc6IGJvcmRlci1ib3g7IGNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgdGV4dC1hbGlnbjogbGVmdDsgbGluZS1oZWlnaHQ6IDEuMzsgZm9udC1zaXplOiAxNnB4OyBiYWNrZ3JvdW5kLWNvbG9yOiAjZjNmM2YzICFpbXBvcnRhbnQ7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGJnY29sb3I9IiNmM2YzZjMgIWltcG9ydGFudCI+DQogICAgPHRhYmxlIGNsYXNzPSJib2R5IiBkYXRhLW1hZGUtd2l0aC1mb3VuZGF0aW9uPSIiIHN0eWxlPSJib3JkZXItc3BhY2luZzogMDsgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZTsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgYmFja2dyb3VuZC1jb2xvcjogI2YzZjNmMyAhaW1wb3J0YW50OyBoZWlnaHQ6IDEwMCU7IHdpZHRoOiAxMDAlOyBjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwOyBwYWRkaW5nOiAwOyIgYmdjb2xvcj0iI2YzZjNmMyAhaW1wb3J0YW50Ij48dHIgc3R5bGU9InZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+PHRkIGNsYXNzPSJmbG9hdC1jZW50ZXIiIGFsaWduPSJjZW50ZXIiIHZhbGlnbj0idG9wIiBzdHlsZT0id29yZC13cmFwOiBicmVhay13b3JkOyAtd2Via2l0LWh5cGhlbnM6IGF1dG87IC1tb3otaHlwaGVuczogYXV0bzsgaHlwaGVuczogYXV0bzsgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZSAhaW1wb3J0YW50OyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBjZW50ZXI7IGZsb2F0OiBub25lOyBjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwIGF1dG87IHBhZGRpbmc6IDA7Ij4NCiAgICAgICAgICA8Y2VudGVyIGRhdGEtcGFyc2VkPSIiIHN0eWxlPSJ3aWR0aDogMTAwJTsgbWluLXdpZHRoOiA1ODBweDsiPg0KICAgICAgICAgICAgPHRhYmxlIGFsaWduPSJjZW50ZXIiIGNsYXNzPSJ3cmFwcGVyIGhlYWRlciBmbG9hdC1jZW50ZXIiIHN0eWxlPSJ3aWR0aDogMTAwJTsgYm9yZGVyLXNwYWNpbmc6IDA7IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2U7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGNlbnRlcjsgZmxvYXQ6IG5vbmU7IG1hcmdpbjogMCBhdXRvOyBwYWRkaW5nOiAwOyI+PHRyIHN0eWxlPSJ2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiPjx0ZCBjbGFzcz0id3JhcHBlci1pbm5lciIgc3R5bGU9IndvcmQtd3JhcDogYnJlYWstd29yZDsgLXdlYmtpdC1oeXBoZW5zOiBhdXRvOyAtbW96LWh5cGhlbnM6IGF1dG87IGh5cGhlbnM6IGF1dG87IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2UgIWltcG9ydGFudDsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0IiB2YWxpZ249InRvcCI+DQogICAgICAgICAgICAgICAgICA8dGFibGUgYWxpZ249ImNlbnRlciIgY2xhc3M9ImNvbnRhaW5lciIgc3R5bGU9ImJvcmRlci1zcGFjaW5nOiAwOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlOyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBpbmhlcml0OyB3aWR0aDogNTgwcHg7IGJhY2tncm91bmQ6ICNmZWZlZmU7IG1hcmdpbjogMCBhdXRvOyBwYWRkaW5nOiAwOyIgYmdjb2xvcj0iI2ZlZmVmZSI+PHRib2R5Pjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGQgc3R5bGU9IndvcmQtd3JhcDogYnJlYWstd29yZDsgLXdlYmtpdC1oeXBoZW5zOiBhdXRvOyAtbW96LWh5cGhlbnM6IGF1dG87IGh5cGhlbnM6IGF1dG87IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2UgIWltcG9ydGFudDsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0IiB2YWxpZ249InRvcCI+DQogICAgICAgICAgICAgICAgICAgICAgICAgIDx0YWJsZSBjbGFzcz0icm93IGNvbGxhcHNlIiBzdHlsZT0iYm9yZGVyLXNwYWNpbmc6IDA7IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2U7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IHdpZHRoOiAxMDAlOyBwb3NpdGlvbjogcmVsYXRpdmU7IGRpc3BsYXk6IHRhYmxlOyBwYWRkaW5nOiAwOyI+PHRib2R5Pjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGggY2xhc3M9InNtYWxsLTYgbGFyZ2UtNiBjb2x1bW5zIGZpcnN0IiBzdHlsZT0id2lkdGg6IDI5OHB4OyBjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwIGF1dG87IHBhZGRpbmc6IDAgMCAxNnB4OyIgYWxpZ249ImxlZnQiPg0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0YWJsZSBzdHlsZT0iYm9yZGVyLXNwYWNpbmc6IDA7IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2U7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IHdpZHRoOiAxMDAlOyBwYWRkaW5nOiAwOyI+PHRyIHN0eWxlPSJ2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiPjx0aCBzdHlsZT0iY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyB0ZXh0LWFsaWduOiBsZWZ0OyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij4gPGltZyBzcmM9Int7R0FURVdBWV9MT0dPOlVSTH19IiBzdHlsZT0id2lkdGg6IDIwMHB4OyBvdXRsaW5lOiBub25lOyB0ZXh0LWRlY29yYXRpb246IG5vbmU7IC1tcy1pbnRlcnBvbGF0aW9uLW1vZGU6IGJpY3ViaWM7IG1heC13aWR0aDogMTAwJTsgY2xlYXI6IGJvdGg7IGRpc3BsYXk6IGJsb2NrOyIgLz48L3RoPg0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC90cj48L3RhYmxlPjwvdGg+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0aCBjbGFzcz0ic21hbGwtNiBsYXJnZS02IGNvbHVtbnMgbGFzdCIgc3R5bGU9IndpZHRoOiAyOThweDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyB0ZXh0LWFsaWduOiBsZWZ0OyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMCBhdXRvOyBwYWRkaW5nOiAwIDAgMTZweDsiIGFsaWduPSJsZWZ0Ij4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGFibGUgc3R5bGU9ImJvcmRlci1zcGFjaW5nOiAwOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlOyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyB3aWR0aDogMTAwJTsgcGFkZGluZzogMDsiPjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGggc3R5bGU9ImNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgdGV4dC1hbGlnbjogbGVmdDsgbGluZS1oZWlnaHQ6IDEuMzsgZm9udC1zaXplOiAxNnB4OyBtYXJnaW46IDA7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHAgY2xhc3M9InRleHQtcmlnaHQiIHN0eWxlPSJ0ZXh0LWFsaWduOiByaWdodDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMCAwIDEwcHg7IHBhZGRpbmc6IDA7IiBhbGlnbj0icmlnaHQiPnt7R0FURVdBWV9OQU1FfX08L3A+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGg+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RyPjwvdGFibGU+PC90aD4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdHI+PC90Ym9keT48L3RhYmxlPjwvdGQ+DQogICAgICAgICAgICAgICAgICAgICAgPC90cj48L3Rib2R5PjwvdGFibGU+PC90ZD4NCiAgICAgICAgICAgICAgPC90cj48L3RhYmxlPjx0YWJsZSBhbGlnbj0iY2VudGVyIiBjbGFzcz0iY29udGFpbmVyIGJvZHktYm9yZGVyIGZsb2F0LWNlbnRlciIgc3R5bGU9ImJvcmRlci1zcGFjaW5nOiAwOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlOyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBjZW50ZXI7IHdpZHRoOiA1ODBweDsgZmxvYXQ6IG5vbmU7IGJvcmRlci10b3Atd2lkdGg6IDhweDsgYm9yZGVyLXRvcC1jb2xvcjogIzIyNWY5NzsgYm9yZGVyLXRvcC1zdHlsZTogc29saWQ7IGJhY2tncm91bmQ6ICNmZWZlZmU7IG1hcmdpbjogMCBhdXRvOyBwYWRkaW5nOiAwOyIgYmdjb2xvcj0iI2ZlZmVmZSI+PHRib2R5Pjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGQgc3R5bGU9IndvcmQtd3JhcDogYnJlYWstd29yZDsgLXdlYmtpdC1oeXBoZW5zOiBhdXRvOyAtbW96LWh5cGhlbnM6IGF1dG87IGh5cGhlbnM6IGF1dG87IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2UgIWltcG9ydGFudDsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0IiB2YWxpZ249InRvcCI+DQogICAgICAgICAgICAgICAgICAgIDx0YWJsZSBjbGFzcz0icm93IiBzdHlsZT0iYm9yZGVyLXNwYWNpbmc6IDA7IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2U7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IHdpZHRoOiAxMDAlOyBwb3NpdGlvbjogcmVsYXRpdmU7IGRpc3BsYXk6IHRhYmxlOyBwYWRkaW5nOiAwOyI+PHRib2R5Pjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGggY2xhc3M9InNtYWxsLTEyIGxhcmdlLTEyIGNvbHVtbnMgZmlyc3QgbGFzdCIgc3R5bGU9IndpZHRoOiA1NjRweDsgY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyB0ZXh0LWFsaWduOiBsZWZ0OyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMCBhdXRvOyBwYWRkaW5nOiAwIDE2cHggMTZweDsiIGFsaWduPSJsZWZ0Ij4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGFibGUgc3R5bGU9ImJvcmRlci1zcGFjaW5nOiAwOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlOyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyB3aWR0aDogMTAwJTsgcGFkZGluZzogMDsiPjx0ciBzdHlsZT0idmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij48dGggc3R5bGU9ImNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgdGV4dC1hbGlnbjogbGVmdDsgbGluZS1oZWlnaHQ6IDEuMzsgZm9udC1zaXplOiAxNnB4OyBtYXJnaW46IDA7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRhYmxlIGNsYXNzPSJzcGFjZXIiIHN0eWxlPSJib3JkZXItc3BhY2luZzogMDsgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZTsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgd2lkdGg6IDEwMCU7IHBhZGRpbmc6IDA7Ij48dGJvZHk+PHRyIHN0eWxlPSJ2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiPjx0ZCBoZWlnaHQ9IjMycHgiIHN0eWxlPSJmb250LXNpemU6IDMycHg7IGxpbmUtaGVpZ2h0OiAzMnB4OyB3b3JkLXdyYXA6IGJyZWFrLXdvcmQ7IC13ZWJraXQtaHlwaGVuczogYXV0bzsgLW1vei1oeXBoZW5zOiBhdXRvOyBoeXBoZW5zOiBhdXRvOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlICFpbXBvcnRhbnQ7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IG1zby1saW5lLWhlaWdodC1ydWxlOiBleGFjdGx5OyBjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0IiB2YWxpZ249InRvcCI+wqA8L3RkPg0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RyPjwvdGJvZHk+PC90YWJsZT48Y2VudGVyIGRhdGEtcGFyc2VkPSIiIHN0eWxlPSJ3aWR0aDogMTAwJTsgbWluLXdpZHRoOiA1MzJweDsiPiAgPGltZyBzcmM9Int7VlJFX0xPR086VVJMfX0iIHN0eWxlPSJ3aWR0aDogMTUwcHg7IG91dGxpbmU6IG5vbmU7IHRleHQtZGVjb3JhdGlvbjogbm9uZTsgLW1zLWludGVycG9sYXRpb24tbW9kZTogYmljdWJpYzsgbWF4LXdpZHRoOiAxMDAlOyBjbGVhcjogYm90aDsgZGlzcGxheTogYmxvY2s7IGZsb2F0OiBub25lOyB0ZXh0LWFsaWduOiBjZW50ZXI7IG1hcmdpbjogMCBhdXRvOyIgYWxpZ249ImNlbnRlciIgY2xhc3M9ImZsb2F0LWNlbnRlciIgLz48L2NlbnRlcj4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGFibGUgY2xhc3M9InNwYWNlciIgc3R5bGU9ImJvcmRlci1zcGFjaW5nOiAwOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlOyB2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyB3aWR0aDogMTAwJTsgcGFkZGluZzogMDsiPjx0Ym9keT48dHIgc3R5bGU9InZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+PHRkIGhlaWdodD0iMTZweCIgc3R5bGU9ImZvbnQtc2l6ZTogMTZweDsgbGluZS1oZWlnaHQ6IDE2cHg7IHdvcmQtd3JhcDogYnJlYWstd29yZDsgLXdlYmtpdC1oeXBoZW5zOiBhdXRvOyAtbW96LWh5cGhlbnM6IGF1dG87IGh5cGhlbnM6IGF1dG87IGJvcmRlci1jb2xsYXBzZTogY29sbGFwc2UgIWltcG9ydGFudDsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgbXNvLWxpbmUtaGVpZ2h0LXJ1bGU6IGV4YWN0bHk7IGNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgbWFyZ2luOiAwOyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiIHZhbGlnbj0idG9wIj7CoDwvdGQ+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdHI+PC90Ym9keT48L3RhYmxlPjxwIHN0eWxlPSJjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwIDAgMTBweDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij5Zb3UgcmVjZWl2ZWQgdGhpcyBlbWFpbCBiZWNhdXNlIHlvdSBhcmUgYSBtYW5hZ2VyIG9mIHt7U0VMRUNURURfVlJFX05BTUV9fS48L3A+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGg0IHN0eWxlPSJjb2xvcjogaW5oZXJpdDsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IHdvcmQtd3JhcDogbm9ybWFsOyBmb250LXNpemU6IDI0cHg7IG1hcmdpbjogMCAwIDEwcHg7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+e3tVU0VSX0ZVTExOQU1FfX0gd291bGQgbGlrZSB0byBhY2Nlc3Mge3tTRUxFQ1RFRF9WUkVfTkFNRX19IFZSRSw8L2g0Pg0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwIHN0eWxlPSJjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwIDAgMTBweDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij5GdXJ0aGVyIGluZm8gYWJvdXQge3tVU0VSX0ZVTExOQU1FfX06PC9wPg0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwIHN0eWxlPSJjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IGZvbnQtc2l6ZTogMTZweDsgbWFyZ2luOiAwIDAgMTBweDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0Ij5FbWFpbDoge3tVU0VSX0VNQUlMfX08L3A+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHAgc3R5bGU9ImNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgdGV4dC1hbGlnbjogbGVmdDsgbGluZS1oZWlnaHQ6IDEuMzsgZm9udC1zaXplOiAxNnB4OyBtYXJnaW46IDAgMCAxMHB4OyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiPlVzZXJuYW1lOiB7e1VTRVJfSUR9fTwvcD4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cCBzdHlsZT0iY29sb3I6ICMwYTBhMGE7IGZvbnQtZmFtaWx5OiBIZWx2ZXRpY2EsIEFyaWFsLCBzYW5zLXNlcmlmOyBmb250LXdlaWdodDogbm9ybWFsOyB0ZXh0LWFsaWduOiBsZWZ0OyBsaW5lLWhlaWdodDogMS4zOyBmb250LXNpemU6IDE2cHg7IG1hcmdpbjogMCAwIDEwcHg7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+T3B0aW9uYWwgbWVzc2FnZToge3tPUFRJT05BTF9NRVNTQUdFfX08L3A+DQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGJyIC8+PGg0IHN0eWxlPSJjb2xvcjogaW5oZXJpdDsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IHdvcmQtd3JhcDogbm9ybWFsOyBmb250LXNpemU6IDI0cHg7IG1hcmdpbjogMCAwIDEwcHg7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+UGxlYXNlIDxhIGhyZWY9Int7TUFOQUdFX1JFUVVFU1RfVVJMfX0iIHN0eWxlPSJjb2xvcjogIzIxOTllODsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IHRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjM7IHRleHQtZGVjb3JhdGlvbjogbm9uZTsgbWFyZ2luOiAwOyBwYWRkaW5nOiAwOyI+Y2xpY2sgaGVyZTwvYT4gdG8gbWFuYWdlIHRoaXMgcmVxdWVzdDwvaDQ+DQo8IS0tICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8Y2VudGVyIGRhdGEtcGFyc2VkPSIiPiAtLT4NCjwhLS0gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRhYmxlIGFsaWduPSJjZW50ZXIiIGNsYXNzPSJtZW51IGZsb2F0LWNlbnRlciI+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0cj4gLS0+DQo8IS0tICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGQ+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGFibGU+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0cj4gLS0+DQo8IS0tICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dGggY2xhc3M9Im1lbnUtaXRlbSBmbG9hdC1jZW50ZXIiPjxhIGhyZWY9Imh0dHA6Ly93d3cuZDRzY2llbmNlLm9yZyI+RDRTY2llbmNlLm9yZyB3ZWJzaXRlPC9hPjwvdGg+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRoIGNsYXNzPSJtZW51LWl0ZW0gZmxvYXQtY2VudGVyIj48YSBocmVmPSJodHRwczovL3R3aXR0ZXIuY29tL2Q0c2NpZW5jZSI+VHdpdHRlcjwvYT48L3RoPiAtLT4NCjwhLS0gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0aCBjbGFzcz0ibWVudS1pdGVtIGZsb2F0LWNlbnRlciI+PGEgaHJlZj0ibWFpbHRvOiBzdXBwb3J0QGQ0c2NpZW5jZS5vcmciPkNvbnRhY3QgRDRTY2llbmNlPC9hPjwvdGg+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdHI+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RhYmxlPiAtLT4NCjwhLS0gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdHI+IC0tPg0KPCEtLSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RhYmxlPiAtLT4NCjwhLS0gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvY2VudGVyPiAtLT4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC90aD4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHRoIGNsYXNzPSJleHBhbmRlciIgc3R5bGU9InZpc2liaWxpdHk6IGhpZGRlbjsgd2lkdGg6IDA7IGNvbG9yOiAjMGEwYTBhOyBmb250LWZhbWlseTogSGVsdmV0aWNhLCBBcmlhbCwgc2Fucy1zZXJpZjsgZm9udC13ZWlnaHQ6IG5vcm1hbDsgdGV4dC1hbGlnbjogbGVmdDsgbGluZS1oZWlnaHQ6IDEuMzsgZm9udC1zaXplOiAxNnB4OyBtYXJnaW46IDA7IHBhZGRpbmc6IDA7IiBhbGlnbj0ibGVmdCI+PC90aD4NCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdHI+PC90YWJsZT48L3RoPg0KICAgICAgICAgICAgICAgICAgICAgICAgPC90cj48L3Rib2R5PjwvdGFibGU+PHRhYmxlIGNsYXNzPSJzcGFjZXIiIHN0eWxlPSJib3JkZXItc3BhY2luZzogMDsgYm9yZGVyLWNvbGxhcHNlOiBjb2xsYXBzZTsgdmVydGljYWwtYWxpZ246IHRvcDsgdGV4dC1hbGlnbjogbGVmdDsgd2lkdGg6IDEwMCU7IHBhZGRpbmc6IDA7Ij48dGJvZHk+PHRyIHN0eWxlPSJ2ZXJ0aWNhbC1hbGlnbjogdG9wOyB0ZXh0LWFsaWduOiBsZWZ0OyBwYWRkaW5nOiAwOyIgYWxpZ249ImxlZnQiPjx0ZCBoZWlnaHQ9IjE2cHgiIHN0eWxlPSJmb250LXNpemU6IDE2cHg7IGxpbmUtaGVpZ2h0OiAxNnB4OyB3b3JkLXdyYXA6IGJyZWFrLXdvcmQ7IC13ZWJraXQtaHlwaGVuczogYXV0bzsgLW1vei1oeXBoZW5zOiBhdXRvOyBoeXBoZW5zOiBhdXRvOyBib3JkZXItY29sbGFwc2U6IGNvbGxhcHNlICFpbXBvcnRhbnQ7IHZlcnRpY2FsLWFsaWduOiB0b3A7IHRleHQtYWxpZ246IGxlZnQ7IG1zby1saW5lLWhlaWdodC1ydWxlOiBleGFjdGx5OyBjb2xvcjogIzBhMGEwYTsgZm9udC1mYW1pbHk6IEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7IGZvbnQtd2VpZ2h0OiBub3JtYWw7IG1hcmdpbjogMDsgcGFkZGluZzogMDsiIGFsaWduPSJsZWZ0IiB2YWxpZ249InRvcCI+wqA8L3RkPg0KICAgICAgICAgICAgICAgICAgICAgICAgPC90cj48L3Rib2R5PjwvdGFibGU+PC90ZD4NCiAgICAgICAgICAgICAgICA8L3RyPjwvdGJvZHk+PC90YWJsZT48L2NlbnRlcj4NCiAgICAgICAgPC90ZD4NCiAgICAgIDwvdHI+PC90YWJsZT48L2JvZHk+DQo8L2h0bWw+DQo=";
		/**
         * Decoding our HTML and substituting required values.
         */
		byte[] base64DecodedData = Base64.getDecoder().decode(encodedTemplate);
		
		String template = new String(base64DecodedData)
				.replace("{{SELECTED_VRE_NAME}}", selectedVRE)
				.replace("{{VRE_LOGO:URL}}", vreLogoURL)
				.replace("{{GATEWAY_LOGO:URL}}", gatewayLogoURL)			
				.replace("{{GATEWAY_NAME}}", gatewayName)
				.replace("{{MANAGE_REQUEST_URL}}", manageRequestURL)
				.replace("{{USER_EMAIL}}", currUser.getEmail())
				.replace("{{USER_ID}}", username)
				.replace("{{USER_FULLNAME}}", fullName)
				.replace("{{OPTIONAL_MESSAGE}}", optionalMessage);
		
		body.append(template);
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "Request for access to VRE " + selectedVRE, body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void notifyUserSelfRegistration(String username, String scope, HttpServletRequest request) throws Exception {
			
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);
		LiferayUserManager um = new LiferayUserManager();
		GCubeUser currUser = um.getUserByUsername(username);
		String name = currUser.getFirstName();
		String lastname = currUser.getLastName();
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		StringBuffer body = new StringBuffer();
		body.append("<p>Dear manager of "+ scope +",<br />this email message was automatically generated by " + portalbasicurl +" to inform you that ");
		body.append("</p>").append("<p>")
		.append("<b>"+name + " " + lastname +"</b> has self registered to the following environment: ")
		.append("<br /><br />")
		.append("<b>" + scope+"</b>")
		.append("<br />")
		.append("<br />")
		.append("<b>Username: </b>" + username)
		.append("<br />")
		.append("<b>e-mail: </b>" + currUser.getEmail())
		.append("</p>")
		.append("<p>")
		.append("<br />" + portalbasicurl)
		.append("</p>");
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "[" + gatewayName + "] - Self Registration", body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
	
	/**
	 * 
	 * @param scope .
	 * @param optionalMessage .
	 */
	public static void notifyUserAcceptedInvite(String username, String scope, Invite invite, HttpServletRequest request) throws Exception {
			
		String portalbasicurl = PortalContext.getConfiguration().getGatewayURL(request);
		String gatewayName = PortalContext.getConfiguration().getGatewayName(request);
		
		ArrayList<String> adminEmails = LoginServiceUtil.getAdministratorsEmails(scope);

		LiferayUserManager um = new LiferayUserManager();
		GCubeUser currUser = um.getUserByUsername(username);
		String name = currUser.getFirstName();
		String lastname = currUser.getLastName();
	

		StringBuffer body = new StringBuffer();
		body.append("<p>Dear manager of "+ scope +",<br />this email message was automatically generated by " + portalbasicurl +" to inform you that ");
		body.append("</p>")
		.append("<p>")
		.append("<b>"+name + " " + lastname +"</b> has accepted an invitation to the following environment: ")
		.append("<br /><br />")
		.append("<b>" + scope+"</b>")
		.append("<br />")
		.append("<br />")
		.append("<b>Username: </b>" + username)
		.append("<br />")
		.append("<b>e-mail: </b>" + currUser.getEmail())
		.append("</p>")
		.append("<p>")
		.append("<b>The invitation was sent by " + invite.getSenderFullName() +" (" + invite.getSenderUserId()+") on " + invite.getTime()+"</b>")
		.append("</p>");
	
		
		String[] allMails = new String[adminEmails.size()];

		adminEmails.toArray(allMails);

		EmailNotification mailToAdmin = new EmailNotification(allMails , "[" + gatewayName + "] - Accepted Invitation", body.toString(), request);

		mailToAdmin.sendEmail();
	}
	
}
