/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.client.responsive;

import com.github.gwtbootstrap.client.ui.PageHeader;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.Thumbnails;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.client.responsive.ResponsivePanel;
import org.gcube.portlets.user.joinvre.client.ui.AccessVREDialog;
import org.gcube.portlets.user.joinvre.client.ui.AccessViaInviteDialog;
import org.gcube.portlets.user.joinvre.client.ui.RequestMembershipDialog;
import org.gcube.portlets.user.joinvre.client.ui.VreThumbnail;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;

public class ResponsivePanel
extends Composite {
    private final JoinServiceAsync joinService = (JoinServiceAsync)GWT.create(JoinService.class);
    public static final String loading = GWT.getModuleBaseURL() + "../images/vre-loader.gif";
    private Row mainPanel = new Row();
    private ArrayList<VreThumbnail> myThumbnails = new ArrayList();

    public ResponsivePanel() {
        GWT.log((String)"ResponsivePanel()");
        this.joinService.getVREs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)this.mainPanel);
    }

    public ResponsivePanel(Tab selectedTab) {
        String tabName = selectedTab.getHeading();
        this.joinService.getPortalSitesMappedToVRE(tabName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)this.mainPanel);
    }

    public ResponsivePanel(VRECategory category) {
        GWT.log((String)"ResponsivePanel()");
        this.joinService.getVREsByCategory(category.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)this.mainPanel);
    }

    public ResponsivePanel(String organisation) {
        this.joinService.getVREsByOrganisation(organisation, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)this.mainPanel);
    }

    private void populatePanel(LinkedHashMap<VRECategory, ArrayList<VRE>> categories) {
        this.mainPanel.clear();
        if (categories == null || categories.isEmpty()) {
            this.showError("Ops, something went wrong");
        } else {
            for (VRECategory cat : categories.keySet()) {
                GWT.log((String)("cat: " + cat.getName()));
                PageHeader header = new PageHeader();
                header.setText(cat.getName());
                if (cat.getDescription() == null || cat.getDescription().compareTo("") == 0 || cat.getDescription().compareTo("empty") == 0) {
                    header.setSubtext("");
                } else {
                    header.setSubtext(cat.getDescription());
                }
                if (categories.get(cat).size() <= 0) continue;
                this.mainPanel.add((Widget)header);
                this.mainPanel.add((Widget)this.getVREThumbnails(categories, cat));
            }
        }
    }

    private Thumbnails getVREThumbnails(LinkedHashMap<VRECategory, ArrayList<VRE>> categories, VRECategory category) {
        ArrayList<VRE> vres = categories.get(category);
        Thumbnails toReturn = new Thumbnails();
        for (VRE vre : vres) {
            VreThumbnail thumb = new VreThumbnail(vre);
            this.myThumbnails.add(thumb);
            toReturn.add((Widget)thumb);
        }
        return toReturn;
    }

    protected void showError(String message) {
        this.mainPanel.clear();
        this.mainPanel.add((Widget)new HTML("<div class=\"frame\" style=\"font-size: 16px;\">" + message + ". Please <a href=\"javascript: location.reload();\">reload</a> this page.</div>"));
    }

    public void requestMembership(VRE vre) {
        switch (5.$SwitchMap$org$gcube$portlets$user$joinvre$shared$VreMembershipType[vre.getMembershipType().ordinal()]) {
            case 1: {
                RequestMembershipDialog modal = new RequestMembershipDialog(this, vre);
                modal.show();
                break;
            }
            case 2: {
                AccessVREDialog accessModal = new AccessVREDialog(vre);
                accessModal.show();
                break;
            }
        }
    }

    public void showInviteDialog(VRE vre, String inviteId) {
        AccessViaInviteDialog modal = new AccessViaInviteDialog(vre, inviteId);
        modal.show();
    }

    public void setPending(VRE toSet) {
        for (VreThumbnail thumb : this.myThumbnails) {
            if (thumb.getMyVre().getinfraScope().compareTo(toSet.getinfraScope()) != 0) continue;
            thumb.setPending();
        }
    }

    static /* synthetic */ void access$000(ResponsivePanel x0, LinkedHashMap x1) {
        x0.populatePanel(x1);
    }
}

