/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinnew.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.CustomAttributeKeys;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portlets.user.joinnew.client.JoinNewService;
import org.gcube.portlets.user.joinnew.server.LoginServiceUtil;
import org.gcube.portlets.user.joinnew.shared.UserBelonging;
import org.gcube.portlets.user.joinnew.shared.VO;
import org.gcube.portlets.user.joinnew.shared.VRE;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JoinNewServiceImpl
extends RemoteServiceServlet
implements JoinNewService {
    public static final String CACHED_VOS = "CACHED_VOS";
    private static DatabookStore store;
    public String SELECTED_THEMEID = "";
    private VO rootVO = new VO();
    private static Logger _log;

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user");
            user = "test.user";
        } else {
            _log.info("LIFERAY PORTAL DETECTED user=" + user);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public boolean registerUser(String scope, long groupId) {
        LiferayUserManager userM = new LiferayUserManager();
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            userM.assignUserToGroup(groupId, userM.getUserId(username));
            this.addUserToHLGroup(username, scope, session.getUsername());
            String gatewayName = PortalContext.getConfiguration().getGatewayName();
            if (this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME") != null) {
                gatewayName = this.getThreadLocalRequest().getSession().getAttribute("GATEWAY_NAME").toString();
                _log.debug("Gateway Label was Found=" + gatewayName);
            } else {
                _log.debug("Gateway Label Not Found");
            }
            JoinNewServiceImpl.initStore();
            String inviteId = store.isExistingInvite(scope, session.getUserEmailAddress());
            if (inviteId != null) {
                Invite invite = store.readInvite(inviteId);
                store.setInviteStatus(scope, session.getUserEmailAddress(), InviteStatus.ACCEPTED);
                LoginServiceUtil.notifyUserAcceptedInvite((String)username, (VO)this.rootVO, (String)scope, (String)this.getPortalBasicUrl(), (String)gatewayName, (Invite)invite);
            } else {
                LoginServiceUtil.notifyUserSelfRegistration((String)username, (VO)this.rootVO, (String)scope, (String)this.getPortalBasicUrl(), (String)gatewayName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<VO> getInfrastructureVOs() {
        _log.trace("getInfrastructureVOs method called");
        if (!this.isWithinPortal()) {
            return LoginServiceUtil.getFakeVOs();
        }
        try {
            User currUser = SiteManagerUtil.validateUser((String)this.getASLSession().getUsername());
            LiferayGroupManager gm = new LiferayGroupManager();
            GCubeGroup rootGroupVO = gm.getRootVO();
            try {
                _log.info("root: " + rootGroupVO.getGroupName());
            }
            catch (NullPointerException e) {
                _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
                return new ArrayList<VO>();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootGroupVO.getGroupName());
            this.rootVO.setGroupName(gm.getInfrastructureScope(rootGroupVO.getGroupId()));
            this.rootVO.setRoot(true);
            String friendlyURL = rootGroupVO.getFriendlyURL();
            this.rootVO.setFriendlyURL("/group" + friendlyURL);
            long logoId = rootGroupVO.getLogoId();
            String logoURL = "/image/layout_set_logo?img_id=" + rootGroupVO.getLogoId();
            this.rootVO.setImageURL(logoURL);
            LiferayUserManager um = new LiferayUserManager();
            if (rootGroupVO.getDescription() != null) {
                this.rootVO.setDescription(rootGroupVO.getDescription());
            }
            this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            List users = um.listUsersByGroup(rootGroupVO.getGroupId());
            for (GCubeUser gCubeUser : users) {
                if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) != 0) continue;
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
                break;
            }
            _log.debug("rootVO = " + rootGroupVO.getGroupName() + " children? = " + rootGroupVO.getChildren().size());
            for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
                _log.debug("FOUND VO: " + vOrg.getGroupName());
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getGroupName());
                voToAdd.setGroupName(gm.getInfrastructureScope(vOrg.getGroupId()));
                voToAdd.setRoot(false);
                logoURL = "/image/layout_set_logo?img_id=" + vOrg.getLogoId();
                voToAdd.setImageURL(logoURL);
                for (VRE vre : vOrg.getChildren()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setName(vre.getGroupName());
                    vreToAdd.setGroupName(gm.getInfrastructureScope(vre.getGroupId()));
                    logoId = vre.getLogoId();
                    logoURL = "/image/layout_set_logo?img_id=" + logoId;
                    _log.debug("VRE logoURL=" + logoURL);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getFriendlyURL();
                    vreToAdd.setFriendlyURL("/group" + vreUrl);
                    if (vre.getDescription() != null) {
                        vreToAdd.setDescription(vre.getDescription());
                    }
                    vreToAdd.setUponRequest(true);
                    if (gm.listGroupsByUser(currUser.getUserId()).contains(vre)) {
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vre.getGroupId())) {
                        vreToAdd.setUserBelonging(UserBelonging.PENDING);
                    } else {
                        vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                        boolean requireAccessGrant = vre.isRequestBasedGroup();
                        vreToAdd.setUponRequest(requireAccessGrant);
                    }
                    if (currUser.getOrganizations().contains(vre)) continue;
                    voToAdd.addVRE(vreToAdd);
                }
                String url = vOrg.getFriendlyURL();
                voToAdd.setFriendlyURL("/group" + url);
                if (vOrg.getDescription() != null) {
                    voToAdd.setDescription(vOrg.getDescription());
                }
                voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                users = um.listUsersByGroup(vOrg.getGroupId());
                for (GCubeUser gCubeUser : users) {
                    if (currUser.getScreenName().compareTo(gCubeUser.getUsername()) != 0) continue;
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                    break;
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                    _log.debug("VRE FOUND.... " + vre.getName());
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            _log.debug("SETTING INFRASTRUCTURE VOS in ASLSession");
            this.getASLSession().setAttribute("CACHED_VOS", toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VO>();
        }
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        try {
            LoginServiceUtil.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl(), (String)PortalContext.getConfiguration().getGatewayName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        return toReturn;
    }

    public boolean isExternal(Group group) throws GroupRetrievalFault {
        LiferayGroupManager gm = new LiferayGroupManager();
        return (Boolean)gm.readCustomAttr(20620L, CustomAttributeKeys.IS_EXTERNAL.getKeyName());
    }

    public VO getRootVO() {
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.rootVO;
        }
        LiferayGroupManager gm = new LiferayGroupManager();
        GCubeGroup root = null;
        try {
            root = gm.getRootVO();
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            e.printStackTrace();
        }
        this.rootVO.setName(root.getGroupName());
        this.rootVO.setGroupName("/" + root.getGroupName());
        this.rootVO.setRoot(true);
        String friendlyURL = root.getFriendlyURL();
        this.rootVO.setFriendlyURL("/group" + friendlyURL);
        String logoURL = "/image/layout_set_logo?img_id=" + root.getLogoId();
        this.rootVO.setImageURL(logoURL);
        return this.rootVO;
    }

    public VRE getSelectedVRE(long groupId) {
        _log.info("*getting Selected Research Environment from referral, org id = " + groupId);
        ASLSession session = this.getASLSession();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            GCubeGroup vre = null;
            try {
                vre = gm.getGroup(groupId);
            }
            catch (GroupRetrievalFault | UserManagementSystemException e) {
                e.printStackTrace();
            }
            VRE vreToAdd = new VRE();
            vreToAdd.setName(vre.getGroupName());
            vreToAdd.setGroupName(gm.getInfrastructureScope(vre.getGroupId()));
            String logoURL = "/image/layout_set_logo?img_id=" + vre.getLogoId();
            _log.debug("VRE logoURL=" + logoURL);
            vreToAdd.setImageURL(logoURL);
            String vreUrl = vre.getFriendlyURL();
            vreToAdd.setFriendlyURL("/group" + vreUrl);
            if (vre.getDescription() != null) {
                vreToAdd.setDescription(vre.getDescription());
            }
            vreToAdd.setUponRequest(true);
            LiferayUserManager um = new LiferayUserManager();
            GCubeUser user = um.getUserByUsername(session.getUsername());
            if (gm.listGroupsByUser(user.getUserId()).contains(vre)) {
                vreToAdd.setUserBelonging(UserBelonging.BELONGING);
            } else if (LoginServiceUtil.checkPending((String)session.getUsername(), (long)vre.getGroupId())) {
                vreToAdd.setUserBelonging(UserBelonging.PENDING);
            } else {
                vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                boolean requireAccessGrant = vre.isRequestBasedGroup();
                vreToAdd.setUponRequest(requireAccessGrant);
            }
        }
        catch (Exception e) {
            _log.error("Something wrong happened while trying to getOrganization, probably the organization id is wrong. " + e.getMessage());
        }
        return null;
    }

    public String isExistingInvite(long organizationid) {
        VRE vre = this.getSelectedVRE(organizationid);
        String email = this.getASLSession().getUserEmailAddress();
        _log.debug("checking if invite exists for " + email + " on " + vre.getGroupName());
        JoinNewServiceImpl.initStore();
        return store.isExistingInvite(vre.getGroupName(), email);
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
            return true;
        }
        return false;
    }

    public Boolean isUserRegistered() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        _log.trace("Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace("User login logged to: " + scope);
    }

    private void addUserToHLGroup(String username, String group, String adminUsername) {
        try {
            UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
            um.associateUserToGroup(group, username, adminUsername);
        }
        catch (Exception e) {
            _log.error("Failed to get the usermanager from HL. Could not add user to the HL group");
        }
    }

    private void setVREBelonginApplication(VRE vre) {
        _log.info("AvailablePortlets stored in session");
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }

    public static synchronized DatabookStore initStore() {
        if (store == null) {
            store = new DBCassandraAstyanaxImpl();
        }
        return store;
    }

    static {
        _log = LoggerFactory.getLogger(JoinNewServiceImpl.class);
    }
}

