/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.lastupdatedfiles.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.lastupdatedfiles.client.FileService;
import org.gcube.portlets.user.lastupdatedfiles.shared.FileItemsWrapper;
import org.gcube.portlets.user.lastupdatedfiles.shared.ImageType;
import org.gcube.portlets.user.lastupdatedfiles.shared.LufFileItem;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceImpl
extends RemoteServiceServlet
implements FileService {
    private static Logger _log = LoggerFactory.getLogger(FileServiceImpl.class);
    private static final int ITEMS_NO_TO_RETRIEVE = 6;
    public static final String TEST_USER = "test.user";
    public static final String RECENT_FILES_CACHE_NAME = "LUF_CACHE";
    public static final String LAST_RETRIEVED_TIME = "LAST_RETRIEVED_TIME";

    public void setRead(String workspaceItemId) {
        PortalContext pContext = PortalContext.getConfiguration();
        String username = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        ScopeProvider.instance.set(currScope);
        Workspace ws = null;
        try {
            ws = HomeLibrary.getUserWorkspace((String)username);
            ws.getItem(workspaceItemId).markAsRead(true);
            _log.debug(username + ": item read marked as true with id: " + workspaceItemId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getWorkspaceFolderURL() {
        String siteLandingPagePath;
        PortalContext pContext = PortalContext.getConfiguration();
        String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        String username = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        Workspace ws = null;
        String toReturn = siteLandingPagePath = pContext.getSiteLandingPagePath(this.getThreadLocalRequest());
        ScopeProvider.instance.set(currScope);
        try {
            ws = HomeLibrary.getUserWorkspace((String)username);
            WorkspaceSharedFolder sharedFolder = ws.getVREFolderByScope(currScope);
            toReturn = new String(new StringBuffer(siteLandingPagePath).append("/workspace").append("?itemid=").append(sharedFolder.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public FileItemsWrapper getLastUpdateFiles() {
        FileItemsWrapper toReturn = null;
        PortalContext pContext = PortalContext.getConfiguration();
        String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        String username = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        ScopeProvider.instance.set(currScope);
        toReturn = this.getFilesFromCache();
        if (toReturn != null) {
            return toReturn;
        }
        ArrayList<LufFileItem> fileItems = new ArrayList<LufFileItem>();
        Workspace ws = null;
        try {
            ws = HomeLibrary.getUserWorkspace((String)username);
            _log.info("Trying to get Group folder for scope=" + currScope);
            boolean isInfra = this.isInfrastructureScope();
            String folderName = "";
            String folderId = "";
            List items = null;
            if (this.isInfrastructureScope()) {
                WorkspaceFolder folder = (WorkspaceFolder)ws.getItemByPath("/Workspace/MySpecialFolders/");
                folderId = folder.getId();
                items = folder.getLastItems(6);
            } else {
                WorkspaceSharedFolder sharedFolder = ws.getVREFolderByScope(currScope);
                folderName = sharedFolder.getDisplayName();
                folderId = sharedFolder.getId();
                items = sharedFolder.getLastItems(6);
            }
            for (WorkspaceItem item : items) {
                String[] splits = item.getName().split("\\.");
                String extension = "";
                if (splits.length > 0) {
                    extension = splits[splits.length - 1];
                }
                fileItems.add(new LufFileItem(item.getId(), item.getName(), item.getOwner().getPortalLogin(), "", item.getLastModificationTime().getTime(), this.getIconImageType(extension), item.getPublicLink(false)));
            }
            String siteLandingPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
            toReturn = new FileItemsWrapper(folderName, folderId, fileItems, isInfra, siteLandingPagePath);
            this.storeFilesInCache(toReturn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private FileItemsWrapper getFilesFromCache() {
        String currentScope;
        HttpSession session = this.getThreadLocalRequest().getSession();
        Long now = new Date().getTime();
        Long previous = (Long)session.getAttribute(LAST_RETRIEVED_TIME);
        if (previous == null) {
            return null;
        }
        if (now > previous + 120000L) {
            _log.debug("more than 120 secs have passed");
            return null;
        }
        _log.debug("less than 120 secs, getting from cache");
        if (session.getAttribute(RECENT_FILES_CACHE_NAME) == null) {
            HashMap toStore = new HashMap();
            session.setAttribute(RECENT_FILES_CACHE_NAME, toStore);
            return null;
        }
        HashMap map = (HashMap)session.getAttribute(RECENT_FILES_CACHE_NAME);
        if (map.containsKey(currentScope = PortalContext.getConfiguration().getCurrentScope(this.getThreadLocalRequest()))) {
            return (FileItemsWrapper)map.get(currentScope);
        }
        return null;
    }

    private void storeFilesInCache(FileItemsWrapper wrapper) {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String currentScope = PortalContext.getConfiguration().getCurrentScope(this.getThreadLocalRequest());
        if (session.getAttribute(RECENT_FILES_CACHE_NAME) == null) {
            HashMap toStore = new HashMap();
            session.setAttribute(RECENT_FILES_CACHE_NAME, toStore);
        }
        HashMap map = (HashMap)session.getAttribute(RECENT_FILES_CACHE_NAME);
        map.put(currentScope, wrapper);
        session.setAttribute(RECENT_FILES_CACHE_NAME, (Object)map);
        session.setAttribute(LAST_RETRIEVED_TIME, (Object)new Date().getTime());
    }

    private ImageType getIconImageType(String extension) {
        if (extension == null || extension.compareTo("") == 0) {
            return ImageType.NONE;
        }
        switch (extension) {
            case "doc": 
            case "docx": 
            case "rtf": {
                return ImageType.DOC;
            }
            case "xls": 
            case "xlsx": {
                return ImageType.XLS;
            }
            case "ppt": 
            case "pptx": {
                return ImageType.PPT;
            }
            case "pdf": {
                return ImageType.PDF;
            }
            case "jpg": 
            case "jpeg": 
            case "gif": 
            case "bmp": 
            case "png": 
            case "tif": 
            case "tiff": {
                return ImageType.IMAGE;
            }
            case "avi": 
            case "mp4": 
            case "mpeg": {
                return ImageType.MOVIE;
            }
            case "html": 
            case "htm": 
            case "jsp": {
                return ImageType.HTML;
            }
            case "rar": {
                return ImageType.RAR;
            }
            case "zip": 
            case "tar": 
            case "tar.gz": {
                return ImageType.ZIP;
            }
        }
        return ImageType.NONE;
    }

    private boolean isInfrastructureScope() {
        long currGroupId = PortalContext.getConfiguration().getCurrentGroupId(this.getThreadLocalRequest());
        try {
            return new LiferayGroupManager().isRootVO(currGroupId);
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            e.printStackTrace();
            return false;
        }
    }
}

