package org.gcube.portlets.user.messages.client.interfaces;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.MessageModel;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
//Implements this interface to receive events by messages panel
public interface SubscriberInterface {
	void rootLoaded(FileModel root);
	void loadSentMessages();
	void loadReceivedMessages(); //upload received messages
	void deleteMessage(String id);
	void markAsReadMessage(String id, boolean isRead);
	void updatePrevieMessage(MessageModel message);
	void createNewMessage(HashMap<String, String> hashAttachs);
	void forwardMessage(String fromLogin, String subject, List<String> listContactsLogin, Date date, HashMap<String, String> hashAttachs, String textMessage);
	void replyMessage(String fromLogin, String subject, List<String>listContactsLogin, Date date, String textMessage);
}
