/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.my_vres.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlet.user.my_vres.client.MyVREsService;
import org.gcube.portlet.user.my_vres.shared.UserBelonging;
import org.gcube.portlet.user.my_vres.shared.VO;
import org.gcube.portlet.user.my_vres.shared.VRE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MyVREsServiceImpl
extends RemoteServiceServlet
implements MyVREsService {
    private static final Logger _log = LoggerFactory.getLogger(MyVREsServiceImpl.class);
    public static final String CACHED_VOS = "CACHED_VRES";
    public static final String ROOT_ORG = "rootorganization";
    private VO rootVO = new VO();

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user");
            user = "test.user";
        } else {
            _log.info("LIFERAY PORTAL DETECTED user=" + user);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ArrayList<VO> getInfrastructureVOs() {
        this.getASLSession();
        if (!this.isWithinPortal()) {
            return MyVREsServiceImpl.getFakeVOs();
        }
        try {
            String username = this.getASLSession().getUsername();
            User currUser = OrganizationsUtil.validateUser((String)username);
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(MyVREsServiceImpl.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootOrganization.getName());
            this.rootVO.setGroupName("/" + rootOrganization.getName());
            this.rootVO.setRoot(true);
            Group orgGroup = rootOrganization.getGroup();
            String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
            this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
            long logoId = rootOrganization.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            this.rootVO.setImageURL(logoURL);
            if (rootOrganization.getComments() != null) {
                this.rootVO.setDescription(rootOrganization.getComments());
            }
            for (Organization vOrg : rootOrganization.getSuborganizations()) {
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getName());
                voToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName());
                voToAdd.setRoot(false);
                for (VRE vre : vOrg.getSuborganizations()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setName(vre.getName());
                    vreToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName() + "/" + vre.getName());
                    logoId = vre.getLogoId();
                    logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
                    vreToAdd.setFriendlyURL(this.getPortalBasicUrl() + vreUrl);
                    if (vre.getComments() != null) {
                        vreToAdd.setDescription(vre.getComments());
                    }
                    if (!currUser.getOrganizations().contains(vre)) continue;
                    vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    voToAdd.addVRE(vreToAdd);
                }
                Group group = vOrg.getGroup();
                String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
                voToAdd.setFriendlyURL(this.getPortalBasicUrl() + url);
                if (vOrg.getComments() != null) {
                    voToAdd.setDescription(vOrg.getComments());
                }
                if (currUser.getOrganizations().contains(vOrg)) {
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                } else {
                    voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            this.getASLSession().setAttribute("CACHED_VRES", toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadLayout(String scope, String URL) {
        _log.trace("Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = this.getASLSession();
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace("User login logged to: " + scope);
    }

    protected static String getRootOrganizationName() {
        Properties props = new Properties();
        String toReturn = "gcube";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("rootorganization");
        }
        catch (IOException e) {
            toReturn = "gcube";
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default VO Name " + toReturn);
            return toReturn;
        }
        _log.debug("Returning Root VO Name: " + toReturn);
        return toReturn;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        return toReturn;
    }

    protected static ArrayList<VO> getFakeVOs() {
        VO rootVO = new VO();
        rootVO.setRoot(true);
        rootVO.setName("/d4science.research-infrastructures.eu/");
        rootVO.setDescription("This is the description for the ROOT VO");
        rootVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        rootVO.setUserBelonging(UserBelonging.BELONGING);
        VO emVO = new VO();
        emVO.setRoot(false);
        emVO.setGroupName("/d4science.research-infrastructures.eu/EM/");
        emVO.setName("EM VO");
        emVO.setDescription("EM and AEM Virtual Organisation The FARM Virtual Organisation is the dynamic group of individuals and/or institutions defined around a set of sharing rules in which resource providers and consumers specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the Fisheries and Aquaculture Resources Management.");
        emVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        emVO.setUserBelonging(UserBelonging.BELONGING);
        VRE cool_EM_VRE = new VRE();
        cool_EM_VRE.setName("BiodiversityResearchEnvironment");
        cool_EM_VRE.setGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE");
        cool_EM_VRE.setDescription("cool_EM_VRE VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/gcm-preview.jpg");
        cool_EM_VRE.setUserBelonging(UserBelonging.BELONGING);
        emVO.addVRE(cool_EM_VRE);
        VRE cool_EM_VRE2 = new VRE();
        cool_EM_VRE2.setName("COOL VRE 2");
        cool_EM_VRE2.setGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE2");
        cool_EM_VRE2.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE2.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
        cool_EM_VRE2.setUserBelonging(UserBelonging.NOT_BELONGING);
        VRE cool_EM_VRE3 = new VRE();
        cool_EM_VRE3.setName("COOL EM VRE TRE");
        cool_EM_VRE3.setGroupName("/d4science.research-infrastructures.eu/EM/COOlVRE3");
        cool_EM_VRE3.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        cool_EM_VRE3.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
        cool_EM_VRE3.setUserBelonging(UserBelonging.BELONGING);
        VRE demo = new VRE();
        demo.setName("Demo");
        demo.setGroupName("/d4science.research-infrastructures.eu/EM/Demo");
        demo.setDescription("Cool VRE Description<br />This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
        demo.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
        demo.setUserBelonging(UserBelonging.BELONGING);
        VRE vreGCM = new VRE();
        vreGCM.setName("GCM");
        vreGCM.setGroupName("/d4science.research-infrastructures.eu/EM/GCM");
        vreGCM.setDescription("Global Ocean Chlorophyll Monitoring (GCM) Virtual Research Environment<br />The phytoplankton plays a similar role to terrestrial green plants in the photosynthetic process and are credited with removing as much carbon dioxide from the atmosphere as their earthbound counterparts, making it important to monitor and model plankton into calculations of future climate change.");
        vreGCM.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
        vreGCM.setUserBelonging(UserBelonging.BELONGING);
        emVO.addVRE(cool_EM_VRE);
        emVO.addVRE(cool_EM_VRE2);
        emVO.addVRE(cool_EM_VRE3);
        emVO.addVRE(demo);
        emVO.addVRE(vreGCM);
        emVO.setUserBelonging(UserBelonging.BELONGING);
        ArrayList<VO> toReturn = new ArrayList<VO>();
        toReturn.add(rootVO);
        toReturn.add(emVO);
        toReturn.add(emVO);
        return toReturn;
    }
}

