package org.gcube.portlets.user.newsfeed.client.templates;

import org.gcube.portal.databook.client.GCubeSocialNetworking;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class LikedTemplate extends Composite {

	private static LikedTemplateUiBinder uiBinder = GWT
			.create(LikedTemplateUiBinder.class);

	interface LikedTemplateUiBinder extends UiBinder<Widget, LikedTemplate> {
	}

	public LikedTemplate(Like like) {
		initWidget(uiBinder.createAndBindUi(this));
		if (like.getThumbnailURL() != null)
			avatarImage.setUrl(like.getThumbnailURL());
		
		avatarImage.setPixelSize(30, 30);
		contentArea.setHTML("<a class=\"person-link\" style=\"font-size:16px;\"  href=\""+GCubeSocialNetworking.USER_PROFILE_LINK+"\">"+like.getFullName()+"</a> ");
	}
	@UiField
	Image avatarImage;
	@UiField
	HTML contentArea;
}
