package org.gcube.portlets.user.newsfeed.client;

import java.util.ArrayList;

import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.shared.EnhancedFeed;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("newsServlet")
public interface NewsService extends RemoteService {
	ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int feedsNoPerCategory);
	
	ArrayList<EnhancedFeed> getOnlyConnectionsUserFeeds();
	
	ArrayList<EnhancedFeed> getOnlyMyUserFeeds();
	
	ArrayList<EnhancedFeed> getOnlyLikedFeeds();
	
	boolean like(String feedid, String feedText, String feedOwnerId);
	
	boolean deleteComment(String commentid, String feedid);
	
	boolean deleteFeed(String feedid);
	
	Comment comment(String feedid, String text, String feedOwnerId, boolean isAppFeed);
	
	Comment editComment(Comment toEdit);
	
	ArrayList<Like> getAllLikesByFeed(String feedid);
	
	ArrayList<Comment> getAllCommentsByFeed(String feedid);
	
	UserSettings getUserSettings();
	
	EnhancedFeed getSingleFeed(String feedKey);
}
