/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.server.CommentNotificationsThread;
import org.gcube.portlets.user.newsfeed.server.LikeNotificationsThread;
import org.gcube.portlets.user.newsfeed.shared.EnhancedFeed;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsServiceImpl
extends RemoteServiceServlet
implements NewsService {
    private static final Logger _log = LoggerFactory.getLogger(NewsServiceImpl.class);
    private static final String ADMIN_ROLE = "Administrator";
    private static final String SESSION_ADMIN_ATTR = "SESSION_ADMIN_ATTR";
    private static final String USER_SETTINGS_ATTR = "USER_SETTINGS_ATTR";
    private DatabookStore store;
    private boolean withinPortal = false;
    private static final int MAX_FEEDS_NO = 30;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting testing user and Running OUTSIDE PORTAL");
            user = "test.user";
            user = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube");
        } else {
            this.withinPortal = true;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public UserSettings getUserSettings() {
        if (this.getUserSettingsFromSession() != null) {
            return this.getUserSettingsFromSession();
        }
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = username + "@isti.cnr.it";
            String fullName = username + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = user.getFirstName() + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, null);
                UserSettings toReturn = new UserSettings(userInfo, this.getFeedsRefreshTimeInMillis(), session.getScopeName(), this.isInfrastructureScope());
                this.setUserSettingsInSession(toReturn);
                return toReturn;
            }
            _log.info("Returning test USER");
            UserInfo user = new UserInfo(this.getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, null);
            return new UserSettings(user, this.getFeedsRefreshTimeInMillis(), session.getScopeName(), this.isInfrastructureScope());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    private boolean isInfrastructureScope() {
        ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
        return scope.is(ScopeBean.Type.INFRASTRUCTURE);
    }

    public ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int feedsNoPerCategory) {
        String userName = this.getASLSession().getUsername();
        ArrayList toMerge = new ArrayList();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        try {
            if (!this.withinPortal) {
                return this.getEclipseResult(userName, false);
            }
            if (userName.compareTo("test.user") == 0) {
                _log.debug("Found " + userName + " returning nothing");
                return null;
            }
            _log.info("****** retrieving feeds for user: " + userName);
            User currUser = OrganizationsUtil.validateUser((String)userName);
            if (this.isInfrastructureScope()) {
                Iterator<Object> i$ = currUser.getOrganizations().iterator();
                while (i$.hasNext()) {
                    LiferayGroupManager gm = new LiferayGroupManager();
                    Organization org = (Organization)i$.next();
                    if (!gm.isVRE(org.getOrganizationId() + "").booleanValue()) continue;
                    String vreid = gm.getScope("" + org.getOrganizationId());
                    _log.trace("Reading feeds for VRE: " + vreid);
                    ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory);
                    for (Feed feed : OrganizationFeeds) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
                for (Feed feed : portalFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            } else {
                String vreid = this.getASLSession().getScopeName();
                _log.trace("News Feed in VRE, Reading feeds for VRE: " + vreid);
                ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory * 3);
                for (Feed feed : OrganizationFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add(feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList toReturn = new ArrayList();
            if (toMerge.size() > 30) {
                for (int i = 0; i < 30; ++i) {
                    toReturn.add(toMerge.get(i));
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getOnlyConnectionsUserFeeds() {
        block11: {
            ArrayList toMerge = new ArrayList();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            String userName = this.getASLSession().getUsername();
            try {
                if (!this.withinPortal) {
                    return this.getEclipseResult(userName, true);
                }
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed feed : this.store.getRecentFeedsByUser(userid, 10)) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                for (String key : feedsMap.keySet()) {
                    toMerge.add(feedsMap.get(key));
                }
                Collections.sort(toMerge, Collections.reverseOrder());
                ArrayList toReturn = new ArrayList();
                if (toMerge.size() > 30) {
                    for (int i = 0; i < 30; ++i) {
                        toReturn.add(toMerge.get(i));
                    }
                    break block11;
                }
                return this.enhanceFeeds(toMerge, 2);
            }
            catch (PrivacyLevelTypeNotFoundException e) {
                _log.error("Privacy Level not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (FeedTypeNotFoundException e) {
                _log.error("Feed Type not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (ColumnNameNotFoundException e) {
                _log.error("Column name not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EnhancedFeed getSingleFeed(String feedKey) {
        Feed feed = null;
        try {
            if (feedKey != null && (feed = this.store.readFeed(feedKey)) != null) {
                ArrayList<Feed> toEnhance = new ArrayList<Feed>();
                toEnhance.add(feed);
                return (EnhancedFeed)this.enhanceFeeds(toEnhance, -1).get(0);
            }
        }
        catch (Exception e) {
            _log.debug("Error while trying to fetch feed with key " + feedKey + " returning nothing");
            return new EnhancedFeed();
        }
        return new EnhancedFeed();
    }

    private ArrayList<EnhancedFeed> getEclipseResult(String userName, boolean onlyConnections) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList toMerge = new ArrayList();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE("/gcube/devsec/devVRE", 10);
        for (Feed feed : OrganizationFeeds) {
            feedsMap.put(feed.getKey(), feed);
            _log.trace("Reading desc: " + feed.getDescription());
        }
        if (!onlyConnections) {
            ArrayList userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 10);
            for (Feed feed : userFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
            ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
            for (Feed feed : portalFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
        for (String userid : userFriendsIds) {
            for (Feed feed : this.store.getRecentFeedsByUser(userid, 10)) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add(feedsMap.get(key));
        }
        for (Feed feed : toMerge) {
            feed.setThumbnailURL("http://127.0.0.1:8888/images/Avatar_default.png");
        }
        Collections.sort(toMerge, Collections.reverseOrder());
        return this.enhanceFeeds(toMerge, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyMyUserFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace("getOnly UserFeeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 15);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyLikedFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace("getLiked Feeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getAllLikedFeedsByUser(userName, 25);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public boolean like(String feedid, String feedText, String feedOwnerId) {
        boolean likeCommitResult = false;
        UserInfo user = this.getUserSettings().getUserInfo();
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, user.getFullName(), user.getAvatarId());
        try {
            likeCommitResult = this.store.like(toLike);
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Feed not Found for this like " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (likeCommitResult && !user.getUsername().equals(feedOwnerId)) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.getASLSession());
            boolean nResult = nm.notifyLikedFeed(feedOwnerId, feedid, this.escapeHtml(feedText));
            _log.trace("Like Notification added? " + nResult);
        }
        return likeCommitResult;
    }

    public Comment comment(String feedid, String commentText, String feedOwnerId, boolean isAppFeed) {
        boolean commentCommitResult = false;
        _log.trace("Trying to add this comment " + commentText);
        UserInfo user = this.getUserSettings().getUserInfo();
        Comment comment = new Comment(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, this.transformUrls(this.escapeHtml(commentText)), user.getFullName(), user.getAvatarId());
        try {
            if (this.store.addComment(comment)) {
                commentCommitResult = true;
            }
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Feed not Found for this comment " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        if (commentCommitResult && this.withinPortal) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.getASLSession());
            if (!user.getUsername().equals(feedOwnerId) && !isAppFeed) {
                boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedid, this.escapeHtml(commentText));
                _log.trace("Comment Notification to post owner added? " + result);
            }
            Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.store, user.getUsername(), comment.getFeedid(), commentText, (NotificationsManager)nm, feedOwnerId));
            commentsNotificationthread.start();
            Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, this.getAllLikesByFeed(feedid)));
            likesThread.start();
        }
        return comment;
    }

    public Comment editComment(Comment toEdit) {
        UserInfo user = this.getUserSettings().getUserInfo();
        Comment edited = new Comment(toEdit.getKey(), toEdit.getUserid(), new Date(), toEdit.getFeedid(), this.transformUrls(this.escapeHtml(toEdit.getText())), user.getFullName(), user.getAvatarId());
        try {
            this.store.editComment(edited);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return edited;
    }

    private String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    private ArrayList<EnhancedFeed> enhanceFeeds(ArrayList<Feed> toEnhance, int commentsNumberPerFeed) {
        ArrayList<EnhancedFeed> toReturn = new ArrayList<EnhancedFeed>();
        String username = this.getASLSession().getUsername();
        ArrayList likedFeeds = (ArrayList)this.store.getAllLikedFeedIdsByUser(this.getASLSession().getUsername());
        boolean skip = false;
        for (Feed feed : toEnhance) {
            skip = false;
            feed.setDescription(this.replaceAmpersand(feed.getDescription()));
            if (!feed.isApplicationFeed()) {
                String thumb = this.getUserImagePortraitUrlLocal(feed.getEntityId());
                if (thumb == null) {
                    _log.warn(feed.getEntityId() + " is not avaialble on this portal, skipping this feed: " + feed.getKey());
                    skip = true;
                } else {
                    feed.setThumbnailURL(thumb);
                }
            }
            boolean liked = likedFeeds.contains(feed.getKey());
            int commentsNo = 0;
            try {
                commentsNo = Integer.parseInt(feed.getCommentsNo());
            }
            catch (NumberFormatException e) {
                commentsNo = 0;
                _log.error("NumberFormatException while reading comments number " + e.getMessage());
            }
            if (skip) continue;
            if (commentsNo == 0) {
                EnhancedFeed toAdd = null;
                toAdd = feed.isApplicationFeed() ? new EnhancedFeed(feed, liked, this.checkisAdminUser()) : new EnhancedFeed(feed, liked, this.isUsers(feed, username));
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments = this.getAllCommentsByFeed(feed.getKey());
            Collections.sort(comments);
            int currCommentsNumber = comments.size();
            if (currCommentsNumber < commentsNumberPerFeed || commentsNumberPerFeed == -1) {
                EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments2Attach = new ArrayList();
            for (int i = currCommentsNumber - commentsNumberPerFeed; i < currCommentsNumber; ++i) {
                comments2Attach.add(comments.get(i));
            }
            EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments2Attach);
            toReturn.add(toAdd);
        }
        _log.trace("ENHANCED FEEDS TOTAL= " + toReturn.size() + " for user: " + username);
        return toReturn;
    }

    private String getUserImagePortraitUrlLocal(String screenName) {
        if (!this.withinPortal) {
            return "";
        }
        StringBuilder thumbnailURL = new StringBuilder("/image/user_male_portrait?img_id=");
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)screenName);
        }
        catch (NoSuchUserException ex) {
            return null;
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return thumbnailURL.append(user.getPortraitId()).toString();
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        ArrayList toReturn = (ArrayList)this.store.getAllLikesByFeed(feedid);
        _log.trace("Asking likes for " + feedid);
        Iterator i$ = toReturn.iterator();
        while (i$.hasNext()) {
            Like like;
            String thumb = this.getUserImagePortraitUrlLocal((like = (Like)i$.next()).getUserid());
            like.setThumbnailURL(thumb == null ? "" : thumb);
        }
        return toReturn;
    }

    public ArrayList<Comment> getAllCommentsByFeed(String feedid) {
        _log.trace("Asking comments for " + feedid);
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(feedid);
        Iterator i$ = toReturn.iterator();
        while (i$.hasNext()) {
            Comment comment;
            String thumb = this.getUserImagePortraitUrlLocal((comment = (Comment)i$.next()).getUserid());
            comment.setThumbnailURL(thumb == null ? "" : thumb);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    public boolean deleteComment(String commentid, String feedid) {
        _log.trace("Attempting to delete comment " + commentid);
        try {
            return this.store.deleteComment(commentid, feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteFeed(String feedid) {
        _log.trace("Attempting to delete feed " + feedid);
        try {
            return this.store.deleteFeed(feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private UserSettings getUserSettingsFromSession() {
        try {
            return (UserSettings)this.getASLSession().getAttribute(USER_SETTINGS_ATTR);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void setUserSettingsInSession(UserSettings user) {
        this.getASLSession().setAttribute(USER_SETTINGS_ATTR, (Object)user);
    }

    private boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private boolean checkisAdminUser() {
        if (this.getASLSession().getAttribute(SESSION_ADMIN_ATTR) == null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.isAdmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getASLSession().setAttribute(SESSION_ADMIN_ATTR, (Object)isAdmin);
            return isAdmin;
        }
        return (Boolean)this.getASLSession().getAttribute(SESSION_ADMIN_ATTR);
    }

    private boolean isAdmin() throws PortalException, SystemException {
        try {
            User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(OrganizationsUtil.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            _log.trace("root: " + rootOrganization.getName());
            return this.hasRole(ADMIN_ROLE, rootOrganization.getName(), currUser);
        }
        catch (NullPointerException e) {
            _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
            return false;
        }
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename) != 0) continue;
            return true;
        }
        return false;
    }

    public String transformUrls(String textToCheck) {
        StringBuilder sb = new StringBuilder();
        String[] parts = textToCheck.split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("http")) {
                try {
                    URL url = new URL(parts[i]);
                    sb.append("<a class=\"link\" style=\"font-size:11px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                    continue;
                }
                catch (MalformedURLException e) {
                    _log.error("MalformedURLException returning... ");
                    return textToCheck;
                }
            }
            sb.append(parts[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    private int getFeedsRefreshTimeInMillis() {
        if (this.withinPortal) {
            _log.info("Trying to read custom REFRESH_TIME");
            Properties props = new Properties();
            int toReturn = 0;
            int minutes = 0;
            String propertyfile = "";
            try {
                ServletContext servletContext = this.getServletContext();
                String contextPath = servletContext.getRealPath(File.separator);
                propertyfile = contextPath + "conf" + File.separator + "settings.properties";
                File propsFile = new File(propertyfile);
                FileInputStream fis = new FileInputStream(propsFile);
                props.load(fis);
                minutes = Integer.parseInt(props.getProperty("REFRESH_TIME"));
                toReturn = minutes * 60 * 1000;
            }
            catch (IOException e) {
                toReturn = 300000;
                _log.error("settings.properties file not found under " + propertyfile + ", returning 5 minutes");
                return toReturn;
            }
            catch (ClassCastException ex) {
                toReturn = 300000;
                _log.error("REFRESH_TIME must be a number (in minutes) returning 5 minutes");
                return toReturn;
            }
            _log.debug("Returning REFRESH_TIME in millis: " + toReturn + ", (" + minutes + " minutes)");
            return toReturn;
        }
        return 60000;
    }
}

