package org.gcube.portlets.user.newsfeed.client.event;

import org.gcube.portal.databook.shared.Comment;
import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;

import com.google.gwt.event.shared.GwtEvent;



public class EditCommentEvent  extends GwtEvent<EditCommentEventHandler> {
	public static Type<EditCommentEventHandler> TYPE = new Type<EditCommentEventHandler>();
	
	private TweetTemplate owner;
	private Comment edited;
	
	public TweetTemplate getOwner() {
		return owner;
	}
	public Comment getCommentInstance() {
		return edited;
	}
	public EditCommentEvent(TweetTemplate owner, Comment editedComment) {
		this.owner = owner;
		this.edited = editedComment;
	}

	@Override
	public Type<EditCommentEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(EditCommentEventHandler handler) {
		handler.onEditComment(this);
	}
}
