/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.client.event.AddLikeEvent;
import org.gcube.portlets.user.newsfeed.client.event.DeletePostEvent;
import org.gcube.portlets.user.newsfeed.client.event.OpenPostEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeCommentsEvent;
import org.gcube.portlets.user.newsfeed.client.event.SeeLikesEvent;
import org.gcube.portlets.user.newsfeed.client.event.UnLikeEvent;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.ui.AddCommentTemplate;
import org.gcube.portlets.user.newsfeed.client.ui.AttachmentPreviewer;
import org.gcube.portlets.user.newsfeed.client.ui.AvatarReplacement;
import org.gcube.portlets.user.newsfeed.client.ui.LinkPreviewer;
import org.gcube.portlets.user.newsfeed.client.ui.Placeholder;
import org.gcube.portlets.user.newsfeed.client.ui.SingleComment;
import org.gcube.portlets.user.newsfeed.client.ui.TweetTemplate;
import org.gcube.portlets.widgets.imagepreviewerwidget.client.EnhancedImage;
import org.gcube.portlets.widgets.imagepreviewerwidget.client.ui.Carousel;

public class TweetTemplate
extends Composite {
    private static TweetTemplateUiBinder uiBinder = (TweetTemplateUiBinder)GWT.create(TweetTemplateUiBinder.class);
    public static final String loading = GWT.getModuleBaseURL() + "../images/loading-comments.gif";
    private static final int MAX_SHOWTEXT_LENGTH = 612;
    private EnhancedFeed myPost;
    private UserInfo myUserInfo;
    private HandlerManager eventBus;
    private ArrayList<SingleComment> myComments;
    private boolean commentingDisabled = false;
    private boolean commentsFetched = false;
    private int totalComments = 0;
    private HTML showAllComments = new HTML();
    private boolean isAppPost = false;
    private HTML submitCommentPreloader = new HTML("<div class=\"more-comment\"><img style=\"padding-right:15px;\"src=\"" + loading + "\" /></div>");
    private TweetTemplate myInstance;
    private Carousel carousel;
    private boolean isUsers = false;
    @UiField
    HTML contentArea;
    @UiField
    HTML postOwnerArea;
    @UiField
    HTML seeMore;
    @UiField
    InlineLabel timeArea;
    @UiField
    InlineLabel separator;
    @UiField
    InlineLabel vreSourceInMetadata;
    @UiField
    HTML likeArea;
    @UiField
    HTML commentArea;
    @UiField
    Image avatarImage;
    @UiField
    AvatarReplacement avatarReplacement;
    @UiField
    HTMLPanel mainHTML;
    @UiField
    Button likesNo;
    @UiField
    Button commentsNo;
    @UiField
    VerticalPanel commentsPanel;
    @UiField
    HTML closeImage;
    @UiField
    HTML openImage;
    @UiField
    VerticalPanel previewPanel;
    @UiField
    Placeholder attachmentPreviewPanel;
    @UiField
    Label messageSeparator;

    public TweetTemplate(boolean displaySingle, boolean showTimelineSource, UserInfo myUserInfo, EnhancedFeed myPost, HandlerManager eventBus) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.commentsNo.getElement().getStyle().setPaddingTop(0.0, Style.Unit.PX);
        this.likesNo.getElement().getStyle().setPaddingTop(0.0, Style.Unit.PX);
        this.likesNo.getElement().getStyle().setPaddingRight(2.0, Style.Unit.PX);
        this.commentsNo.getElement().getStyle().setPaddingRight(2.0, Style.Unit.PX);
        this.likesNo.getElement().getStyle().setPaddingLeft(2.0, Style.Unit.PX);
        this.commentsNo.getElement().getStyle().setPaddingLeft(2.0, Style.Unit.PX);
        this.myInstance = this;
        this.myUserInfo = myUserInfo;
        this.vreSourceInMetadata.setVisible(false);
        this.separator.setVisible(false);
        this.myPost = myPost;
        this.isAppPost = myPost.getFeed().isApplicationFeed();
        Feed post = myPost.getFeed();
        this.eventBus = eventBus;
        this.isUsers = myPost.isUsers();
        this.carousel = new Carousel();
        this.myComments = new ArrayList();
        if (this.isUsers || myUserInfo.isAdmin()) {
            this.closeImage.setStyleName("closeImage");
            this.closeImage.setTitle(myUserInfo.isAdmin() ? "Delete (Administrator Mode)" : "delete");
        } else {
            this.closeImage.removeFromParent();
        }
        if (post.getUri() != null && post.getUri().compareTo("") != 0 && post.getLinkTitle() != null && post.getLinkTitle().compareTo("") != 0 && !post.isMultiFileUpload()) {
            this.attachmentPreviewPanel.setVisible(false);
            LinkPreviewer linkPreviewer = new LinkPreviewer(post.getLinkTitle(), post.getLinkDescription(), post.getLinkHost(), post.getUriThumbnail(), post.getUri());
            if (post.getLinkHost().contains("image/")) {
                EnhancedImage enhancedImage = new EnhancedImage(post.getUri(), post.getLinkTitle() + " (" + post.getLinkDescription() + ", type:" + post.getLinkHost() + ")", post.getLinkTitle(), post.getUri());
                ArrayList<EnhancedImage> listOfEnhancedImages = new ArrayList<EnhancedImage>();
                listOfEnhancedImages.add(enhancedImage);
                this.carousel.updateImages(listOfEnhancedImages);
                linkPreviewer.onImageClickOpenCarousel(this.carousel);
                linkPreviewer.onFileNameClickOpenCarousel(this.carousel);
                this.carousel.hideArrows();
            }
            this.previewPanel.add((Widget)linkPreviewer);
        }
        if (post.isMultiFileUpload()) {
            this.attachmentPreviewPanel.setStyleName("attachment-preview-container");
            this.previewPanel.setVisible(false);
            ArrayList<EnhancedImage> listOfEnhancedImages = new ArrayList<EnhancedImage>();
            Attachment firstAttachment = new Attachment(post.getKey(), post.getUri(), post.getLinkTitle(), post.getLinkDescription(), post.getUriThumbnail(), post.getLinkHost());
            AttachmentPreviewer firstAttachmentPreviewer = new AttachmentPreviewer(firstAttachment);
            int imagesAvailableInCarousel = 0;
            if (firstAttachment.getMimeType().contains("image/")) {
                EnhancedImage enhancedImage = new EnhancedImage(post.getUri(), post.getLinkTitle() + " (" + post.getLinkDescription() + ", type:" + post.getLinkHost() + ")", post.getLinkTitle(), post.getUri());
                listOfEnhancedImages.add(enhancedImage);
                firstAttachmentPreviewer.onImageClickOpenCarousel(this.carousel, enhancedImage);
                ++imagesAvailableInCarousel;
            }
            this.attachmentPreviewPanel.add(firstAttachmentPreviewer);
            for (Attachment otherAttachment : myPost.getAttachments()) {
                AttachmentPreviewer attachmentPreviewer = new AttachmentPreviewer(otherAttachment);
                if (otherAttachment.getMimeType().contains("image/")) {
                    EnhancedImage enhancedImage = new EnhancedImage(otherAttachment.getUri(), otherAttachment.getName() + " (" + otherAttachment.getDescription() + ", type:" + post.getLinkHost() + ")", otherAttachment.getName(), otherAttachment.getUri());
                    listOfEnhancedImages.add(enhancedImage);
                    attachmentPreviewer.onImageClickOpenCarousel(this.carousel, enhancedImage);
                    ++imagesAvailableInCarousel;
                }
                this.attachmentPreviewPanel.add(attachmentPreviewer);
                if (imagesAvailableInCarousel > true) continue;
                this.carousel.hideArrows();
            }
            this.carousel.updateImages(listOfEnhancedImages);
            this.attachmentPreviewPanel.appendShowMoreLabel();
        }
        this.openImage.setStyleName("openImage");
        this.openImage.setTitle("Open this feed separately");
        this.setFavoritedUI(myPost.isLiked());
        this.commentArea.setHTML("<a>Reply</a>");
        String postText = post.getDescription();
        String descWithoutHTML = new HTML(postText).getText();
        if (!postText.startsWith("<span") && descWithoutHTML.length() > 612 && !displaySingle) {
            int TEXT_TO_SHOW_LENGHT = descWithoutHTML.length() < 600 ? postText.length() - postText.length() / 3 : 600;
            postText = postText.substring(0, TEXT_TO_SHOW_LENGHT) + "...";
            this.seeMore.setHTML("<a class=\"seemore\"> See More </a>");
        }
        this.avatarImage.setUrl(post.getThumbnailURL());
        this.avatarImage.setPixelSize(40, 40);
        postText = postText.replaceAll("&amp;", "&");
        String profilePageURL = "/group" + NewsFeedPanel.extractOrgFriendlyURL((String)Window.Location.getHref()) + "/profile";
        if (showTimelineSource && post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            this.vreSourceInMetadata.setVisible(true);
            this.separator.setVisible(true);
            String vreName = post.getVreid().substring(post.getVreid().lastIndexOf("/") + 1);
            this.vreSourceInMetadata.setText(vreName);
            this.vreSourceInMetadata.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!this.isAppPost) {
            this.postOwnerArea.setHTML("<a class=\"linkProfile\" href=\"" + profilePageURL + "?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)post.getEntityId()) + "\">" + post.getFullName() + "</a>");
            this.contentArea.setHTML(postText);
            if (post.getThumbnailURL().contains("img_id=0") || !post.getThumbnailURL().contains("?")) {
                this.avatarImage.setVisible(false);
                String f = "A";
                String s = "Z";
                if (post.getFullName() != null) {
                    String[] parts = post.getFullName().split("\\s");
                    if (parts.length > 0) {
                        f = parts[0].toUpperCase();
                        s = parts[parts.length - 1].toUpperCase();
                    } else {
                        f = post.getFullName().substring(0, 1);
                        s = post.getFullName().substring(1, 2);
                    }
                }
                this.avatarReplacement.setInitials(post.getEntityId(), f, s);
                this.avatarReplacement.setVisible(true);
            }
        } else {
            this.postOwnerArea.setHTML("<a class=\"linkProfile\" href=\"" + post.getUri() + "\">" + post.getFullName() + "</a>");
            this.contentArea.setHTML(postText);
            if (this.isAppPost) {
                if (myUserInfo.isAdmin()) {
                    this.closeImage.setTitle("Delete this Application feed (Administrator Only)");
                } else {
                    this.closeImage.removeFromParent();
                }
            }
        }
        try {
            Date now = new Date();
            String formattedTime = now.getYear() != post.getTime().getYear() ? DateTimeFormat.getFormat((String)"MMMM dd yyyy, h:mm a").format(post.getTime()) : DateTimeFormat.getFormat((String)"MMMM dd, h:mm a").format(post.getTime());
            this.timeArea.setText(formattedTime);
            String formattedTimeWithYear = DateTimeFormat.getFormat((String)"dd MMMM yyyy h:mm a ").format(post.getTime());
            this.timeArea.setTitle(formattedTimeWithYear);
            if (!post.getCommentsNo().equals("0")) {
                this.commentsNo.setVisible(true);
                this.commentsNo.setText(post.getCommentsNo());
                this.commentsNo.setTitle(post.getCommentsNo() + " people commented this.");
            }
            if (!post.getLikesNo().equals("0")) {
                this.likesNo.setVisible(true);
                this.likesNo.setText(post.getLikesNo());
                this.likesNo.setTitle("Show People who have Liked this.");
            }
            this.totalComments = Integer.parseInt(post.getCommentsNo());
        }
        catch (NumberFormatException e) {
            this.totalComments = 0;
        }
        catch (Exception e) {
            this.timeArea.setText("just now");
        }
        this.commentsPanel.setStyleName("commentsPanel");
        if (myPost.getComments() != null && myPost.getComments().size() > 0) {
            if (this.totalComments > 2 && !displaySingle) {
                this.showAllComments = this.getShowAllCommentsLink(this.totalComments);
                this.commentsPanel.add((Widget)this.showAllComments);
                this.commentsNo.setVisible(true);
            }
            for (Comment comment : myPost.getComments()) {
                this.addComment(new SingleComment(comment, this, comment.getUserid().equals(myUserInfo.getUsername())));
            }
            this.showAddCommentForm(false);
        }
    }

    public TweetTemplate(UserInfo myUserInfo, EnhancedFeed feed, HandlerManager eventBus, boolean hidden) {
        this(false, false, myUserInfo, feed, eventBus);
        this.contentArea.getElement().getParentElement().getParentElement().setClassName("div-table-col content hidden");
    }

    @UiHandler(value={"contentArea"})
    public void onHover(MouseOutEvent event) {
        if (this.isUsers) {
            this.closeImage.removeStyleName("uiCloseButton");
        }
        this.openImage.removeStyleName("uiOpenButton");
    }

    @UiHandler(value={"contentArea"})
    public void onHover(MouseOverEvent event) {
        if (this.isUsers) {
            this.closeImage.addStyleName("uiCloseButton");
            GWT.log((String)"this belong to user");
        }
        this.openImage.addStyleName("uiOpenButton");
    }

    @UiHandler(value={"closeImage"})
    void onDeleteFeedClick(ClickEvent e) {
        if (this.isUsers || this.myUserInfo.isAdmin()) {
            this.eventBus.fireEvent((GwtEvent)new DeletePostEvent(this));
        } else {
            GWT.log((String)"not belong to user");
        }
    }

    @UiHandler(value={"openImage"})
    void onOpenFeedClick(ClickEvent e) {
        this.eventBus.fireEvent((GwtEvent)new OpenPostEvent(this));
    }

    @UiHandler(value={"seeMore"})
    void onSeeMoreClick(ClickEvent e) {
        String postText = this.myPost.getFeed().getDescription();
        postText = postText.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        postText = postText.replaceAll("&amp;", "&");
        this.contentArea.setHTML(postText);
        this.seeMore.setHTML("");
    }

    private void setFavoritedUI(boolean favorited) {
        if (favorited) {
            this.likeArea.setHTML("<a style=\"color:#6E8CCC;\">Liked</a>");
            this.likeArea.setTitle("Unlike this");
        } else {
            this.likeArea.setHTML("<a>Like</a>");
        }
    }

    @UiHandler(value={"likeArea"})
    void onLikeClick(ClickEvent e) {
        if (!this.likeArea.getText().equals("Liked")) {
            try {
                int cur = Integer.parseInt(this.myPost.getFeed().getLikesNo());
                if (++cur == 1) {
                    this.myPost.getFeed().setLikesNo("1");
                    this.likesNo.setText("1");
                    this.likesNo.setTitle("People who have Liked this");
                    this.likesNo.setVisible(true);
                } else {
                    this.myPost.getFeed().setLikesNo("" + cur);
                    this.likesNo.setText("" + cur);
                    this.likesNo.setVisible(true);
                }
                this.eventBus.fireEvent((GwtEvent)new AddLikeEvent(this, this.myPost.getFeed().getKey()));
                this.setFavoritedUI(true);
            }
            catch (NumberFormatException ex) {
                this.likeArea.setHTML("Error on the server");
            }
        } else {
            int cur = Integer.parseInt(this.myPost.getFeed().getLikesNo());
            if (--cur == 0) {
                this.myPost.getFeed().setLikesNo("0");
                this.likesNo.setText("");
                this.likesNo.setVisible(false);
                this.likesNo.setTitle("");
            } else {
                this.myPost.getFeed().setLikesNo("" + cur);
                this.likesNo.setText("" + cur);
                this.likesNo.setVisible(true);
            }
            this.eventBus.fireEvent((GwtEvent)new UnLikeEvent(this, this.myPost.getFeed().getKey()));
            this.setFavoritedUI(false);
        }
    }

    @UiHandler(value={"commentArea"})
    void onAddCommentClick(ClickEvent e) {
        if (!this.commentingDisabled) {
            if (!this.commentsFetched && this.totalComments > 2) {
                this.fireSeeComments(true);
            } else {
                this.showAddCommentForm(true);
            }
        } else {
            GWT.log((String)"Commenting disabled");
        }
    }

    public void showAddCommentForm(boolean focus) {
        AddCommentTemplate toAdd = new AddCommentTemplate(this, this.myUserInfo, this.eventBus);
        this.commentsPanel.add((Widget)toAdd);
        this.commentingDisabled = true;
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        if (focus) {
            toAdd.setFocus();
        }
        t.schedule(10);
    }

    private HTML getShowAllCommentsLink(int commentsNo) {
        HTML toReturn = new HTML("<div class=\"more-comment\"><a class=\"link\" style=\"font-size:11px;\">Show all " + commentsNo + " comments<a/></div>");
        toReturn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return toReturn;
    }

    private void fireSeeComments(boolean commentForm2Add) {
        this.eventBus.fireEvent((GwtEvent)new SeeCommentsEvent(this, commentForm2Add));
    }

    @UiHandler(value={"likesNo"})
    void onSeeLikes(ClickEvent e) {
        this.eventBus.fireEvent((GwtEvent)new SeeLikesEvent(this.myPost.getFeed().getKey()));
    }

    @UiHandler(value={"commentsNo"})
    void onSeeComments(ClickEvent e) {
        this.fireSeeComments(false);
    }

    public void setcontentAreaStyle(String cssclass) {
        this.contentArea.getElement().getParentElement().getParentElement().setClassName("div-table-col content visible");
    }

    public boolean isCommenting() {
        return this.commentingDisabled;
    }

    public void setCommentingDisabled(boolean commenting) {
        this.commentingDisabled = commenting;
    }

    public String getFeedKey() {
        return this.myPost.getFeed().getKey();
    }

    public void remove(Widget w) {
        this.mainHTML.remove(w);
    }

    public void addComment(SingleComment comment) {
        this.commentsPanel.add((Widget)comment);
        this.myComments.add(comment);
    }

    public void showCommentingPreloader(boolean show) {
        if (show) {
            this.commentsPanel.add((Widget)this.submitCommentPreloader);
        } else {
            this.commentsPanel.remove((Widget)this.submitCommentPreloader);
        }
    }

    public void updateSingleComment(Comment edited, HTMLPanel commentPanel) {
        commentPanel.clear();
        SingleComment sc = new SingleComment(edited, this, true);
        commentPanel.add((Widget)sc);
        int index = 0;
        Iterator iterator = this.myComments.iterator();
        while (iterator.hasNext()) {
            SingleComment singleComment = (SingleComment)iterator.next();
            if (singleComment.getCommentKey().equals(edited.getKey())) {
                iterator.remove();
                this.myComments.add(index, sc);
                break;
            }
            ++index;
        }
    }

    public void clearComments() {
        this.myComments.clear();
        this.commentsPanel.clear();
    }

    public void showLoadingComments() {
        this.showAllComments.setHTML("<div class=\"more-comment\"><img style=\"padding-right:15px;\"src=\"" + loading + "\" /></div>");
    }

    public boolean isCommentsFetched() {
        return this.commentsFetched;
    }

    public void setCommentsFetched(boolean commentsFetched) {
        this.commentsFetched = commentsFetched;
    }

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public void updateCommentsNumberCount() {
        if (this.myComments.size() == 1) {
            this.commentsNo.setTitle("Persons who have commented this.");
        }
        this.commentsNo.setText("" + this.myComments.size());
    }

    public UserInfo getMyUserInfo() {
        return this.myUserInfo;
    }

    public String getMyFeedUserId() {
        return this.myPost.getFeed().getEntityId();
    }

    public String getMyFeedText() {
        return this.myPost.getFeed().getDescription();
    }

    public boolean isAppFeed() {
        return this.isAppPost;
    }

    public boolean isUser() {
        return this.isUsers;
    }

    public int numberOfComments() {
        return this.myComments.size();
    }

    public String getVREContext() {
        return this.myPost.getFeed().getVreid();
    }

    public int numberOfLikes() {
        int ret = 0;
        try {
            ret = Integer.parseInt(this.likesNo.getText());
        }
        catch (NumberFormatException e) {
            GWT.log((String)e.toString());
        }
        return ret;
    }

    static /* synthetic */ void access$000(TweetTemplate x0, boolean x1) {
        x0.fireSeeComments(x1);
    }
}

