/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portlets.user.newsfeed.client.event.DeleteCommentEvent;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.ui.AddCommentTemplate;
import org.gcube.portlets.user.newsfeed.client.ui.AvatarReplacement4Comments;
import org.gcube.portlets.user.newsfeed.client.ui.SingleComment;
import org.gcube.portlets.user.newsfeed.client.ui.TweetTemplate;

public class SingleComment
extends Composite {
    private static SingleCommentUiBinder uiBinder = (SingleCommentUiBinder)GWT.create(SingleCommentUiBinder.class);
    private static final int MAX_SHOWTEXT_LENGTH = 450;
    private boolean isUsers = false;
    private TweetTemplate owner;
    private String myCommentid;
    private Comment myComment;
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    AvatarReplacement4Comments avatarReplacement;
    @UiField
    HTML commentText;
    @UiField
    HTML timeArea;
    @UiField
    HTML closeImage;
    @UiField
    HTML editImage;
    @UiField
    HTML seeMore;

    public SingleComment(Comment toShow, TweetTemplate owner, boolean isUsers) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.sinkEvents(524288);
        this.owner = owner;
        this.isUsers = isUsers;
        this.myComment = toShow;
        this.myCommentid = toShow.getKey();
        this.avatarImage.setPixelSize(30, 30);
        this.avatarImage.setUrl(toShow.getThumbnailURL());
        if (toShow.getThumbnailURL().endsWith("img_id=0") || !toShow.getThumbnailURL().contains("?")) {
            this.avatarImage.setVisible(false);
            String f = "A";
            String s = "Z";
            if (toShow.getFullName() != null) {
                String[] parts = toShow.getFullName().split("\\s");
                if (parts.length > 0) {
                    f = parts[0].toUpperCase();
                    s = parts[parts.length - 1].toUpperCase();
                } else {
                    f = toShow.getFullName().substring(0, 1);
                    s = toShow.getFullName().substring(1, 2);
                }
            }
            this.avatarReplacement.setInitials(toShow.getUserid(), f, s);
            this.avatarReplacement.setVisible(true);
        }
        String commentToShow = toShow.getText();
        if ((commentToShow = commentToShow.replaceAll("&amp;", "&")).length() > 450) {
            int TEXT_TO_SHOW_LENGHT = commentToShow.length() < 700 ? commentToShow.length() - commentToShow.length() / 3 : 700;
            commentToShow = commentToShow.substring(0, TEXT_TO_SHOW_LENGHT) + "...";
            this.seeMore.setHTML("<a class=\"seemore\"> See More </a>");
        }
        String profilePageURL = "/group" + NewsFeedPanel.extractOrgFriendlyURL((String)Window.Location.getHref()) + "/profile";
        this.commentText.setHTML("<a class=\"link\" href=\"" + profilePageURL + "?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)toShow.getUserid()) + "\">" + toShow.getFullName() + "</a> " + commentToShow);
        Date now = new Date();
        String formattedTimeEdit = null;
        String formattedTime = now.getYear() != toShow.getTime().getYear() ? DateTimeFormat.getFormat((String)"MMMM dd yyyy, h:mm a").format(toShow.getTime()) : DateTimeFormat.getFormat((String)"MMMM dd, h:mm a").format(toShow.getTime());
        if (toShow.isEdit()) {
            formattedTimeEdit = now.getYear() != toShow.getLastEditTime().getYear() ? DateTimeFormat.getFormat((String)"MMMM dd yyyy, h:mm a").format(toShow.getLastEditTime()) : DateTimeFormat.getFormat((String)"MMMM dd, h:mm a").format(toShow.getLastEditTime());
        }
        if (toShow.isEdit()) {
            this.timeArea.setHTML(formattedTime + " (Last edit on " + formattedTimeEdit + ")");
        } else {
            this.timeArea.setHTML(formattedTime);
        }
        if (isUsers) {
            this.closeImage.setStyleName("closeImage");
            this.closeImage.setTitle("Delete");
            this.editImage.setStyleName("editImage");
            this.editImage.setTitle("Edit");
        }
    }

    @UiHandler(value={"seeMore"})
    void onSeeMoreClick(ClickEvent e) {
        String commentToShow = this.myComment.getText();
        commentToShow = commentToShow.replaceAll("&amp;", "&");
        String profilePageURL = "/group" + NewsFeedPanel.extractOrgFriendlyURL((String)Window.Location.getHref()) + "/profile";
        this.commentText.setHTML("<a class=\"link\" href=\"" + profilePageURL + "?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)this.myComment.getUserid()) + "\">" + this.myComment.getFullName() + "</a> " + commentToShow);
        this.seeMore.setHTML("");
    }

    @UiHandler(value={"closeImage"})
    void onDeleteCommentClick(ClickEvent e) {
        if (this.isUsers) {
            this.owner.getEventBus().fireEvent((GwtEvent)new DeleteCommentEvent(this.owner, this.myCommentid));
        }
    }

    @UiHandler(value={"editImage"})
    void onEditCommentClick(ClickEvent e) {
        if (this.isUsers) {
            AddCommentTemplate addComm = new AddCommentTemplate(this.owner, this.myComment, this.mainPanel);
            this.mainPanel.getElement().setInnerHTML("");
            this.mainPanel.add((Widget)addComm);
        }
    }

    @UiHandler(value={"commentText"})
    public void onHover(MouseOverEvent event) {
        if (this.isUsers) {
            this.closeImage.addStyleName("uiCloseButton");
            this.editImage.addStyleName("uiEditButton");
        }
    }

    @UiHandler(value={"commentText"})
    public void onHover(MouseOutEvent event) {
        if (this.isUsers) {
            this.closeImage.removeStyleName("uiCloseButton");
            this.editImage.removeStyleName("uiEditButton");
        }
    }

    public String getCommentKey() {
        return this.myCommentid;
    }
}

