package org.gcube.portlets.user.notifications.client.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;

import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;
import org.gcube.portlets.user.notifications.client.NotificationsServiceAsync;
import org.gcube.portlets.user.notifications.client.view.templates.CategoryWrapper;
import org.gcube.portlets.user.notifications.client.view.templates.NotificationPreferenceView;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;


import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


/**
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class NotificationSettingsDialog extends GCubeDialog {

	private VerticalPanel mainPanel = new VerticalPanel();
	private VerticalPanel container = new VerticalPanel();
	private HorizontalPanel buttonsContainerPanel = new HorizontalPanel();
	private HorizontalPanel buttonsPanel = new HorizontalPanel();

	public static final String loading = GWT.getModuleBaseURL() + "../images/feeds-loader.gif";
	public static final String mailSentOK = GWT.getModuleBaseURL() + "../images/yes.png";
	public static final String mailSentNOK = GWT.getModuleBaseURL() + "../images/warning_blue.png";

	ArrayList<CategoryWrapper> myCategories = new ArrayList<CategoryWrapper>();

	private Button cancel = new Button("Cancel");
	private Button save = new Button("Save");

	public NotificationSettingsDialog(LinkedHashMap<String, ArrayList<NotificationPreference>> preferences, final NotificationsServiceAsync notificationService) {
		super();
		ScrollPanel scroller = new ScrollPanel();
		scroller.setWidth("890px");
		scroller.setHeight("500px");
		buttonsPanel.setWidth("100%");
		buttonsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);

		container.setStyleName("user-notification");
		container.setWidth("850px");

		for (String category : preferences.keySet()) {
			CategoryWrapper cat = new CategoryWrapper(category, preferences.get(category));
			container.add(cat);
			myCategories.add(cat);
		}	

		buttonsContainerPanel.add(cancel);
		buttonsContainerPanel.add(save);
		buttonsPanel.add(buttonsContainerPanel);
		//container.add(buttonsPanel);


		setText("Notification Settings");
		scroller.add(container);
		mainPanel.add(scroller);		
		mainPanel.add(buttonsPanel);
		setWidget(mainPanel);

		save.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				HashMap<NotificationType, NotificationChannelType[]> toStore = new HashMap<NotificationType, NotificationChannelType[]>();
				for (CategoryWrapper cat : myCategories) {
					for (NotificationType notType : cat.getSelectedChannels().keySet()) {
						toStore.put(notType, cat.getSelectedChannels().get(notType));
						//GWT.log(""+notType + " - " +  cat.getSelectedChannels().get(notType));
					}
				}
				notificationService.setUserNotificationPreferences(toStore, new AsyncCallback<Boolean>() {					
					@Override
					public void onSuccess(Boolean result) {
						showDeliveryResult(result);						
					}

					@Override
					public void onFailure(Throwable caught) {
						showDeliveryResult(false);								
					}
				});
			}
		});

		cancel.addClickHandler(new ClickHandler() {			
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});

	}

	private void showDeliveryResult(boolean success) {
		mainPanel.clear();
		mainPanel.setWidth("890px");
		mainPanel.setHeight("500px");
		mainPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
		mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		if (success) {
			setText("Notifications Settings Saved");
			mainPanel.add(new HTML("<span style=\"font-size: 28px;\">Notifications Settings correctly saved.</span>"));
			mainPanel.add(new Image(mailSentOK));
		}
		else {
			setText("Notifications Settings Saving Error");
			mainPanel.add(new Image(mailSentNOK));
			mainPanel.add(new HTML("There were problems contacting the server, please try again in a short while."));
			Button close = new Button("Close");
			close.addClickHandler(new ClickHandler() {				
				@Override
				public void onClick(ClickEvent event) {
					hide();					
				}
			});
		}
		Button close = new Button("Close");
		close.setSize("200px", "70px");
		close.getElement().getStyle().setFontSize(24, Unit.PX);
		close.addClickHandler(new ClickHandler() {		
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});
		mainPanel.add(close);		
	}

}
