package org.gcube.portlets.user.occurrencemanagement.client.dialog;

import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.KeyboardEvents;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;



/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class DialogCreateNewComputation extends Dialog {
	
	private int widthDialog = 500;
	private int heightTextArea = 150;
	private TextField<String> txtName;
	private TextArea textAreaDescription = new TextArea();
	
	public DialogCreateNewComputation(String headerTitle) {
		
	    FormLayout layout = new FormLayout();
	    layout.setLabelWidth(90);
	    layout.setDefaultWidth(300);
	    setLayout(layout);
	    
	    setHeading(headerTitle);

	    setButtonAlign(HorizontalAlignment.CENTER);

	    setModal(true);
	    setBodyStyle("padding: 9px; background: none");
	    setWidth(widthDialog);
	    setResizable(false);
	    setButtons(Dialog.OKCANCEL);
	    
	    txtName = new TextField<String>();
	    txtName.setAllowBlank(false);
//	    txtName.setRegex("^[a-zA-Z0-9]+[ ]*[a-zA-Z0-9_-]+$");
//	    txtName.setAutoValidate(true);
	    txtName.getMessages().setRegexText(ConstantsPortletOccurrence.MESSAGE_NAME_FORCE_APHANUMERIC);

	    txtName.setFieldLabel("Name");
	    textAreaDescription.setFieldLabel("Description");
	    textAreaDescription.setHeight(heightTextArea);

	    txtName.addKeyListener(new KeyListener() { // KEY ENTER
	    
			public void componentKeyPress(ComponentEvent event) {
				if (event.getKeyCode() == KeyboardEvents.Enter.getEventCode()) 
					getButtonById(Dialog.OK).fireEvent(Events.Select);
				
			}
		});
	   
	    
        this.getButtonById(Dialog.CANCEL).addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {
				hide();
			}
		});
        
	    
        this.getButtonById(Dialog.OK).addSelectionListener(new SelectionListener<ButtonEvent>() {

			@Override
			public void componentSelected(ButtonEvent ce) {
				if(isValidForm())
					hide();
			}
		});
        
        setFocusWidget(txtName);
        add(txtName);
		add(textAreaDescription);
      
        this.show();
	}


	public String getName() {
		return txtName.getValue();
	}

	public String getDescription() {
		if(textAreaDescription.getValue()==null)
			return "";
		
		return textAreaDescription.getValue();
	}

	public boolean isValidForm(){
		
		if(txtName.isValid() && txtName.getValue() != null)
			return true;
		
		return false;
		
	}
}
