package org.gcube.portlets.user.occurrencemanagement.client.job;

import java.util.HashMap;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.filters.DateFilter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GridJob extends ContentPanel{
	
	private GroupingStore<BaseModelData> store;
	protected Grid<BaseModelData> grid;
	private HashMap<String,WindowInfoJobsSpecies> listWindowInfo = new HashMap<String, WindowInfoJobsSpecies>();
	private JobColumnConfig jobColumnConfig;
	protected ColumnModel cm;
	
	public GridJob(JobColumnConfig colConfig) {
		setLayout(new FitLayout());
		this.jobColumnConfig = colConfig;
		this.cm = new ColumnModel(jobColumnConfig.getListColumnConfig());

		setBodyBorder(false);
		setHeaderVisible(false);
		
		initGrid();
	}
	
	
	public void initGrid(){
		
		GridFilters filters = new GridFilters();
		filters.setLocal(true);

		DateFilter dateFilterStart = new DateFilter(JobOccurrencesModel.STARTTIME);
		DateFilter dateFilterEnd = new DateFilter(JobOccurrencesModel.ENDTIME);
		
		filters.addFilter(dateFilterStart);
		filters.addFilter(dateFilterEnd);

		store = new GroupingStore<BaseModelData>();
		
		grid = new Grid<BaseModelData>(store, cm);
		grid.setLoadMask(true); 
		
	    GridCellRenderer<BaseModelData> downloadStateRenderer = new GridCellRenderer<BaseModelData>() {  
			@Override
			public String render(BaseModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseModelData> store, Grid<BaseModelData> grid) {
		          String val = model.get(property).toString();  
		          String color="black";
		          
		          if(val!=null){
		        		  
//		        		  if(val.compareTo(DownloadState.COMPLETED.toString())==0){
//		        			  color ="#0000EE";
//		        		  }else 
		        			
		        	  if(val.compareTo(ElaborationStatus.FAILED.toString())==0){
				        	  color = "#f00";
				          }
		          }
		          else
		        	  val = "";
		          
		          return "<span qtitle='" + cm.getColumnById(property).getHeader() + "' qtip='" + val  + "' style='color:" + color + "'>" + val + "</span>";
		          
			}  
	      };
	      
		 if(jobColumnConfig.isStatusAsString())
			 jobColumnConfig.getStatusColumnConfig().setRenderer(downloadStateRenderer);
	
		GridCellRenderer<BaseModelData> jobSpeciesRenderer = new GridCellRenderer<BaseModelData>() {  
    	  
          public Object render(final BaseModelData model, String property, ColumnData config, final int rowIndex,  
              final int colIndex, ListStore<BaseModelData> store, Grid<BaseModelData> grid) {  
   
              grid.addListener(Events.ColumnResize, new Listener<GridEvent<BaseModelData>>() {  
      
                public void handleEvent(GridEvent<BaseModelData> be) { 
                	updateProgressSizeByResize(be.getWidth(), be.getColIndex());
                }  
              });  
              
            return model.get(property);  
          }  
        }; 
        
  
        if(jobColumnConfig.isStatusAsProgress()){
	        jobColumnConfig.getProgressStatusColumnConfig().setRenderer(jobSpeciesRenderer);
//			jobColumnConfig.getProgressStatusColumnConfig().setResizable(false);
			jobColumnConfig.getProgressStatusColumnConfig().setFixed(true);
        }

		grid.getView().setEmptyText("Empty");
		grid.getView().setShowDirtyCells(false);
		grid.getView().setShowInvalidCells(false);
		grid.setBorders(false);
//		grid.setStripeRows(true);
		grid.setColumnLines(true);
		grid.addPlugin(filters);
		
		grid.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
		
		add(grid);
		
	}

	public void addJobIntoGrid(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar) {
		
		BaseModelData baseModel = convertOccurrenceModel(jobModel,jobProgressBar);
		grid.getStore().add(baseModel);
		updateJobInfo(jobModel);
	}
	
	public void updateProgressSize(int indexRow, int columnWidth, int colIndex){

		if(jobColumnConfig.isStatusAsProgress()){
			
	        if (grid.getView().getWidget(indexRow, colIndex) != null && grid.getView().getWidget(indexRow, colIndex) instanceof JobOccurrenceProgressBar) { 
	        	
	          ((JobOccurrenceProgressBar) grid.getView().getWidget(indexRow, colIndex)).setWidth(columnWidth - 13);
	        }
        }  
	}
	
	public void updateProgressSize(){
		
		if(jobColumnConfig.isStatusAsProgress()){
		
			int columnIndex = grid.getColumnModel().indexOf(jobColumnConfig.getProgressStatusColumnConfig());
		    int columnWidth = grid.getColumnModel().getColumn(columnIndex).getWidth();
	
		    updateProgressSizeByResize(columnWidth, columnIndex);
		}
	}
	
	
	public void updateProgressSizeByResize(int columnWidth, int colIndex){

		if(jobColumnConfig.isStatusAsProgress()){
			for (int i = 0; i < grid.getStore().getCount(); i++) {  
				
	            if (grid.getView().getWidget(i, colIndex) != null && grid.getView().getWidget(i, colIndex) instanceof JobOccurrenceProgressBar) { 
	            	
	              ((JobOccurrenceProgressBar) grid.getView().getWidget(i, colIndex)).setWidth(columnWidth - 13);
	
	            }  
	          }  
		}
	}
	
	private void updateJobInfo(JobOccurrencesModel jobModel){
		
		WindowInfoJobsSpecies win=listWindowInfo.get(jobModel.getIdentifier());

		if(win==null)
			win = new WindowInfoJobsSpecies();
		
		win.setWindowTitle(jobModel.getName());
		win.setDescriptionByModel(jobModel);
			
		listWindowInfo.put(jobModel.getIdentifier(), win);
	}
	
	public void updateStatus(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar){
		
		BaseModelData job = grid.getStore().findModel(JobOccurrencesModel.JOBINDENTIFIER, jobModel.getIdentifier());
		
		if(job!=null){
			
			job.set(JobOccurrencesModel.JOBNAME, jobModel.getName());
			job.set(JobOccurrencesModel.STATUS, jobModel.getDownloadState());
			job.set(JobOccurrencesModel.ENDTIME, jobModel.getEndTime());
			job.set(JobOccurrencesModel.STATUSPROGESSBAR, jobProgressBar);
			
			updateJobInfo(jobModel);
			grid.getStore().update(job);
			
//			this.layout();
		}
	}
	
	public void removeSpeciesJobByIdentifier(String jobIdentifier) {
		BaseModelData job = grid.getStore().findModel(JobOccurrencesModel.JOBINDENTIFIER, jobIdentifier);
		if(job!=null){
			grid.getStore().remove(job);
//			this.layout();
		}
	}

	public Grid<BaseModelData> getGrid() {
		return grid;
	}
	
	public GroupingStore<BaseModelData> getStore() {
		return store;
	}


	public HashMap<String, WindowInfoJobsSpecies> getListWindowInfo() {
		return listWindowInfo;
	}
	
	public void resetStore(){
		grid.getStore().removeAll();
	}
	
	public BaseModelData convertOccurrenceModel(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar){
		
		BaseModelData baseModelData = new BaseModelData();
		
		if(jobModel!=null){
			baseModelData.set(JobOccurrencesModel.JOBINDENTIFIER, jobModel.getIdentifier());
			baseModelData.set(JobOccurrencesModel.JOBNAME, jobModel.getName());
			baseModelData.set(JobOccurrencesModel.STATUSPROGESSBAR, jobProgressBar);
			baseModelData.set(JobOccurrencesModel.ELABORATIONTYPE, jobModel.getType());
			baseModelData.set(JobOccurrencesModel.STATUS, jobModel.getDownloadState());
			baseModelData.set(JobOccurrencesModel.STARTTIME, jobModel.getStartTime());
			baseModelData.set(JobOccurrencesModel.ENDTIME, jobModel.getEndTime());
			baseModelData.set(JobOccurrencesModel.OCCURRENCEMODEL, jobModel);
			baseModelData.set(JobOccurrencesModel.DESCRIPTION, jobModel.getDescription());
			baseModelData.set(JobOccurrencesModel.RESOURCETYPE, jobModel.getResourceType());
			if(jobModel.getComputation()!=null)
				baseModelData.set(JobOccurrencesModel.COMPUTATIONID, jobModel.getComputation().getId());
		}
		
		return baseModelData;
	}

}
