package org.gcube.portlets.user.occurrencemanagement.client.job;


import org.gcube.portlets.user.occurrencemanagement.shared.ComputationModel;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class WindowInfoJobsSpecies extends Window{
	
//	private JobsInfoContainer jobInfo = new JobsInfoContainer(new ListStore<ModelData>());
	
	private TextArea textArea = new TextArea();
	
	
	public WindowInfoJobsSpecies() {
		setSize(450, 300);
		setLayout(new FitLayout());
		textArea.setSize(420, 280);
		textArea.setReadOnly(true);
		add(textArea);
	}

	public void setDescriptionByModel(JobOccurrencesModel jobModel){
		
		String description = "Description: \n\n";
		
		if(jobModel!=null){
		
			description+= "\nName: " + jobModel.getName();
			
			description+= "\n\n"+jobModel.getDescription();
			
			ComputationModel computation = jobModel.getComputation();
			
			if(computation!=null){
			
				if(computation.getAlgorithm()!=null)
					description+=  "\n\nAlgorithm: " + computation.getAlgorithm();
				
				if(computation.getDescription()!=null)
					description+= "\n"+computation.getDescription();
				
				if(computation.getCategory()!=null)
					description+=  "\n\nCategory: " + computation.getCategory() ;
			}

		}
		textArea.setValue(description);

	}
	
	public void setDescription(String text){
		textArea.setValue("Description: \n\n" + text);
	}

	public void setWindowTitle(String title) {
		this.setHeading(title);
		
	}

}
