package org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.occurrencemanagement.shared.ComputationModel;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;



public class DetailsOperationPanelMng extends ContentPanel {
	
	private static final String SELECT_A_COMPUTATION = "Select a computation";

	private VerticalPanel vp = new VerticalPanel();
	
	private Label labelIdComputation = new Label("Id computation");
	private TextField<String> textIdComputation = new TextField<String>();
//	private Label textIdComputation = new Label("text");
	
	private Label labelAlgorithm = new Label("Algorithm used");
	private TextField<String> textAlgorithm = new TextField<String>();
	
	private Label labelDescription = new Label("Description");
	private TextArea textDescription = new TextArea();
	
	private Label labelParameters = new Label("Parameters");
	VerticalPanel vpParameters = new VerticalPanel();
	
	
	public DetailsOperationPanelMng() {
		setLayout(new FitLayout());
		setBodyBorder(false);
		setScrollMode(Scroll.AUTO);
		
		setHeading("Details");
		
		initLayout();
	}
	
	
	
	
	private void initLayout() {
		
		labelIdComputation.addStyleName("labelDetails");
		labelAlgorithm.addStyleName("labelDetails");
		labelDescription.addStyleName("labelDetails");
		labelParameters.addStyleName("labelDetails");
	
		vp.setStyleAttribute("margin", "5px");
		vp.setSpacing(5);
		vpParameters.setStyleAttribute("margin", "10px");
		vpParameters.setWidth(320);
		
		textDescription.setWidth(350);
		textDescription.setHeight(250);
		textDescription.setReadOnly(true);
		textDescription.setEmptyText(SELECT_A_COMPUTATION);
		
		textIdComputation.setReadOnly(true);
		textIdComputation.setWidth(350);
		textIdComputation.setEmptyText(SELECT_A_COMPUTATION);
		
		textAlgorithm.setReadOnly(true);
		textAlgorithm.setWidth(350);
		textAlgorithm.setEmptyText(SELECT_A_COMPUTATION);

		vp.add(labelIdComputation);
		vp.add(textIdComputation);
		
		vp.add(labelAlgorithm);
		vp.add(textAlgorithm);
		
		vp.add(labelParameters);
		vp.add(vpParameters);
		
		vp.add(labelDescription);
		vp.add(textDescription);
		

//		//TODO REMOVE
//		HashMap<String, String> hashParameters = new HashMap<String, String>();
//		//****************************************************
//		for (int i = 0; i < 20; i++) {
//			hashParameters.put("parameter "+i, "value"+i);
//		}
//		
//		hashParameters.put("bla ", "blavalue");
//		
//		addParameters(hashParameters);
//		
//		
//		//****************************************************
		
		add(vp);
	}




	public void displaDetaylsByModel(JobOccurrencesModel occurrencesModel){
		
		if(occurrencesModel!=null){
			
			ComputationModel computation = occurrencesModel.getComputation();
			
			textIdComputation.setValue(cleanValue(computation.getId()));
			
			textAlgorithm.setValue(cleanValue(computation.getAlgorithm()));
			
			textDescription.setValue(cleanValue(computation.getDescription()));
			
			vpParameters.removeAll();
			
			addParameters(computation.getParametersMap());
		
		}
		else
			resetFields();
			
	}
	
	
	private void addParameters(Map<String, String> mapParameters){
		
		if(mapParameters!=null && mapParameters.size()>0){
			
			//ALPHABETICAL ORDER OF THE PARAMETERS
			List<String> listKey = Arrays.asList((mapParameters.keySet().toArray(new String[mapParameters.keySet().size()])));
			
			Collections.sort(listKey);
			
			for (String parameter:  listKey) {

				String value = mapParameters.get(parameter);
				
				HorizontalPanel hp = new HorizontalPanel();

				Text txtParameter = new Text(parameter+":");	
//				TextField<String>  txtParameter =  new TextField<String>();
//				txtParameter.setValue(parameter+":");
//				setTextFieldAttr(txtParameter, "background-image", "none");
//				setTextFieldAttr(txtParameter, "background-color", "none");
//				setTextFieldAttr(txtParameter, "border-style", "none");
//				Text txtValue;

				TextField<String> txtValue = new TextField<String>();
				txtValue.setReadOnly(true);
				setTextFieldAttr(txtValue, "background-image", "none");
				setTextFieldAttr(txtValue, "background-color", "none");
				setTextFieldAttr(txtValue, "border-style", "none");

				if(value!=null && !value.isEmpty())
//					txtValue = new Text(value);
					txtValue.setValue(value);
				else
//					txtValue = new Text("not found");	
					txtValue.setValue("not found");
//				labelRank.setStyleAttribute("margin-right", "10px");
				
				txtParameter.addStyleName("labelParameters");
				txtValue.addStyleName("valueParameters");
				
				hp.add(txtParameter);
				hp.add(txtValue);
				
				hp.setCellWidth(txtParameter, "185px");
				hp.setCellVerticalAlignment(txtParameter, HasVerticalAlignment.ALIGN_MIDDLE);
				
				hp.setCellHeight(txtParameter, "27px");
			
				hp.setCellHeight(txtValue,"27px");
				hp.setCellVerticalAlignment(txtValue, HasVerticalAlignment.ALIGN_MIDDLE);
				
				vpParameters.add(hp);
			
			}
		}
		else{
			vpParameters.add(new Text("not founds"));
		}
		
		vp.layout();
	}
	
	public void resetFields(){
		textIdComputation.reset();
		textDescription.reset();
		textAlgorithm.reset();
		vpParameters.removeAll();
	}
	
	private String cleanValue(String value){
		if(value==null)
			return "";
		return value;
	}
	
	
	
	public interface Function {
	    public void execute ();
	}

	/**
	* Safe function call on a component, which was rendered or not.
	*
	* @param c Component object that must be not null.
	* @param f Function object with the function that must be called.
	*/
	public static void safeFunctionCallOn(final Component c, final Function f) {
	    c.enableEvents(true);
	    if (c.isRendered()) {
	        f.execute();
	    } else {
	        final Listener<BaseEvent> lsnr = new Listener<BaseEvent>() {
				@Override
				public void handleEvent(final BaseEvent be) {
					  f.execute();
					
				}
	        };
	        c.addListener(Events.Render, lsnr);
	    }
	}
	
	 /* Sets a style attribute for the  text-field control */
	public static void setTextFieldAttr(final Field<?> textField, final String cssAttrNm, final String attrVal) {
		safeFunctionCallOn(textField, new Function() {
			@Override
			public void execute() {
			textField.el().firstChild().setStyleAttribute(cssAttrNm, attrVal);
			}
		});
	}
	
}
