package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;


import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;




/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GxtBorderLayoutDataPanel extends ContentPanel {
	private ContentPanel north = new ContentPanel();
	private ContentPanel west = new ContentPanel();
	private ContentPanel center = new ContentPanel();
	private CenterDataPanelMng centerDataPanel;
	private ExplorerDataPanelMng explorerDataPanel;

	
	public GxtBorderLayoutDataPanel(CenterDataPanelMng centerDataPanel, ExplorerDataPanelMng explorerPanel) {
		
		this.centerDataPanel = centerDataPanel;
		this.explorerDataPanel = explorerPanel;
		this.initLayout();
		this.createLayouts();
	}

	private void initLayout(){
			
		north.setId("NorthDataPanel");
		north.setLayout(new FitLayout());

		north.setHeaderVisible(false);
		north.setBodyBorder(false);
		
		west.setId("WestDataPanel");
		west.setLayout(new FitLayout());
		west.setHeaderVisible(false);
		west.setBodyBorder(false);
		
		center.setId("CenterDataPanel");
		center.setLayout(new FitLayout());
	    center.setHeaderVisible(false);
	    center.setBodyBorder(false);
//		east.setId("EastPanel");
		center.setScrollMode(Scroll.AUTOX);
		center.setBorders(false);
		
		this.createLayouts();
	}
		
	public void createLayouts(){
		
		final BorderLayout borderLayout = new BorderLayout();
		setLayout(borderLayout);

		setHeaderVisible(false);
		
	    BorderLayoutData northData = new BorderLayoutData(LayoutRegion.NORTH, 37, 37, 37);  
	    northData.setCollapsible(false);  

	    BorderLayoutData westData = new BorderLayoutData(LayoutRegion.WEST, 450,550,600);  
	    westData.setSplit(true);  
	    westData.setCollapsible(true);  
	    westData.setMargins(new Margins(0,3,0,0));
	    
	    BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
	    centerData.setMargins(new Margins(0));

//	    west.addListener(Events.Resize, new Listener<BoxComponentEvent>(){
//
//			@Override
//			public void handleEvent(BoxComponentEvent be) {
//
////				explorerPanel.getResultLoadPanel().getJobManager().getGridJob().getGrid().setWidth(650);
////				
////				explorerPanel.getResultLoadPanel().getJobManager().getGridJob().layout();
//				
//			}
//			
//		});
	    
	    north.add(new ToolBarDataPanel());
	    west.add(explorerDataPanel);
	    center.add(this.centerDataPanel);

//	    add(north, northData);  
	    add(west, westData); 
	    add(center, centerData);  
//	    add(east, eastData);
	}

	public void updateHeight(int rootHeight) {
		setHeight(rootHeight);
		centerDataPanel.setGridHeight(rootHeight-27);
	}

	public void updateWidth(int rootWidth) {
		setWidth(rootWidth);

	}
}