package org.gcube.portlets.user.occurrencemanagement.server.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.gcube.data.harmonization.occurrence.impl.model.Computation;
import org.gcube.data.harmonization.occurrence.impl.model.Resource;
import org.gcube.data.harmonization.occurrence.impl.model.types.OperationType;
import org.gcube.data.harmonization.occurrence.impl.model.types.Status;
import org.gcube.portlets.user.occurrencemanagement.shared.ComputationModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ResourceType;


public class GxtReconciliationServiceConverter {
	
	public static Logger logger = Logger.getLogger(GxtReconciliationServiceConverter.class);

	public static Date toDate(Calendar calendar)
	{
		if (calendar == null) return  null;
		return calendar.getTime();

	}

	public static ArrayList<JobOccurrencesModel> getImportRequestOccurrencesJob(List<Resource> availableData, boolean onlyNotCompleted) {
		
		ArrayList<JobOccurrencesModel> listJob = new ArrayList<JobOccurrencesModel>();
		logger.trace("getImportRequest...");
		
		System.out.println("getImportRequest...");
		
		for (Resource imp : availableData){

			org.gcube.data.harmonization.occurrence.impl.model.Operation operation = imp.getOperation();

			ElaborationStatus elaborationStatus = convertStatus(operation.getStatus());
			
			JobOccurrencesModel jobModel = null;
			
			if(onlyNotCompleted){
				
				if(!elaborationStatus.equals(ElaborationStatus.COMPLETED)){ //return only not completed
					
					jobModel = createOccurrenceModelFromResource(imp,elaborationStatus);
					
					//For debug
					logger.trace(jobModel);
					System.out.println(jobModel);
					
					listJob.add(jobModel);	
				}
			}
			else {//return all
				
				jobModel = createOccurrenceModelFromResource(imp,elaborationStatus);
				
				//For debug
				logger.trace(jobModel);
				System.out.println(jobModel);
				
				listJob.add(jobModel);	
			}

		}
		
		logger.trace("getImportRequest -  size " + listJob.size());
		
		System.out.println("getImportRequest -  size " + listJob.size());
		
		return listJob;
	}



	public static ArrayList<JobOccurrencesModel> getSubmittedOperationOccurrencesJob(List<Computation> submittedOperationList, boolean onlyNotCompleted) {
		
		ArrayList<JobOccurrencesModel> listJob = new ArrayList<JobOccurrencesModel>();
		logger.trace("getSubmittedOperation...");
		
		if(submittedOperationList!=null){
			
			for (Computation submittedOperation : submittedOperationList) {
				
				ElaborationStatus elaborationStatus = convertStatus(submittedOperation.getStatus());
				
				JobOccurrencesModel jobModel = null;
				
				if(onlyNotCompleted){
					
					if(!elaborationStatus.equals(ElaborationStatus.COMPLETED)){ //return only not completed
					
						jobModel = createOccurrenceModelFromSubmittedOperation(submittedOperation, elaborationStatus);
						
						//For debug
						logger.trace(jobModel);
						System.out.println(jobModel);
						
						listJob.add(jobModel); 
					}
						
				}
				else{ //return all
					
					jobModel = createOccurrenceModelFromSubmittedOperation(submittedOperation, elaborationStatus);
					
					//For debug
					logger.trace(jobModel);
					System.out.println(jobModel);
					
					listJob.add(jobModel); 
				}
				
			}
			logger.trace("getSubmittedOperation -  size " + listJob.size());
		
		}
		else{
			
			logger.trace("submittedOperationList -  is NULL");
		}
			
		return listJob;
	}
	
	
	public static ElaborationType convertFromOperationType(OperationType opType){
		
		switch (opType) {
		
			case COMPUTATION: return ElaborationType.COMPUTATION;
			
			case IMPORT: return ElaborationType.IMPORTED;
				
			default: return null;
		}
	}
	
	public static OperationType convertToOperationType(ElaborationType elabType){
		
		switch (elabType) {
			case COMPUTATION: return OperationType.COMPUTATION;
			case IMPORTED: return OperationType.IMPORT;
			case OPERATIONS: 
			default: return null;
		}
	}
	
	
	public static JobOccurrencesModel createOccurrenceModelFromResource(Resource imp, ElaborationStatus elaborationStatus){
		
		org.gcube.data.harmonization.occurrence.impl.model.Operation operation = imp.getOperation();

		ElaborationType elaborationType = convertFromOperationType(operation.getOperationType());
		
		ResourceType resourceType = convertFromResourceType(imp.getType());

		JobOccurrencesModel jobModel = new JobOccurrencesModel(imp.getId(), imp.getName(), elaborationType, elaborationStatus, imp.getResourceDescription(), toDate(operation.getSubmissionDate()), operation.getOperationId()+"",resourceType);
		
		if(operation.getCompletionDate()!=null)
			jobModel.setEndTime(toDate(operation.getCompletionDate()));
		
		return jobModel;
	}
	

	
//	public static JobOccurrencesModel createOccurrenceModelFromSubmittedOperation(Computation submittedOperation, ElaborationStatus elaborationStatus){
//		
//		ComputationModel computation = convertComputation(submittedOperation);
//		
//		JobOccurrencesModel jobModel  = new JobOccurrencesModel(submittedOperation.getOperationId()+"", submittedOperation.getName(), elaborationStatus, computation, toDate(submittedOperation.getStartDate())); //TODO NAME
//		
//		if(computation.get!=null)
//			jobModel.setEndTime(toDate(submittedOperation.getEndDate()));
//		
//		return jobModel;
//	}
//	
	
	
	public static ResourceType convertFromResourceType(org.gcube.data.harmonization.occurrence.impl.model.types.ResourceType type) {
		
		switch (type) {
			case FILE:
				
				return ResourceType.FILE;
				
			case OBJECT:
				
				return ResourceType.OBJECT;
				
			case TABULAR:
				
				return ResourceType.TABULAR;

		default:
			return ResourceType.TABULAR;
		}
	}




	public static JobOccurrencesModel createOccurrenceModelFromSubmittedOperation(Computation submittedOperation, ElaborationStatus elaborationStatus){
		
		ComputationModel computationModel = convertComputation(submittedOperation);
		
		return new JobOccurrencesModel(computationModel.getId(), computationModel.getName(), computationModel.getType(), elaborationStatus, computationModel, computationModel.getStartTime(), computationModel.getEndTime());
	}
	
	
	
	public static Float convertStringToFloat(String stringFloat) {
		Float f = new Float(0);

		if(stringFloat==null)
			return f;
		
		try {
			f = new Float(stringFloat);

		} catch (NumberFormatException e) {
			return f;
		}

		return f;
	}
	
	public static ComputationModel convertComputation(Computation computation){
		logger.trace("convertComputation");
		
		Map<String, String> parametersMap = computation.getParameters();
		ElaborationType elaborationType = convertFromOperationType(computation.getOperationType());
		if(parametersMap!=null){
			logger.trace("convertComputation - parametersMap is not null");
		}
		
		//TODO FOR DEBUG
		//****************************************************

		/*
			if(parametersMap!=null){
				logger.trace("convertComputation - parametersMap is not null");
		
				if(parametersMap.keySet().size()>0)
					System.out.println("PARAMETERS key is > 0");
				
				for (String key: parametersMap.keySet()) {
					System.out.println("PARAMETERS ALG: "+ parametersMap.get(key));
				}
				
			}
			
			else
				System.out.println("PARAMETERS MAP IS NULL!!!");
			*/
		
		//****************************************************
		
		return new ComputationModel(computation.getOperationId()+"", computation.getTitle(), computation.getAlgorithm(), computation.getOperationDescription(), computation.getCategory(), parametersMap, elaborationType, toDate(computation.getSubmissionDate()), toDate(computation.getCompletionDate()));
	}
	
	public static ElaborationStatus convertStatus(Status status){
		
		switch (status) {

		case PENDING: {

			return ElaborationStatus.PENDING;
		}

		case COMPLETED: {

			return ElaborationStatus.COMPLETED;
		}

		case RUNNING: {

			return ElaborationStatus.RUNNING;
		}

		case FAILED: {

			return ElaborationStatus.FAILED;
		}
		
		case STOPPED:{
			return ElaborationStatus.STOPPED;
		}
		
		default:
			return ElaborationStatus.FAILED;

		}
	}
}
