package org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class ComputationStatus implements IsSerializable {

	public enum Status{
		PENDING,
		RUNNING,
		COMPLETE,
		FAILED
	};
	
	private float percentage;
	private List<Float> processors = new ArrayList<Float>();
	private Status status;
	
	
	public ComputationStatus() {
		this.status = Status.PENDING;
	}
	
	public ComputationStatus(float percentage, List<Float> processors) {
		super();
		this.percentage = percentage;
		this.processors = processors;
	}

	public ComputationStatus(Status status, float percentage, List<Float> processors) {
		super();
		this.percentage = percentage;
		this.processors = processors;
		this.status = status;
	}

	/**
	 * @param perc
	 * @param term
	 */
	public ComputationStatus(Status status, float percentage) {
		super();
		this.percentage = percentage;
		this.status = status;
	}

	public float getPercentage() {
		return percentage;
	}
	
	public List<Float> getProcessors() {
		return processors;
	}
	
	public void setPercentage(float percentage) {
		this.percentage = percentage;
	}
	
	public void setProcessors(List<Float> processors) {
		this.processors = processors;
	}
	
	public boolean isTerminated() {
		return this.status == Status.COMPLETE;
	}
	
	public Status getStatus() {
		return status;
	}
	
	public void setStatus(Status status) {
		this.status = status;
	}

	/**
	 * @return
	 */
	public boolean isFailed() {
		return this.status == Status.FAILED;
	}
}
