/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.SaveResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ResourceType;

public class GridOccurrenceDataPanel
extends ContentPanel {
    private static final String VIEW = "View";
    private ToolBar toolbar;
    private JobManager jobManager;
    private Grid<BaseModelData> grid;
    private static final String INFO = "Info";
    private static final String CANCEL = "Cancel";
    private static final String REFRESH = "Refresh";
    private static final String IMPORT = "Import";
    private static final String SAVE = "Save";
    private Button buttonInfo;
    private Button buttonView;
    private Button buttonCancel;
    private Button buttonRefresh;
    private Button buttonImport;
    private Button buttonSave;
    private MenuItem menuView = new MenuItem();
    private Menu menu = new Menu();

    public GridOccurrenceDataPanel(JobManager jobManager) {
        this.setLayout((Layout)new FitLayout());
        this.setBodyBorder(false);
        this.jobManager = jobManager;
        this.grid = jobManager.getGridJob().getGrid();
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        jobManager.getGridJob().getStore().groupBy("Type");
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        this.grid.setView((GridView)view);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.createGridToolBar();
        this.createMenuItemsOnGrid();
        this.menu.addListener(Events.BeforeShow, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)jobManager.getGridJob());
    }

    private void resetButtonViewVisibility() {
        this.buttonView.setEnabled(true);
        this.menuView.setVisible(true);
    }

    private void createGridToolBar() {
        this.toolbar = new ToolBar();
        this.buttonImport = new Button(IMPORT);
        this.buttonImport.setScale(Style.ButtonScale.MEDIUM);
        this.buttonImport.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageUpload()));
        this.buttonImport.setStyleAttribute("margin-left", "5px");
        this.buttonImport.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonInfo = new Button(INFO);
        this.buttonInfo.setScale(Style.ButtonScale.MEDIUM);
        this.buttonInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageInfo()));
        this.buttonInfo.setStyleAttribute("margin-left", "5px");
        this.buttonInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonView = new Button(VIEW);
        this.buttonView.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageTable()));
        this.buttonView.setScale(Style.ButtonScale.MEDIUM);
        this.buttonView.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonCancel = new Button(CANCEL);
        this.buttonCancel.setScale(Style.ButtonScale.MEDIUM);
        this.buttonCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        this.buttonCancel.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRefresh = new Button(REFRESH);
        this.buttonRefresh.setScale(Style.ButtonScale.MEDIUM);
        this.buttonRefresh.setIcon(Resources.getIconRefresh());
        this.buttonRefresh.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonSave = new Button(SAVE);
        this.buttonSave.setScale(Style.ButtonScale.MEDIUM);
        this.buttonSave.setIcon(Resources.getIconSave());
        this.buttonSave.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.buttonImport);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonInfo);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonView);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonCancel);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonRefresh);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonSave);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.setTopComponent((Component)this.toolbar);
        this.enableButtonOnClick(false);
    }

    public void createMenuItemsOnGrid() {
        MenuItem menuInfo = new MenuItem();
        menuInfo.setId(INFO);
        menuInfo.setText(INFO);
        menuInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageInfo()));
        menuInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuInfo);
        this.menuView.setId(VIEW);
        this.menuView.setText(VIEW);
        this.menuView.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageTable()));
        this.menuView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)this.menuView);
        MenuItem menuCancel = new MenuItem();
        menuCancel.setId(CANCEL);
        menuCancel.setText(CANCEL);
        menuCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        menuCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.menu.add((Component)menuCancel);
        this.grid.setContextMenu(this.menu);
    }

    private void cancel(BaseModelData baseModel) {
        if (baseModel != null) {
            String name = (String)baseModel.get("Name");
            MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", "Are you sure you want to delete " + name + "?");
            mbc.getMessageBoxConfirm().addCallback((Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void info(BaseModelData jobModel) {
        if (jobModel != null) {
            String id = (String)jobModel.get("jobIdentifier");
            WindowInfoJobsSpecies win = (WindowInfoJobsSpecies)this.jobManager.getGridJob().getListWindowInfo().get(id);
            win.show();
        }
    }

    private void view(BaseModelData jobModel) {
        if (jobModel != null) {
            String id = (String)jobModel.get("jobIdentifier");
            String name = (String)jobModel.get("Name");
            OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new OpenTableEvent(id, name));
        }
    }

    public void enableButtonOnClick(boolean bool) {
        this.buttonCancel.setEnabled(bool);
        this.buttonInfo.setEnabled(bool);
        this.buttonView.setEnabled(bool);
        this.buttonSave.setEnabled(bool);
    }

    protected void save(BaseModelData baseModel) {
        if (baseModel != null) {
            JobOccurrencesModel jobModel = (JobOccurrencesModel)baseModel.get("OccurrenceModel");
            String name = (String)baseModel.get("Name");
            ElaborationType type = (ElaborationType)baseModel.get("Type");
            OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new SaveResourceEvent(jobModel.getOperationId(), name, type));
        }
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public List<BaseModelData> getOccurrencesLoadedByResourceType(ResourceType resourceType) {
        ArrayList<BaseModelData> list = new ArrayList<BaseModelData>();
        for (BaseModelData baseModelData : this.grid.getStore().getModels()) {
            if (!baseModelData.get("Resource type").equals(resourceType)) continue;
            list.add(baseModelData);
        }
        return list;
    }

    public List<BaseModelData> getOccurrencesLoaded() {
        return this.grid.getStore().getModels();
    }

    public void refresh() {
        this.jobManager.reset();
        OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new ReLoadListOccurrencesEvent(ElaborationType.IMPORTED));
    }

    public boolean deleteItemById(String identifier) {
        BaseModelData baseModel = (BaseModelData)this.grid.getStore().findModel("jobIdentifier", (Object)identifier);
        if (baseModel != null) {
            return this.deleteItem(baseModel);
        }
        System.out.println("Delete Error: file target with " + identifier + " identifier not exist in store");
        return false;
    }

    private boolean deleteItem(BaseModelData itemTarget) {
        Record record = this.grid.getStore().getRecord((ModelData)itemTarget);
        if (record != null) {
            BaseModelData item = (BaseModelData)record.getModel();
            this.grid.getStore().remove((ModelData)item);
            return true;
        }
        System.out.println("Record Error: occurrence target with " + itemTarget.get("jobIdentifier") + " identifier not exist in store");
        return false;
    }

    static /* synthetic */ Grid access$000(GridOccurrenceDataPanel x0) {
        return x0.grid;
    }

    static /* synthetic */ void access$100(GridOccurrenceDataPanel x0) {
        x0.resetButtonViewVisibility();
    }

    static /* synthetic */ Button access$200(GridOccurrenceDataPanel x0) {
        return x0.buttonView;
    }

    static /* synthetic */ MenuItem access$300(GridOccurrenceDataPanel x0) {
        return x0.menuView;
    }

    static /* synthetic */ void access$400(GridOccurrenceDataPanel x0, BaseModelData x1) {
        x0.info(x1);
    }

    static /* synthetic */ void access$500(GridOccurrenceDataPanel x0, BaseModelData x1) {
        x0.view(x1);
    }

    static /* synthetic */ void access$600(GridOccurrenceDataPanel x0, BaseModelData x1) {
        x0.cancel(x1);
    }
}

