/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.server.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.data.harmonization.occurrence.impl.model.Computation;
import org.gcube.data.harmonization.occurrence.impl.model.Operation;
import org.gcube.data.harmonization.occurrence.impl.model.Resource;
import org.gcube.data.harmonization.occurrence.impl.model.types.OperationType;
import org.gcube.data.harmonization.occurrence.impl.model.types.ResourceType;
import org.gcube.data.harmonization.occurrence.impl.model.types.Status;
import org.gcube.portlets.user.occurrencemanagement.server.service.GxtReconciliationServiceConverter;
import org.gcube.portlets.user.occurrencemanagement.shared.ComputationModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

/*
 * Exception performing whole class analysis ignored.
 */
public class GxtReconciliationServiceConverter {
    public static Logger logger = Logger.getLogger(GxtReconciliationServiceConverter.class);

    public static Date toDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getTime();
    }

    public static ArrayList<JobOccurrencesModel> getImportRequestOccurrencesJob(List<Resource> availableData, boolean onlyNotCompleted) {
        ArrayList<JobOccurrencesModel> listJob = new ArrayList<JobOccurrencesModel>();
        logger.trace((Object)"getImportRequest...");
        System.out.println("getImportRequest...");
        for (Resource imp : availableData) {
            Operation operation = imp.getOperation();
            ElaborationStatus elaborationStatus = GxtReconciliationServiceConverter.convertStatus((Status)operation.getStatus());
            JobOccurrencesModel jobModel = null;
            if (onlyNotCompleted) {
                if (elaborationStatus.equals((Object)ElaborationStatus.COMPLETED)) continue;
                jobModel = GxtReconciliationServiceConverter.createOccurrenceModelFromResource((Resource)imp, (ElaborationStatus)elaborationStatus);
                logger.trace((Object)jobModel);
                System.out.println(jobModel);
                listJob.add(jobModel);
                continue;
            }
            jobModel = GxtReconciliationServiceConverter.createOccurrenceModelFromResource((Resource)imp, (ElaborationStatus)elaborationStatus);
            logger.trace((Object)jobModel);
            System.out.println(jobModel);
            listJob.add(jobModel);
        }
        logger.trace((Object)("getImportRequest -  size " + listJob.size()));
        System.out.println("getImportRequest -  size " + listJob.size());
        return listJob;
    }

    public static ArrayList<JobOccurrencesModel> getSubmittedOperationOccurrencesJob(List<Computation> submittedOperationList, boolean onlyNotCompleted) {
        ArrayList<JobOccurrencesModel> listJob = new ArrayList<JobOccurrencesModel>();
        logger.trace((Object)"getSubmittedOperation...");
        if (submittedOperationList != null) {
            for (Computation submittedOperation : submittedOperationList) {
                ElaborationStatus elaborationStatus = GxtReconciliationServiceConverter.convertStatus((Status)submittedOperation.getStatus());
                JobOccurrencesModel jobModel = null;
                if (onlyNotCompleted) {
                    if (elaborationStatus.equals((Object)ElaborationStatus.COMPLETED)) continue;
                    jobModel = GxtReconciliationServiceConverter.createOccurrenceModelFromSubmittedOperation((Computation)submittedOperation, (ElaborationStatus)elaborationStatus);
                    logger.trace((Object)jobModel);
                    System.out.println(jobModel);
                    listJob.add(jobModel);
                    continue;
                }
                jobModel = GxtReconciliationServiceConverter.createOccurrenceModelFromSubmittedOperation((Computation)submittedOperation, (ElaborationStatus)elaborationStatus);
                logger.trace((Object)jobModel);
                System.out.println(jobModel);
                listJob.add(jobModel);
            }
            logger.trace((Object)("getSubmittedOperation -  size " + listJob.size()));
        } else {
            logger.trace((Object)"submittedOperationList -  is NULL");
        }
        return listJob;
    }

    public static ElaborationType convertFromOperationType(OperationType opType) {
        switch (1.$SwitchMap$org$gcube$data$harmonization$occurrence$impl$model$types$OperationType[opType.ordinal()]) {
            case 1: {
                return ElaborationType.COMPUTATION;
            }
            case 2: {
                return ElaborationType.IMPORTED;
            }
        }
        return null;
    }

    public static OperationType convertToOperationType(ElaborationType elabType) {
        switch (1.$SwitchMap$org$gcube$portlets$user$occurrencemanagement$shared$ElaborationType[elabType.ordinal()]) {
            case 1: {
                return OperationType.COMPUTATION;
            }
            case 2: {
                return OperationType.IMPORT;
            }
        }
        return null;
    }

    public static JobOccurrencesModel createOccurrenceModelFromResource(Resource imp, ElaborationStatus elaborationStatus) {
        Operation operation = imp.getOperation();
        ElaborationType elaborationType = GxtReconciliationServiceConverter.convertFromOperationType((OperationType)operation.getOperationType());
        org.gcube.portlets.user.occurrencemanagement.shared.ResourceType resourceType = GxtReconciliationServiceConverter.convertFromResourceType((ResourceType)imp.getType());
        JobOccurrencesModel jobModel = new JobOccurrencesModel(imp.getId(), imp.getName(), elaborationType, elaborationStatus, imp.getResourceDescription(), GxtReconciliationServiceConverter.toDate((Calendar)operation.getSubmissionDate()), operation.getOperationId() + "", resourceType);
        if (operation.getCompletionDate() != null) {
            jobModel.setEndTime(GxtReconciliationServiceConverter.toDate((Calendar)operation.getCompletionDate()));
        }
        return jobModel;
    }

    public static org.gcube.portlets.user.occurrencemanagement.shared.ResourceType convertFromResourceType(ResourceType type) {
        switch (1.$SwitchMap$org$gcube$data$harmonization$occurrence$impl$model$types$ResourceType[type.ordinal()]) {
            case 1: {
                return org.gcube.portlets.user.occurrencemanagement.shared.ResourceType.FILE;
            }
            case 2: {
                return org.gcube.portlets.user.occurrencemanagement.shared.ResourceType.OBJECT;
            }
            case 3: {
                return org.gcube.portlets.user.occurrencemanagement.shared.ResourceType.TABULAR;
            }
        }
        return org.gcube.portlets.user.occurrencemanagement.shared.ResourceType.TABULAR;
    }

    public static JobOccurrencesModel createOccurrenceModelFromSubmittedOperation(Computation submittedOperation, ElaborationStatus elaborationStatus) {
        ComputationModel computationModel = GxtReconciliationServiceConverter.convertComputation((Computation)submittedOperation);
        return new JobOccurrencesModel(computationModel.getId(), computationModel.getName(), computationModel.getType(), elaborationStatus, computationModel, computationModel.getStartTime(), computationModel.getEndTime());
    }

    public static Float convertStringToFloat(String stringFloat) {
        Float f = new Float(0.0f);
        if (stringFloat == null) {
            return f;
        }
        try {
            f = new Float(stringFloat);
        }
        catch (NumberFormatException e) {
            return f;
        }
        return f;
    }

    public static ComputationModel convertComputation(Computation computation) {
        logger.trace((Object)"convertComputation");
        Map parametersMap = computation.getParameters();
        ElaborationType elaborationType = GxtReconciliationServiceConverter.convertFromOperationType((OperationType)computation.getOperationType());
        if (parametersMap != null) {
            logger.trace((Object)"convertComputation - parametersMap is not null");
        }
        return new ComputationModel(computation.getOperationId() + "", computation.getTitle(), computation.getAlgorithm(), computation.getOperationDescription(), computation.getCategory(), parametersMap, elaborationType, GxtReconciliationServiceConverter.toDate((Calendar)computation.getSubmissionDate()), GxtReconciliationServiceConverter.toDate((Calendar)computation.getCompletionDate()));
    }

    public static ElaborationStatus convertStatus(Status status) {
        switch (1.$SwitchMap$org$gcube$data$harmonization$occurrence$impl$model$types$Status[status.ordinal()]) {
            case 1: {
                return ElaborationStatus.PENDING;
            }
            case 2: {
                return ElaborationStatus.COMPLETED;
            }
            case 3: {
                return ElaborationStatus.RUNNING;
            }
            case 4: {
                return ElaborationStatus.FAILED;
            }
            case 5: {
                return ElaborationStatus.STOPPED;
            }
        }
        return ElaborationStatus.FAILED;
    }
}

