/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.data.BeanModel;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.util.Util;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.StoreFilterField;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.core.client.GWT;



/**
 * @author ceras
 *
 */


public class TableSelector extends Dialog {

	private XTemplate detailTp;
	private Grid<JobOccurrencesModel> grid;  
	private LayoutContainer details;
	private ListStore<JobOccurrencesModel> store = new ListStore<JobOccurrencesModel>();
	private SimpleComboBox<String> sort;
	
	private List<JobOccurrencesModel> listTable = new ArrayList<JobOccurrencesModel>();  

	/**
	 * 
	 */
	public TableSelector(List<JobOccurrencesModel> listTable) {
		this.setBodyBorder(false);
		this.setButtons(Dialog.OKCANCEL);
		this.setIcon(Resources.folderExplore());  
		this.setHeading("Table Occurrences Explorer");  
		this.setWidth(640);  
		this.setHeight(480);  
		this.setHideOnButtonClick(true);  
		this.setModal(true);

		this.listTable = listTable;
		this.setLayout(new BorderLayout());  
		this.setBodyStyle("border: none;background: none");  
	}

	protected void onRender(com.google.gwt.user.client.Element parent, int pos) {
		super.onRender(parent, pos);
		detailTp = XTemplate.create(getDetailTemplate(GWT.getHostPageBaseURL()));

		store = new ListStore<JobOccurrencesModel>();  
		
		Collections.sort(listTable, JobOccurrencesModel.COMPARATOR);
		
		store.add(listTable);

		ContentPanel main = new ContentPanel();  
		main.setBorders(true);  
		main.setBodyBorder(false);  
		main.setLayout(new FitLayout());  
		main.setHeaderVisible(false);  

		ToolBar bar = new ToolBar();  
		bar.add(new LabelToolItem("Filter:"));  

		StoreFilterField<JobOccurrencesModel> field = new StoreFilterField<JobOccurrencesModel>() {  
			@Override  
			protected boolean doSelect(Store<JobOccurrencesModel> store, JobOccurrencesModel parent, JobOccurrencesModel record, String property, String filter) {  
				String name = record.getName().toLowerCase();  
				if (name.indexOf(filter.toLowerCase()) != -1) {  
					return true;  
				}  
				return false;  
			}  

			@Override  
			protected void onFilter() {  
				super.onFilter();  
				grid.getSelectionModel().select(0, false);  
			}
		};  
		field.setWidth(100);  
		field.bind(store);  

		bar.add(field);  
//		bar.add(new SeparatorToolItem());
//		bar.add(new LabelToolItem("Sort By:"));  

//		sort = new SimpleComboBox<String>();  
//		sort.setTriggerAction(TriggerAction.ALL);  
//		sort.setEditable(false);
//		sort.setForceSelection(true);  
//		sort.setWidth(90);  
//		sort.add("Name");  
//		sort.setSimpleValue("Name");  

//		bar.add(sort);  

		ColumnConfig name = new ColumnConfig(JobOccurrencesModel.JOBNAME, JobOccurrencesModel.JOBNAME, 200);
		final ColumnModel cm = new ColumnModel(Arrays.asList(name));
		main.setTopComponent(bar);  

		grid = new Grid<JobOccurrencesModel>(store, cm);
		grid.getView().setAutoFill(true);
		
		this.addListener(Events.Hide, new Listener<WindowEvent>() {  
			public void handleEvent(WindowEvent be) {  
				
				JobOccurrencesModel model = grid.getSelectionModel().getSelectedItem();  
				if (model != null) {  
					if (be.getButtonClicked() == TableSelector.this.getButtonById("ok")) {
						fireSelection(model);
					}  
				}  
			}
		});  

		grid.setBorders(false);  
 
		grid.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);  
		grid.getSelectionModel().addListener(Events.SelectionChange, new Listener<SelectionChangedEvent<BeanModel>>() {  
			public void handleEvent(SelectionChangedEvent<BeanModel> be) {  
				onSelectionChange(be);  
			}  
		});  
		main.add(grid);  

		details = new LayoutContainer();  
		details.setBorders(true);  
		details.setStyleAttribute("backgroundColor", "white");  
		details.add(new Text("Select a table"));

		BorderLayoutData eastData = new BorderLayoutData(LayoutRegion.EAST, 200, 150, 400);  
		eastData.setSplit(true);  

		BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
		centerData.setMargins(new Margins(0, 5, 0, 0));  

		this.add(main, centerData);  
		this.add(details, eastData);  

//		grid.getSelectionModel().select(0, false);  

	};


	/**
	 * @param tableItem
	 */
	public void fireSelection(JobOccurrencesModel tableItem) {
		System.out.println("selected "+tableItem.getName());
	}

	private void onSelectionChange(SelectionChangedEvent<BeanModel> se) {  
		if (se.getSelection().size() > 0) {  
			detailTp.overwrite(details.getElement(), Util.getJsObject(se.getSelection().get(0)));  
			this.getButtonById("ok").enable();  
		} else {  
			this.getButtonById("ok").disable();  
			details.el().setInnerHtml("");  
		}  
	}  

	private native String getTemplate(String base) /*-{ 
		    return [
		    '<tpl for=".">', 
		    	'<div class="thumb-wrap tableSelector-item" id="{name}" style="border: 1px solid white">', 
		    	'<img src='+base+'"images/templateIcons/{type}_tn.png"/><span class="x-editable">{tableName}</span></div>', 
		    '</tpl>'
			].join(""); 
		  }-*/;  

	/**
	 * @return
	 */
	private native String getDetailTemplate(String base) /*-{ 
    	return [
    	'<div class="tableSelector-details">', 
    	'<tpl for=".">', 
    		'<b>Table Name: </b>{Name}<br/><br/>', 
    		'<b>Table Id: </b>{jobIdentifier}<br/><br/>', 
    		'<b>Description: </b>{Description}<br/><br/>', 
    	'</tpl>', 
    	'</div>'].join(""); 
  	}-*/;

	public void setListTable(List<JobOccurrencesModel> listTable2) {
		this.listTable = listTable2;
		store.removeAll();
		store.add(listTable2);
		this.layout();

	}
}
