/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TableItem;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TabularParameter;
import org.gcube.portlets.user.tdw.client.TabularData;
import org.gcube.portlets.user.tdw.client.util.ColumnPositionComparator;
import org.gcube.portlets.user.tdw.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdw.shared.model.TableDefinition;

import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;


/**
 * @author ceras
 *
 */
public class TabularField extends AbstractField {
	
	private VerticalPanel vp = new VerticalPanel();
	String value = null;
	TableSelector tableSelector;
	Button selectButton, selectButton2, cancelButton;
	Html templatesList;
	private JobOccurrencesModel selectedTableItem = null;
	private List<AbstractField> listeners = new ArrayList<AbstractField>();
	private List<JobOccurrencesModel> listTable = new ArrayList<JobOccurrencesModel>();

	/**
	 * @param parameter
	 */
	public TabularField(Parameter parameter, OccurrenceManagementServiceAsync service) {
		super(parameter);

		TabularParameter p = (TabularParameter)parameter;
		List<String> templates = p.getTemplates();
		
//		tableSelector = new TableSelector(templates, service) {
//			@Override
//			public void fireSelection(TableItem tableItem) {
//				super.fireSelection(tableItem);
//				selectedTableItem = tableItem;
//				showFieldWithSelection();
//				
//				// send change message to all listeners
//				// it will be managed by all columnFields and columnListField that depends by tabular field
//				updateListeners(tableItem.getId());
//			}
//		};
		
		tableSelector = new TableSelector(listTable){
			@Override
			public void fireSelection(JobOccurrencesModel occurrencesModel) {
				super.fireSelection(occurrencesModel);
				selectedTableItem = occurrencesModel;
				showFieldWithSelection();

				TableItem tableItem = new TableItem(occurrencesModel.getIdentifier(), occurrencesModel.getName(), occurrencesModel.getDescription(), "");
				
				loadTableMetadata(tableItem);
				// send change message to all listeners
				// it will be managed by all columnFields and columnListField that depends by tabular field
				updateListeners(tableItem);
			}
		};
		

		selectButton = new Button("Select Table", Resources.folderExplore(), new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				tableSelector.show();
			}
		});
		selectButton.setToolTip("Select Table");
		
		selectButton2 = new Button("", Resources.folderExplore(), new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				tableSelector.show();
			}
		});
		selectButton2.setToolTip("Select Another Table");
		
		cancelButton = new Button("", Resources.cancel(), new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				selectedTableItem = null;
				showNoSelectionField();
				updateListeners(null);
			}
		}); 

		String list = "";
		boolean first = true;
		for (String template: templates) {
			list += (first ? "" : ", ") + template;
			first = false;
		}
		templatesList = new Html("Suitable Table Templates: <br>"+ list);
		templatesList.addStyleName("workflow-templatesList");

		showNoSelectionField();		
	}

	/**
	 * @param tableItem
	 */
	protected void loadTableMetadata(final TableItem tableItem) {
		TabularData tabularData = new TabularData(ConstantsPortletOccurrence.TD_DATASOUCEFACTORY_ID);
		String tableId = tableItem.getId();
		tabularData.getTableDefinition(tableId, new AsyncCallback<TableDefinition>(){

			@Override
			public void onFailure(Throwable caught) {
				vp.unmask();
				Info.display("ERROR", "");
			}

			@Override
			public void onSuccess(TableDefinition tableDefinition) {
				vp.unmask();
				List<ColumnDefinition> columns = tableDefinition.getColumnsAsList();
				Collections.sort(columns, new ColumnPositionComparator(false));
				for (ColumnDefinition column: columns)
					tableItem.addColumnName(column.getLabel());
					updateListeners(tableItem);
			}

		});

		vp.mask("Load Table Metadata...");
	}

	/**
	 * @param id
	 */
	protected void updateListeners(TableItem tableItem) {
		for (AbstractField abstractField: listeners) {
			abstractField.fireEvent(tableItem);
		}
	}

	/**
	 * 
	 */
	private void showNoSelectionField() {
		vp.removeAll();
		vp.add(selectButton);
		vp.add(templatesList);
		vp.layout();
	}

	/**
	 * 
	 */
	private void showFieldWithSelection() {
		final String tableId = selectedTableItem.getIdentifier();
		final String tableName = selectedTableItem.getName();

		vp.removeAll();
		HorizontalPanel hp = new HorizontalPanel();
		hp.add(new Html("<div class='workflow-parameters-tableDescription'>"+ Format.ellipse(tableName, 30) +"</div>"));
		hp.add(selectButton2);
		hp.add(cancelButton);
		vp.add(hp);
		vp.add(templatesList);
		vp.layout();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getValue()
	 */
	@Override
	public String getValue() {
		return (selectedTableItem==null) ? null : selectedTableItem.getIdentifier();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#getComponent()
	 */
	@Override
	public Widget getWidget() {
		return vp;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.form.AbstractField#isValid()
	 */
	@Override
	public boolean isValid() {
		return (selectedTableItem!=null);
	}
	
	public void addChangeListener(AbstractField abstractField) {
		this.listeners.add(abstractField);
	}
	
	public void setListTable(List<JobOccurrencesModel> listTable){
		this.listTable = listTable;
		tableSelector.setListTable(listTable);
	}
}
